/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.IgniteCodeGeneratingFail;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

@IgniteCodeGeneratingFail
public class PartitionUpdateCountersMessage
implements Message {
    private static final int ITEM_SIZE = 20;
    private static final long serialVersionUID = 193442457510062844L;
    private byte[] data;
    private int cacheId;
    @GridDirectTransient
    private int size;

    public PartitionUpdateCountersMessage() {
    }

    public PartitionUpdateCountersMessage(int cacheId, int initSize) {
        assert (initSize >= 1);
        this.cacheId = cacheId;
        this.data = new byte[initSize * 20];
    }

    public int cacheId() {
        return this.cacheId;
    }

    public int size() {
        return this.size;
    }

    public int partition(int idx) {
        if (idx >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long off = GridUnsafe.BYTE_ARR_OFF + (long)(idx * 20);
        return GridUnsafe.getInt(this.data, off);
    }

    public long initialCounter(int idx) {
        if (idx >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long off = GridUnsafe.BYTE_ARR_OFF + (long)(idx * 20) + 4L;
        return GridUnsafe.getLong(this.data, off);
    }

    public void initialCounter(int idx, long value) {
        if (idx >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long off = GridUnsafe.BYTE_ARR_OFF + (long)(idx * 20) + 4L;
        GridUnsafe.putLong(this.data, off, value);
    }

    public long updatesCount(int idx) {
        if (idx >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        long off = GridUnsafe.BYTE_ARR_OFF + (long)(idx * 20) + 12L;
        return GridUnsafe.getLong(this.data, off);
    }

    public void add(int part, long init, long updatesCnt) {
        this.ensureSpace(this.size + 1);
        long off = GridUnsafe.BYTE_ARR_OFF + (long)(this.size++ * 20);
        GridUnsafe.putInt(this.data, off, part);
        GridUnsafe.putLong(this.data, off += 4L, init);
        GridUnsafe.putLong(this.data, off += 8L, updatesCnt);
    }

    public void clear() {
        this.size = 0;
    }

    private void ensureSpace(int newSize) {
        int req = newSize * 20;
        if (this.data.length < req) {
            this.data = Arrays.copyOf(this.data, this.data.length << 1);
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("cacheId", this.cacheId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByteArray("data", this.data, 0L, this.size * 20)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.cacheId = reader.readInt("cacheId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.data = reader.readByteArray("data");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.size = this.data.length / 20;
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(PartitionUpdateCountersMessage.class);
    }

    @Override
    public short directType() {
        return 157;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            sb.append("[part=").append(this.partition(i)).append(", initCntr=").append(this.initialCounter(i)).append(", cntr=").append(this.updatesCount(i)).append(']');
        }
        return "PartitionUpdateCountersMessage{cacheId=" + this.cacheId + ", size=" + this.size + ", cntrs=" + sb + '}';
    }
}

