/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.CacheDistributedGetFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearGetRequest;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class GridPartitionedGetFuture<K, V>
extends CacheDistributedGetFutureAdapter<K, V> {
    private String txLbl;
    protected final MvccSnapshot mvccSnapshot;

    public GridPartitionedGetFuture(GridCacheContext<K, V> cctx, Collection<KeyCacheObject> keys, boolean readThrough, boolean forcePrimary, @Nullable UUID subjId, String taskName, boolean deserializeBinary, boolean recovery, @Nullable IgniteCacheExpiryPolicy expiryPlc, boolean skipVals, boolean needVer, boolean keepCacheObjects, @Nullable String txLbl, @Nullable MvccSnapshot mvccSnapshot) {
        super(cctx, keys, readThrough, forcePrimary, subjId, taskName, deserializeBinary, expiryPlc, skipVals, needVer, keepCacheObjects, recovery);
        assert (mvccSnapshot == null == !cctx.mvccEnabled());
        this.mvccSnapshot = mvccSnapshot;
        this.txLbl = txLbl;
        this.initLogger(GridPartitionedGetFuture.class);
    }

    @Nullable
    private MvccSnapshot mvccSnapshot() {
        return this.mvccSnapshot;
    }

    public void init(AffinityTopologyVersion topVer) {
        AffinityTopologyVersion lockedTopVer = this.cctx.shared().lockedTopologyVersion(null);
        if (lockedTopVer != null) {
            topVer = lockedTopVer;
            this.canRemap = false;
        } else {
            topVer = topVer.topologyVersion() > 0L ? topVer : this.cctx.affinity().affinityTopologyVersion();
        }
        this.initialMap(topVer);
    }

    private void initialMap(AffinityTopologyVersion topVer) {
        this.map(this.keys, Collections.emptyMap(), topVer);
        this.markInitialized();
    }

    @Override
    public boolean onDone(Map<K, V> res, Throwable err) {
        if (super.onDone(res, err)) {
            if (this.trackable) {
                this.cctx.mvcc().removeFuture(this.futId);
            }
            this.cache().sendTtlUpdateRequest(this.expiryPlc);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isMini(IgniteInternalFuture<?> f) {
        return f.getClass().equals(MiniFuture.class);
    }

    @Override
    protected void map(Collection<KeyCacheObject> keys, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mapped, AffinityTopologyVersion topVer) {
        Collection<ClusterNode> cacheNodes = CU.affinityNodes(this.cctx, topVer);
        this.validate(cacheNodes, topVer);
        if (this.isDone()) {
            return;
        }
        HashMap<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mappings = U.newHashMap(cacheNodes.size());
        int keysSize = keys.size();
        HashMap locVals = U.newHashMap(keysSize);
        boolean hasRmtNodes = false;
        for (KeyCacheObject keyCacheObject : keys) {
            hasRmtNodes |= this.map(keyCacheObject, topVer, mappings, mapped, locVals);
        }
        if (this.isDone()) {
            return;
        }
        if (!locVals.isEmpty()) {
            this.add(new GridFinishedFuture(locVals));
        }
        if (hasRmtNodes) {
            this.registrateFutureInMvccManager(this);
        }
        for (Map.Entry entry : mappings.entrySet()) {
            ClusterNode n = (ClusterNode)entry.getKey();
            LinkedHashMap mappedKeys = (LinkedHashMap)entry.getValue();
            assert (!mappedKeys.isEmpty());
            if (n.isLocal()) {
                GridDhtFuture<Collection<GridCacheEntryInfo>> fut = this.cache().getDhtAsync(n.id(), -1L, mappedKeys, false, this.readThrough, topVer, this.subjId, this.taskName == null ? 0 : this.taskName.hashCode(), this.expiryPlc, this.skipVals, this.recovery, this.txLbl, this.mvccSnapshot());
                Collection<Integer> invalidParts = fut.invalidPartitions();
                if (!F.isEmpty(invalidParts)) {
                    ArrayList<KeyCacheObject> remapKeys = new ArrayList<KeyCacheObject>(keysSize);
                    for (KeyCacheObject key : keys) {
                        int part = this.cctx.affinity().partition(key);
                        if (key == null || !invalidParts.contains(part)) continue;
                        this.addNodeAsInvalid(n, part, topVer);
                        remapKeys.add(key);
                    }
                    AffinityTopologyVersion updTopVer = this.cctx.shared().exchange().readyAffinityVersion();
                    this.map(remapKeys, mappings, updTopVer);
                }
                this.add(fut.chain(f -> {
                    try {
                        return this.createResultMap((Collection)f.get());
                    }
                    catch (Exception e) {
                        U.error(log, "Failed to get values from dht cache [fut=" + fut + "]", e);
                        this.onDone(e);
                        return Collections.emptyMap();
                    }
                }));
                continue;
            }
            MiniFuture miniFut = new MiniFuture(n, (LinkedHashMap<KeyCacheObject, Boolean>)mappedKeys, topVer);
            GridNearGetRequest req = miniFut.createGetRequest(this.futId);
            this.add(miniFut);
            try {
                this.cctx.io().send(n, (GridCacheMessage)req, this.cctx.ioPolicy());
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    miniFut.onNodeLeft((ClusterTopologyCheckedException)e);
                    continue;
                }
                miniFut.onResult(e);
            }
        }
    }

    private boolean map(KeyCacheObject key, AffinityTopologyVersion topVer, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> nodesToKeysMapping, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> missedNodesToKeysMapping, Map<K, V> locVals) {
        boolean remote;
        int part = this.cctx.affinity().partition(key);
        List<ClusterNode> affNodes = this.cctx.affinity().nodesByPartition(part, topVer);
        if (affNodes.isEmpty()) {
            this.onDone(this.serverNotFoundError(part, topVer));
            return false;
        }
        if (this.tryLocalGet(key, part, topVer, affNodes, locVals)) {
            return false;
        }
        Set<ClusterNode> invalidNodeSet = this.getInvalidNodes(part, topVer);
        ClusterNode node = this.cctx.selectAffinityNodeBalanced(affNodes, invalidNodeSet, part, this.canRemap);
        if (node == null) {
            this.onDone(this.serverNotFoundError(part, topVer));
            return false;
        }
        boolean bl = remote = !node.isLocal();
        if (!this.checkRetryPermits(key, node, missedNodesToKeysMapping)) {
            return false;
        }
        this.addNodeMapping(key, node, nodesToKeysMapping);
        return remote;
    }

    private void addNodeMapping(KeyCacheObject key, ClusterNode node, Map<ClusterNode, LinkedHashMap<KeyCacheObject, Boolean>> mappings) {
        LinkedHashMap<KeyCacheObject, Boolean> old = mappings.get(node);
        if (old == null) {
            old = new LinkedHashMap(3, 1.0f);
            mappings.put(node, old);
        }
        old.put(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLocalGet(KeyCacheObject key, int part, AffinityTopologyVersion topVer, List<ClusterNode> affNodes, Map<K, V> locVals) {
        boolean fastLocGet;
        boolean bl = fastLocGet = !this.cctx.mvccEnabled() && (!this.forcePrimary || affNodes.get(0).isLocal()) && this.cctx.reserveForFastLocalGet(part, topVer);
        if (fastLocGet) {
            try {
                if (this.localGet(topVer, key, part, locVals)) {
                    boolean bl2 = true;
                    return bl2;
                }
            }
            finally {
                this.cctx.releaseForFastLocalGet(part, topVer);
            }
        }
        return false;
    }

    private boolean localGet(AffinityTopologyVersion topVer, KeyCacheObject key, int part, Map<K, V> locVals) {
        assert (this.cctx.affinityNode()) : this;
        GridDhtCacheAdapter<K, V> cache = this.cache();
        boolean readNoEntry = this.cctx.readNoEntry(this.expiryPlc, false);
        boolean evt = !this.skipVals;
        while (true) {
            try {
                boolean topStable;
                GridCacheEntryEx entry;
                boolean skipEntry = readNoEntry;
                EntryGetResult getRes = null;
                CacheObject v = null;
                GridCacheVersion ver = null;
                if (readNoEntry) {
                    CacheDataRow row;
                    CacheDataRow cacheDataRow = row = this.cctx.mvccEnabled() ? this.cctx.offheap().mvccRead(this.cctx, key, this.mvccSnapshot()) : this.cctx.offheap().read(this.cctx, key);
                    if (row != null) {
                        long expireTime = row.expireTime();
                        if (expireTime == 0L || expireTime > U.currentTimeMillis()) {
                            v = row.value();
                            if (this.needVer) {
                                ver = row.version();
                            }
                            if (evt) {
                                this.cctx.events().readEvent(key, null, this.txLbl, row.value(), this.subjId, this.taskName, !this.deserializeBinary);
                            }
                        } else {
                            skipEntry = false;
                        }
                    }
                }
                if (!skipEntry && (entry = cache.entryEx(key)) != null) {
                    boolean isNew = entry.isNewLocked();
                    if (this.needVer) {
                        getRes = entry.innerGetVersioned(null, null, false, evt, this.subjId, null, this.taskName, this.expiryPlc, !this.deserializeBinary, null);
                        if (getRes != null) {
                            v = (CacheObject)getRes.value();
                            ver = getRes.version();
                        }
                    } else {
                        v = entry.innerGet(null, null, false, false, evt, this.subjId, null, this.taskName, this.expiryPlc, !this.deserializeBinary);
                    }
                    entry.touch();
                    if (v == null && isNew && entry.markObsoleteIfEmpty(ver)) {
                        cache.removeEntry(entry);
                    }
                }
                if (v != null) {
                    this.cctx.addResult(locVals, key, v, this.skipVals, this.keepCacheObjects, this.deserializeBinary, true, getRes, ver, 0L, 0L, this.needVer);
                    return true;
                }
                boolean bl = topStable = this.cctx.isReplicated() || topVer.equals(this.cctx.topology().lastTopologyChangeVersion());
                if (!this.cctx.readThroughConfigured() && (topStable || this.partitionOwned(part))) {
                    if (!this.skipVals && this.cctx.statisticsEnabled()) {
                        cache.metrics0().onRead(false);
                    }
                    return true;
                }
                return false;
            }
            catch (GridCacheEntryRemovedException skipEntry) {
                continue;
            }
            catch (GridDhtInvalidPartitionException ignored) {
                return false;
            }
            catch (IgniteCheckedException e) {
                this.onDone(e);
                return true;
            }
            break;
        }
    }

    private void validate(Collection<ClusterNode> cacheNodes, AffinityTopologyVersion topVer) {
        Throwable err;
        if (cacheNodes.isEmpty()) {
            this.onDone(new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid) [topVer=" + topVer + ", cache=" + this.cctx.name() + ']'));
            return;
        }
        GridDhtTopologyFuture topFut = this.cctx.shared().exchange().lastFinishedFuture();
        Throwable throwable = err = topFut != null ? topFut.validateCache(this.cctx, this.recovery, true, null, this.keys) : null;
        if (err != null) {
            this.onDone(err);
        }
    }

    private GridDhtCacheAdapter<K, V> cache() {
        return this.cctx.dht();
    }

    private Map<K, V> createResultMap(Collection<GridCacheEntryInfo> infos) {
        int keysSize = infos.size();
        if (keysSize != 0) {
            GridLeanMap map = new GridLeanMap(keysSize);
            for (GridCacheEntryInfo info : infos) {
                assert (this.skipVals == (info.value() == null));
                this.cctx.addResult(map, info.key(), info.value(), this.skipVals, this.keepCacheObjects, this.deserializeBinary, false, this.needVer ? info.version() : null, 0L, 0L);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    @Override
    public String toString() {
        return S.toString(GridPartitionedGetFuture.class, this, "super", super.toString());
    }

    private class MiniFuture
    extends CacheDistributedGetFutureAdapter.AbstractMiniFuture {
        public MiniFuture(ClusterNode node, LinkedHashMap<KeyCacheObject, Boolean> keys, AffinityTopologyVersion topVer) {
            super(node, keys, topVer);
        }

        @Override
        protected GridNearGetRequest createGetRequest0(IgniteUuid rootFutId, IgniteUuid futId) {
            return new GridNearGetRequest(GridPartitionedGetFuture.this.cctx.cacheId(), rootFutId, futId, null, this.keys, GridPartitionedGetFuture.this.readThrough, this.topVer, GridPartitionedGetFuture.this.subjId, GridPartitionedGetFuture.this.taskName == null ? 0 : GridPartitionedGetFuture.this.taskName.hashCode(), GridPartitionedGetFuture.this.expiryPlc != null ? GridPartitionedGetFuture.this.expiryPlc.forCreate() : -1L, GridPartitionedGetFuture.this.expiryPlc != null ? GridPartitionedGetFuture.this.expiryPlc.forAccess() : -1L, false, GridPartitionedGetFuture.this.skipVals, GridPartitionedGetFuture.this.cctx.deploymentEnabled(), GridPartitionedGetFuture.this.recovery, GridPartitionedGetFuture.this.txLbl, GridPartitionedGetFuture.this.mvccSnapshot());
        }

        @Override
        protected Map<K, V> createResultMap(Collection<GridCacheEntryInfo> entries) {
            return GridPartitionedGetFuture.this.createResultMap(entries);
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this);
        }
    }
}

