/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxRemoteAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteSingleStateImpl;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteState;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteStateImpl;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedHashMap;

public class GridDhtTxRemote
extends GridDistributedTxRemoteAdapter {
    private static final long serialVersionUID = 0L;
    private UUID nearNodeId;
    private IgniteUuid rmtFutId;
    private GridCacheVersion nearXidVer;
    private boolean storeWriteThrough;

    public GridDhtTxRemote() {
    }

    public GridDhtTxRemote(GridCacheSharedContext ctx, UUID nearNodeId, IgniteUuid rmtFutId, UUID nodeId, AffinityTopologyVersion topVer, GridCacheVersion xidVer, GridCacheVersion commitVer, boolean sys, byte plc, TransactionConcurrency concurrency, TransactionIsolation isolation, boolean invalidate, long timeout, int txSize, GridCacheVersion nearXidVer, Map<UUID, Collection<UUID>> txNodes, @Nullable UUID subjId, int taskNameHash, boolean single, boolean storeWriteThrough, @Nullable String txLbl) {
        super(ctx, nodeId, xidVer, commitVer, sys, plc, concurrency, isolation, invalidate, timeout, txSize, subjId, taskNameHash, txLbl);
        assert (nearNodeId != null);
        assert (rmtFutId != null);
        this.nearNodeId = nearNodeId;
        this.rmtFutId = rmtFutId;
        this.nearXidVer = nearXidVer;
        this.txNodes = txNodes;
        this.storeWriteThrough = storeWriteThrough;
        IgniteTxRemoteState igniteTxRemoteState = this.txState = single ? new IgniteTxRemoteSingleStateImpl() : new IgniteTxRemoteStateImpl(Collections.emptyMap(), new ConcurrentLinkedHashMap<IgniteTxKey, IgniteTxEntry>(U.capacity(txSize), 0.75f, 1));
        assert (topVer != null && topVer.topologyVersion() > 0L) : topVer;
        this.topologyVersion(topVer);
    }

    public GridDhtTxRemote(GridCacheSharedContext ctx, UUID nearNodeId, IgniteUuid rmtFutId, UUID nodeId, GridCacheVersion nearXidVer, AffinityTopologyVersion topVer, GridCacheVersion xidVer, GridCacheVersion commitVer, boolean sys, byte plc, TransactionConcurrency concurrency, TransactionIsolation isolation, boolean invalidate, long timeout, int txSize, @Nullable UUID subjId, int taskNameHash, boolean storeWriteThrough, @Nullable String txLbl) {
        super(ctx, nodeId, xidVer, commitVer, sys, plc, concurrency, isolation, invalidate, timeout, txSize, subjId, taskNameHash, txLbl);
        assert (nearNodeId != null);
        assert (rmtFutId != null);
        this.nearXidVer = nearXidVer;
        this.nearNodeId = nearNodeId;
        this.rmtFutId = rmtFutId;
        this.storeWriteThrough = storeWriteThrough;
        this.txState = new IgniteTxRemoteStateImpl(Collections.emptyMap(), new ConcurrentLinkedHashMap<IgniteTxKey, IgniteTxEntry>(U.capacity(txSize), 0.75f, 1));
        assert (topVer != null && topVer.topologyVersion() > 0L) : topVer;
        this.topologyVersion(topVer);
    }

    @Override
    public void transactionNodes(Map<UUID, Collection<UUID>> txNodes) {
        this.txNodes = txNodes;
    }

    @Override
    public boolean remote() {
        return true;
    }

    @Override
    public boolean dht() {
        return true;
    }

    @Override
    public boolean storeWriteThrough() {
        return this.storeWriteThrough;
    }

    @Override
    public UUID eventNodeId() {
        return this.nearNodeId();
    }

    @Override
    public Collection<UUID> masterNodeIds() {
        ArrayList<UUID> res = new ArrayList<UUID>(2);
        res.add(this.nearNodeId);
        res.add(this.nodeId);
        return res;
    }

    @Override
    public UUID otherNodeId() {
        return this.nearNodeId;
    }

    @Override
    public GridCacheVersion nearXidVersion() {
        return this.nearXidVer;
    }

    public UUID nearNodeId() {
        return this.nearNodeId;
    }

    IgniteUuid remoteFutureId() {
        return this.rmtFutId;
    }

    protected boolean updateNearCache(GridCacheContext cacheCtx, KeyCacheObject key, AffinityTopologyVersion topVer) {
        if (!cacheCtx.isDht() || !GridCacheUtils.isNearEnabled(cacheCtx) || this.cctx.localNodeId().equals(this.nearNodeId)) {
            return false;
        }
        if (cacheCtx.config().getBackups() == 0) {
            return true;
        }
        return !cacheCtx.affinity().backupsByKey(key, topVer).contains(this.cctx.localNode());
    }

    public void addInvalidPartition(GridCacheContext cacheCtx, int part) {
        super.addInvalidPartition(cacheCtx, part);
        this.txState.invalidPartition(part);
    }

    public void addWrite(IgniteTxEntry entry, ClassLoader ldr) throws IgniteCheckedException {
        entry.unmarshal(this.cctx, false, ldr);
        GridCacheContext<?, ?> cacheCtx = entry.context();
        try {
            GridDhtCacheEntry cached = cacheCtx.dht().entryExx(entry.key(), this.topologyVersion());
            this.checkInternal(entry.txKey());
            entry.cached(cached);
            this.txState.addWriteEntry(entry.txKey(), entry);
            this.addExplicit(entry);
        }
        catch (GridDhtInvalidPartitionException e) {
            this.addInvalidPartition((GridCacheContext)cacheCtx, e.partition());
        }
    }

    public void addWrite(GridCacheContext cacheCtx, GridCacheOperation op, IgniteTxKey key, @Nullable CacheObject val, @Nullable Collection<T2<EntryProcessor<Object, Object, Object>, Object[]>> entryProcessors, long ttl, boolean skipStore, boolean keepBinary) {
        this.checkInternal(key);
        if (this.isSystemInvalidate()) {
            return;
        }
        GridDhtCacheEntry cached = cacheCtx.dht().entryExx(key.key(), this.topologyVersion());
        IgniteTxEntry txEntry = new IgniteTxEntry(cacheCtx, this, op, val, ttl, -1L, cached, null, skipStore, keepBinary);
        txEntry.entryProcessors(entryProcessors);
        this.txState.addWriteEntry(key, txEntry);
    }

    @Override
    public String toString() {
        return GridToStringBuilder.toString(GridDhtTxRemote.class, this, "super", super.toString());
    }
}

