/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteDiagnosticAware;
import org.apache.ignite.internal.IgniteDiagnosticPrepareContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheCompoundIdentityFuture;
import org.apache.ignite.internal.processors.cache.GridCacheFuture;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.mvcc.MvccFuture;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionState;

public final class GridDhtTxFinishFuture<K, V>
extends GridCacheCompoundIdentityFuture<IgniteInternalTx>
implements GridCacheFuture<IgniteInternalTx>,
IgniteDiagnosticAware {
    private static final long serialVersionUID = 0L;
    private static final AtomicReference<IgniteLogger> logRef = new AtomicReference();
    private static final AtomicReferenceFieldUpdater<GridDhtTxFinishFuture, Throwable> ERR_UPD = AtomicReferenceFieldUpdater.newUpdater(GridDhtTxFinishFuture.class, Throwable.class, "err");
    private static IgniteLogger log;
    private static IgniteLogger msgLog;
    private GridCacheSharedContext<K, V> cctx;
    private final IgniteUuid futId;
    @GridToStringExclude
    private GridDhtTxLocalAdapter tx;
    private boolean commit;
    @GridToStringExclude
    private volatile Throwable err;
    private Map<UUID, GridDistributedTxMapping> dhtMap;
    private Map<UUID, GridDistributedTxMapping> nearMap;

    public GridDhtTxFinishFuture(GridCacheSharedContext<K, V> cctx, GridDhtTxLocalAdapter tx, boolean commit) {
        super(F.identityReducer(tx));
        this.cctx = cctx;
        this.tx = tx;
        this.commit = commit;
        this.dhtMap = tx.dhtMap();
        this.nearMap = tx.nearMap();
        this.futId = IgniteUuid.randomUuid();
        if (log == null) {
            msgLog = cctx.txFinishMessageLogger();
            log = U.logger(cctx.kernalContext(), logRef, GridDhtTxFinishFuture.class);
        }
    }

    public GridDhtTxLocalAdapter tx() {
        return this.tx;
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        for (IgniteInternalFuture fut : this.futures()) {
            MiniFuture f;
            if (!this.isMini(fut) || !(f = (MiniFuture)fut).node().id().equals(nodeId)) continue;
            f.onNodeLeft();
            return true;
        }
        return false;
    }

    @Override
    public boolean trackable() {
        return true;
    }

    @Override
    public void markNotTrackable() {
        assert (false);
    }

    public void rollbackOnError(Throwable e) {
        assert (e != null);
        if (ERR_UPD.compareAndSet(this, null, e)) {
            this.tx.setRollbackOnly();
            if (X.hasCause(e, NodeStoppingException.class) || this.cctx.kernalContext().failure().nodeStopping()) {
                this.onComplete();
            } else {
                this.finish(false);
            }
        }
    }

    public void onResult(UUID nodeId, GridDhtTxFinishResponse res) {
        if (!this.isDone()) {
            boolean found = false;
            for (IgniteInternalFuture fut : this.futures()) {
                MiniFuture f;
                if (!this.isMini(fut) || (f = (MiniFuture)fut).futureId() != res.miniId()) continue;
                found = true;
                assert (f.node().id().equals(nodeId));
                f.onResult(res);
            }
            if (!found && msgLog.isDebugEnabled()) {
                msgLog.debug("DHT finish fut, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
            }
        } else if (msgLog.isDebugEnabled()) {
            msgLog.debug("DHT finish fut, failed to find mini future [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nodeId + ", res=" + res + ", fut=" + this + ']');
        }
    }

    @Override
    public boolean onDone(IgniteInternalTx tx, Throwable err) {
        if (this.initialized() || err != null) {
            Throwable finishErr;
            Throwable e;
            block8: {
                e = this.err;
                if (this.tx.onePhaseCommit() && this.tx.state() == TransactionState.COMMITTING) {
                    try {
                        boolean nodeStopping = X.hasCause(err, NodeStoppingException.class);
                        this.tx.tmFinish(err == null, nodeStopping || this.cctx.kernalContext().failure().nodeStopping(), false);
                    }
                    catch (IgniteCheckedException finishErr2) {
                        U.error(log, "Failed to finish tx: " + tx, e);
                        if (e != null) break block8;
                        e = finishErr2;
                    }
                }
            }
            if (this.commit && e == null) {
                e = this.tx.commitError();
            }
            Throwable throwable = finishErr = e != null ? e : err;
            if (super.onDone(tx, finishErr)) {
                this.cctx.tm().mvccFinish(this.tx);
                if (finishErr == null) {
                    finishErr = this.tx.commitError();
                }
                if (this.tx.syncMode() != CacheWriteSynchronizationMode.PRIMARY_SYNC) {
                    this.tx.sendFinishReply(finishErr);
                }
                this.cctx.mvcc().removeFuture(this.futId);
                return true;
            }
        }
        return false;
    }

    private boolean isMini(IgniteInternalFuture<?> f) {
        return f.getClass().equals(MiniFuture.class);
    }

    private void onComplete() {
        this.onDone(this.tx, this.err);
    }

    public void finish(boolean commit) {
        assert (!this.tx.txState().mvccEnabled() || this.tx.mvccSnapshot() != null);
        boolean sync = !F.isEmpty(this.dhtMap) || !F.isEmpty(this.nearMap) ? this.finish(commit, this.dhtMap, this.nearMap) : (!commit && !F.isEmpty(this.tx.lockTransactionNodes()) ? this.rollbackLockTransactions(this.tx.lockTransactionNodes()) : false);
        this.markInitialized();
        if (!sync) {
            this.onComplete();
        }
    }

    private boolean rollbackLockTransactions(Collection<ClusterNode> nodes) {
        boolean sync;
        assert (!F.isEmpty(nodes));
        if (this.tx.onePhaseCommit()) {
            return false;
        }
        boolean bl = sync = this.tx.syncMode() == CacheWriteSynchronizationMode.FULL_SYNC;
        if (this.tx.explicitLock() || this.tx.queryEnlisted()) {
            sync = true;
        }
        boolean res = false;
        int miniId = 0;
        for (ClusterNode n : nodes) {
            assert (!n.isLocal());
            MiniFuture fut = new MiniFuture(++miniId, n);
            this.add(fut);
            GridDhtTxFinishRequest req = new GridDhtTxFinishRequest(this.tx.nearNodeId(), this.futId, fut.futureId(), this.tx.topologyVersion(), this.tx.xidVersion(), this.tx.commitVersion(), this.tx.threadId(), this.tx.isolation(), false, this.tx.isInvalidate(), this.tx.system(), this.tx.ioPolicy(), this.tx.isSystemInvalidate(), sync ? CacheWriteSynchronizationMode.FULL_SYNC : this.tx.syncMode(), this.tx.completedBase(), this.tx.committedVersions(), this.tx.rolledbackVersions(), this.tx.pendingVersions(), this.tx.size(), this.tx.subjectId(), this.tx.taskNameHash(), this.tx.activeCachesDeploymentEnabled(), false, false, this.tx.mvccSnapshot(), this.cctx.tm().txHandler().filterUpdateCountersForBackupNode(this.tx, n));
            try {
                this.cctx.io().send(n, (GridCacheMessage)req, this.tx.ioPolicy());
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT finish fut, sent request lock tx [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + n.id() + ']');
                }
                if (sync) {
                    res = true;
                    continue;
                }
                fut.onDone();
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    fut.onNodeLeft((ClusterTopologyCheckedException)e);
                    continue;
                }
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT finish fut, failed to send request lock tx [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + n.id() + ", err=" + e + ']');
                }
                fut.onResult(e);
            }
        }
        return res;
    }

    private boolean finish(boolean commit, Map<UUID, GridDistributedTxMapping> dhtMap, Map<UUID, GridDistributedTxMapping> nearMap) {
        boolean sync;
        if (this.tx.onePhaseCommit()) {
            return false;
        }
        assert (!commit || !this.tx.txState().mvccEnabled() || this.tx.mvccSnapshot() != null || F.isEmpty(this.tx.writeEntries()));
        boolean bl = sync = this.tx.syncMode() == CacheWriteSynchronizationMode.FULL_SYNC;
        if (this.tx.explicitLock() || this.tx.queryEnlisted()) {
            sync = true;
        }
        boolean res = false;
        int miniId = 0;
        MvccSnapshot mvccSnapshot = this.tx.mvccSnapshot();
        if (mvccSnapshot != null) {
            mvccSnapshot = mvccSnapshot.withoutActiveTransactions();
        }
        for (GridDistributedTxMapping dhtMapping : dhtMap.values()) {
            ClusterNode n = dhtMapping.primary();
            assert (!n.isLocal());
            GridDistributedTxMapping nearMapping = nearMap.get(n.id());
            if (!dhtMapping.queryUpdate() && dhtMapping.empty() && nearMapping != null && nearMapping.empty()) continue;
            MiniFuture fut = new MiniFuture(++miniId, dhtMapping, nearMapping);
            this.add(fut);
            ArrayList<Long> updCntrs = new ArrayList<Long>(dhtMapping.entries().size());
            for (IgniteTxEntry e : dhtMapping.entries()) {
                updCntrs.add(e.updateCounter());
            }
            GridDhtTxFinishRequest req = new GridDhtTxFinishRequest(this.tx.nearNodeId(), this.futId, fut.futureId(), this.tx.topologyVersion(), this.tx.xidVersion(), this.tx.commitVersion(), this.tx.threadId(), this.tx.isolation(), commit, this.tx.isInvalidate(), this.tx.system(), this.tx.ioPolicy(), this.tx.isSystemInvalidate(), sync ? CacheWriteSynchronizationMode.FULL_SYNC : this.tx.syncMode(), this.tx.completedBase(), this.tx.committedVersions(), this.tx.rolledbackVersions(), this.tx.pendingVersions(), this.tx.size(), this.tx.subjectId(), this.tx.taskNameHash(), this.tx.activeCachesDeploymentEnabled(), updCntrs, false, false, mvccSnapshot, commit ? null : this.cctx.tm().txHandler().filterUpdateCountersForBackupNode(this.tx, n));
            req.writeVersion(this.tx.writeVersion() != null ? this.tx.writeVersion() : this.tx.xidVersion());
            try {
                this.cctx.io().send(n, (GridCacheMessage)req, this.tx.ioPolicy());
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT finish fut, sent request dht [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + n.id() + ']');
                }
                if (sync) {
                    res = true;
                    continue;
                }
                fut.onDone();
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    fut.onNodeLeft((ClusterTopologyCheckedException)e);
                    continue;
                }
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT finish fut, failed to send request dht [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + n.id() + ", err=" + e + ']');
                }
                fut.onResult(e);
            }
        }
        for (GridDistributedTxMapping nearMapping : nearMap.values()) {
            if (dhtMap.containsKey(nearMapping.primary().id()) || nearMapping.empty()) continue;
            MiniFuture fut = new MiniFuture(++miniId, null, nearMapping);
            this.add(fut);
            GridDhtTxFinishRequest req = new GridDhtTxFinishRequest(this.tx.nearNodeId(), this.futId, fut.futureId(), this.tx.topologyVersion(), this.tx.xidVersion(), this.tx.commitVersion(), this.tx.threadId(), this.tx.isolation(), commit, this.tx.isInvalidate(), this.tx.system(), this.tx.ioPolicy(), this.tx.isSystemInvalidate(), sync ? CacheWriteSynchronizationMode.FULL_SYNC : this.tx.syncMode(), this.tx.completedBase(), this.tx.committedVersions(), this.tx.rolledbackVersions(), this.tx.pendingVersions(), this.tx.size(), this.tx.subjectId(), this.tx.taskNameHash(), this.tx.activeCachesDeploymentEnabled(), false, false, mvccSnapshot, null);
            req.writeVersion(this.tx.writeVersion());
            try {
                this.cctx.io().send(nearMapping.primary(), (GridCacheMessage)req, this.tx.ioPolicy());
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT finish fut, sent request near [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nearMapping.primary().id() + ']');
                }
                if (sync) {
                    res = true;
                    continue;
                }
                fut.onDone();
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    fut.onNodeLeft((ClusterTopologyCheckedException)e);
                    continue;
                }
                if (msgLog.isDebugEnabled()) {
                    msgLog.debug("DHT finish fut, failed to send request near [txId=" + this.tx.nearXidVersion() + ", dhtTxId=" + this.tx.xidVersion() + ", node=" + nearMapping.primary().id() + ", err=" + e + ']');
                }
                fut.onResult(e);
            }
        }
        return res;
    }

    @Override
    public void addDiagnosticRequest(IgniteDiagnosticPrepareContext ctx) {
        if (!this.isDone()) {
            for (IgniteInternalFuture fut : this.futures()) {
                GridFutureAdapter f;
                if (fut.isDone()) continue;
                if (MiniFuture.class.isInstance(fut)) {
                    f = (MiniFuture)fut;
                    if (((MiniFuture)f).node().isLocal()) continue;
                    GridCacheVersion dhtVer = this.tx.xidVersion();
                    GridCacheVersion nearVer = this.tx.nearXidVersion();
                    ctx.remoteTxInfo(((MiniFuture)f).node().id(), dhtVer, nearVer, "GridDhtTxFinishFuture waiting for response [node=" + ((MiniFuture)f).node().id() + ", topVer=" + this.tx.topologyVersion() + ", dhtVer=" + dhtVer + ", nearVer=" + nearVer + ", futId=" + this.futId + ", miniId=" + ((MiniFuture)f).futId + ", tx=" + this.tx + ']');
                    return;
                }
                if (!(fut instanceof MvccFuture)) continue;
                f = (MvccFuture)fut;
                if (this.cctx.localNodeId().equals(((MvccFuture)f).coordinatorNodeId())) continue;
                ctx.basicInfo(((MvccFuture)f).coordinatorNodeId(), "GridDhtTxFinishFuture waiting for mvcc coordinator reply [mvccCrdNode=" + ((MvccFuture)f).coordinatorNodeId() + ", loc=" + ((MvccFuture)f).coordinatorNodeId().equals(this.cctx.localNodeId()) + ']');
                return;
            }
        }
    }

    @Override
    public String toString() {
        Collection futs = F.viewReadOnly(this.futures(), new C1<IgniteInternalFuture<?>, String>(){

            @Override
            public String apply(IgniteInternalFuture<?> f) {
                if (f.getClass() == MiniFuture.class) {
                    return "[node=" + ((MiniFuture)f).node().id() + ", loc=" + ((MiniFuture)f).node().isLocal() + ", done=" + f.isDone() + "]";
                }
                if (f instanceof MvccFuture) {
                    MvccFuture crdFut = (MvccFuture)f;
                    return "[mvccCrdNode=" + crdFut.coordinatorNodeId() + ", loc=" + crdFut.coordinatorNodeId().equals(GridDhtTxFinishFuture.this.cctx.localNodeId()) + ", done=" + f.isDone() + "]";
                }
                return f.toString();
            }
        }, new IgnitePredicate[0]);
        return S.toString(GridDhtTxFinishFuture.class, this, "xidVer", (Object)this.tx.xidVersion(), "innerFuts", futs, "super", super.toString());
    }

    private class MiniFuture
    extends GridFutureAdapter<IgniteInternalTx> {
        private final int futId;
        @GridToStringInclude
        private GridDistributedTxMapping dhtMapping;
        @GridToStringInclude
        private GridDistributedTxMapping nearMapping;
        @GridToStringInclude
        private ClusterNode node;

        private MiniFuture(int futId, ClusterNode node) {
            this.futId = futId;
            this.node = node;
        }

        MiniFuture(int futId, GridDistributedTxMapping dhtMapping, GridDistributedTxMapping nearMapping) {
            assert (dhtMapping == null || nearMapping == null || dhtMapping.primary().equals(nearMapping.primary()));
            this.futId = futId;
            this.dhtMapping = dhtMapping;
            this.nearMapping = nearMapping;
        }

        int futureId() {
            return this.futId;
        }

        public ClusterNode node() {
            return this.node != null ? this.node : (this.dhtMapping != null ? this.dhtMapping.primary() : this.nearMapping.primary());
        }

        void onResult(Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to get future result [fut=" + this + ", err=" + e + ']');
            }
            this.onDone(e);
        }

        void onNodeLeft(ClusterTopologyCheckedException e) {
            this.onNodeLeft();
        }

        void onNodeLeft() {
            if (msgLog.isDebugEnabled()) {
                msgLog.debug("DHT finish fut, mini future node left [txId=" + GridDhtTxFinishFuture.this.tx.nearXidVersion() + ", dhtTxId=" + GridDhtTxFinishFuture.this.tx.xidVersion() + ", node=" + this.node().id() + ']');
            }
            this.onDone(GridDhtTxFinishFuture.this.tx);
        }

        void onResult(GridDhtTxFinishResponse res) {
            if (log.isDebugEnabled()) {
                log.debug("Transaction synchronously completed on node [node=" + this.node() + ", res=" + res + ']');
            }
            this.onDone();
        }

        @Override
        public String toString() {
            return S.toString(MiniFuture.class, this, "done", (Object)this.isDone(), "cancelled", this.isCancelled(), "err", this.error());
        }
    }
}

