/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.PartitionLossPolicy;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.TopologyValidator;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheInvalidStateException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public abstract class GridDhtTopologyFutureAdapter
extends GridFutureAdapter<AffinityTopologyVersion>
implements GridDhtTopologyFuture {
    protected volatile Map<Integer, CacheGroupValidation> grpValidRes = Collections.emptyMap();
    protected volatile boolean clusterIsActive = true;

    protected final CacheGroupValidation validateCacheGroup(CacheGroupContext grp, Collection<ClusterNode> topNodes) {
        TopologyValidator validator;
        List lostParts = grp.isLocal() ? Collections.emptyList() : grp.topology().lostPartitions();
        boolean valid = true;
        if (!grp.systemCache() && (validator = grp.topologyValidator()) != null) {
            valid = validator.validate(topNodes);
        }
        return new CacheGroupValidation(valid, lostParts);
    }

    @Override
    @Nullable
    public final Throwable validateCache(GridCacheContext cctx, boolean recovery, boolean read, @Nullable Object key, @Nullable Collection<?> keys) {
        assert (this.isDone()) : this;
        Throwable err = this.error();
        if (err != null) {
            return err;
        }
        if (!this.clusterIsActive) {
            return new CacheInvalidStateException("Failed to perform cache operation (cluster is not activated): " + cctx.name());
        }
        OperationType opType = read ? OperationType.READ : OperationType.WRITE;
        CacheGroupContext grp = cctx.group();
        PartitionLossPolicy lossPlc = grp.config().getPartitionLossPolicy();
        if (cctx.shared().readOnlyMode() && opType == OperationType.WRITE) {
            return new IgniteCheckedException("Failed to perform cache operation (cluster is in read only mode)");
        }
        if (grp.needsRecovery() && !recovery && opType == OperationType.WRITE && (lossPlc == PartitionLossPolicy.READ_ONLY_SAFE || lossPlc == PartitionLossPolicy.READ_ONLY_ALL)) {
            return new IgniteCheckedException("Failed to write to cache (cache is moved to a read-only state): " + cctx.name());
        }
        CacheGroupValidation validation = this.grpValidRes.get(grp.groupId());
        if (validation == null) {
            return null;
        }
        if (opType == OperationType.WRITE && !validation.isValid()) {
            return new IgniteCheckedException("Failed to perform cache operation (cache topology is not valid): " + cctx.name());
        }
        if (recovery) {
            return null;
        }
        if (validation.hasLostPartitions()) {
            if (key != null) {
                return LostPolicyValidator.validate(cctx, key, opType, validation.lostPartitions());
            }
            if (keys != null) {
                return LostPolicyValidator.validate(cctx, keys, opType, validation.lostPartitions());
            }
        }
        return null;
    }

    public static class LostPolicyValidator {
        public static Throwable validate(GridCacheContext cctx, Object key, OperationType opType, Collection<Integer> lostParts) {
            CacheGroupContext grp = cctx.group();
            PartitionLossPolicy lostPlc = grp.config().getPartitionLossPolicy();
            int partition = cctx.affinity().partition(key);
            return LostPolicyValidator.validate(cctx, key, partition, opType, lostPlc, lostParts);
        }

        public static Throwable validate(GridCacheContext cctx, Collection<?> keys, OperationType opType, Collection<Integer> lostParts) {
            CacheGroupContext grp = cctx.group();
            PartitionLossPolicy lostPlc = grp.config().getPartitionLossPolicy();
            for (Object key : keys) {
                int partition;
                Throwable res = LostPolicyValidator.validate(cctx, key, partition = cctx.affinity().partition(key), opType, lostPlc, lostParts);
                if (res == null) continue;
                return res;
            }
            return null;
        }

        private static Throwable validate(GridCacheContext cctx, Object key, int partition, OperationType opType, PartitionLossPolicy lostPlc, Collection<Integer> lostParts) {
            if (opType == OperationType.WRITE) {
                if (lostPlc == PartitionLossPolicy.READ_ONLY_SAFE || lostPlc == PartitionLossPolicy.READ_ONLY_ALL) {
                    return new IgniteCheckedException("Failed to write to cache (cache is moved to a read-only state): " + cctx.name());
                }
                if (lostParts.contains(partition) && lostPlc == PartitionLossPolicy.READ_WRITE_SAFE) {
                    return new CacheInvalidStateException("Failed to execute cache operation (all partition owners have left the grid, partition data has been lost) [cacheName=" + cctx.name() + ", part=" + partition + ", key=" + key + ']');
                }
            }
            if (opType == OperationType.READ && lostParts.contains(partition) && (lostPlc == PartitionLossPolicy.READ_ONLY_SAFE || lostPlc == PartitionLossPolicy.READ_WRITE_SAFE)) {
                return new CacheInvalidStateException("Failed to execute cache operation (all partition owners have left the grid, partition data has been lost) [cacheName=" + cctx.name() + ", part=" + partition + ", key=" + key + ']');
            }
            return null;
        }
    }

    public static enum OperationType {
        READ,
        WRITE;

    }

    protected static class CacheGroupValidation {
        private final boolean valid;
        private final Collection<Integer> lostParts;

        private CacheGroupValidation(boolean valid, Collection<Integer> lostParts) {
            this.valid = valid;
            this.lostParts = lostParts;
        }

        public boolean isValid() {
            return this.valid;
        }

        public boolean hasLostPartitions() {
            return !F.isEmpty(this.lostParts);
        }

        public Collection<Integer> lostPartitions() {
            return this.lostParts;
        }
    }
}

