/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.lang.IgniteFuture;
import org.jetbrains.annotations.Nullable;

public class GridCacheTxFinishSync<K, V> {
    private GridCacheSharedContext<K, V> cctx;
    private IgniteLogger log;
    private ConcurrentMap<Long, ThreadFinishSync> threadMap = new ConcurrentHashMap<Long, ThreadFinishSync>();

    public GridCacheTxFinishSync(GridCacheSharedContext<K, V> cctx) {
        this.cctx = cctx;
        this.log = cctx.logger(GridCacheTxFinishSync.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinishSend(UUID nodeId, long threadId) {
        ThreadFinishSync threadSync = (ThreadFinishSync)this.threadMap.get(threadId);
        if (threadSync == null) {
            threadSync = new ThreadFinishSync(threadId);
            this.threadMap.put(threadId, threadSync);
        }
        ThreadFinishSync threadFinishSync = threadSync;
        synchronized (threadFinishSync) {
            if (this.threadMap.get(threadId) == null) {
                threadSync = new ThreadFinishSync(threadId);
                this.threadMap.put(threadId, threadSync);
            }
            threadSync.onSend(nodeId);
        }
    }

    public IgniteInternalFuture<?> awaitAckAsync(UUID nodeId, long threadId) {
        ThreadFinishSync threadSync = (ThreadFinishSync)this.threadMap.get(threadId);
        if (threadSync == null) {
            return null;
        }
        return threadSync.awaitAckAsync(nodeId);
    }

    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        for (ThreadFinishSync threadSync : this.threadMap.values()) {
            threadSync.onDisconnected(reconnectFut);
        }
        this.threadMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAckReceived(UUID nodeId, long threadId) {
        ThreadFinishSync threadSync = (ThreadFinishSync)this.threadMap.get(threadId);
        if (threadSync != null) {
            threadSync.onReceive(nodeId);
            ThreadFinishSync threadFinishSync = threadSync;
            synchronized (threadFinishSync) {
                if (threadSync.isEmpty()) {
                    this.threadMap.remove(threadId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNodeLeft(UUID nodeId) {
        for (ThreadFinishSync threadSync : this.threadMap.values()) {
            threadSync.onNodeLeft(nodeId);
            ThreadFinishSync threadFinishSync = threadSync;
            synchronized (threadFinishSync) {
                if (threadSync.isEmpty()) {
                    this.threadMap.remove(threadSync);
                }
            }
        }
    }

    private class TxFinishSync {
        private final UUID nodeId;
        private final long threadId;
        private int cnt;
        private boolean nodeLeft;
        private GridFutureAdapter<?> pendingFut;

        private TxFinishSync(UUID nodeId, long threadId) {
            this.nodeId = nodeId;
            this.threadId = threadId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSend() {
            TxFinishSync txFinishSync = this;
            synchronized (txFinishSync) {
                if (GridCacheTxFinishSync.this.log.isTraceEnabled()) {
                    GridCacheTxFinishSync.this.log.trace("Moved transaction synchronizer to waiting state [nodeId=" + this.nodeId + ", threadId=" + this.threadId + ']');
                }
                assert (this.cnt == 0 || this.nodeLeft) : this.cnt;
                if (this.nodeLeft) {
                    return;
                }
                this.cnt = 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public IgniteInternalFuture<?> awaitAckAsync() {
            TxFinishSync txFinishSync = this;
            synchronized (txFinishSync) {
                if (this.cnt == 0) {
                    return null;
                }
                if (this.nodeLeft) {
                    return new GridFinishedFuture(new IgniteCheckedException("Failed to wait for finish synchronizer state (node left grid): " + this.nodeId));
                }
                if (this.pendingFut == null) {
                    if (GridCacheTxFinishSync.this.log.isTraceEnabled()) {
                        GridCacheTxFinishSync.this.log.trace("Creating transaction synchronizer future [nodeId=" + this.nodeId + ", threadId=" + this.threadId + ']');
                    }
                    this.pendingFut = new GridFutureAdapter();
                }
                return this.pendingFut;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive() {
            TxFinishSync txFinishSync = this;
            synchronized (txFinishSync) {
                if (GridCacheTxFinishSync.this.log.isTraceEnabled()) {
                    GridCacheTxFinishSync.this.log.trace("Moving transaction synchronizer to completed state [nodeId=" + this.nodeId + ", threadId=" + this.threadId + ']');
                }
                this.cnt = 0;
                if (this.pendingFut != null) {
                    this.pendingFut.onDone();
                    this.pendingFut = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNodeLeft() {
            TxFinishSync txFinishSync = this;
            synchronized (txFinishSync) {
                this.nodeLeft = true;
                if (this.pendingFut != null) {
                    this.pendingFut.onDone(new IgniteCheckedException("Failed to wait for transaction synchronizer completed state (node left grid): " + this.nodeId));
                    this.pendingFut = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDisconnected(IgniteFuture<?> reconnectFut) {
            TxFinishSync txFinishSync = this;
            synchronized (txFinishSync) {
                this.nodeLeft = true;
                if (this.pendingFut != null) {
                    IgniteClientDisconnectedCheckedException err = new IgniteClientDisconnectedCheckedException(reconnectFut, "Failed to wait for transaction synchronizer, client node disconnected: " + this.nodeId);
                    this.pendingFut.onDone(err);
                    this.pendingFut = null;
                }
            }
        }
    }

    private class ThreadFinishSync {
        private long threadId;
        private final Map<UUID, TxFinishSync> nodeMap = new ConcurrentHashMap<UUID, TxFinishSync>();

        private ThreadFinishSync(long threadId) {
            this.threadId = threadId;
        }

        public void onSend(UUID nodeId) {
            TxFinishSync sync = this.nodeMap.get(nodeId);
            if (sync == null) {
                sync = new TxFinishSync(nodeId, this.threadId);
                TxFinishSync old = this.nodeMap.put(nodeId, sync);
                assert (old == null) : "Only user thread can add sync objects to the map.";
                if (GridCacheTxFinishSync.this.cctx.discovery().node(nodeId) == null) {
                    sync.onNodeLeft();
                    this.nodeMap.remove(nodeId);
                } else if (GridCacheTxFinishSync.this.cctx.kernalContext().clientDisconnected()) {
                    sync.onDisconnected(GridCacheTxFinishSync.this.cctx.kernalContext().cluster().clientReconnectFuture());
                    this.nodeMap.remove(nodeId);
                }
            }
            sync.onSend();
        }

        public IgniteInternalFuture<?> awaitAckAsync(UUID nodeId) {
            TxFinishSync sync = this.nodeMap.get(nodeId);
            if (sync == null) {
                return null;
            }
            return sync.awaitAckAsync();
        }

        public void onDisconnected(IgniteFuture<?> reconnectFut) {
            for (TxFinishSync sync : this.nodeMap.values()) {
                sync.onDisconnected(reconnectFut);
            }
            this.nodeMap.clear();
        }

        public void onReceive(UUID nodeId) {
            TxFinishSync sync = this.nodeMap.remove(nodeId);
            if (sync != null) {
                sync.onReceive();
            }
        }

        public void onNodeLeft(UUID nodeId) {
            TxFinishSync sync = this.nodeMap.remove(nodeId);
            if (sync != null) {
                sync.onNodeLeft();
            }
        }

        private boolean isEmpty() {
            return this.nodeMap.isEmpty();
        }
    }
}

