/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class StartCacheInfo {
    private final CacheConfiguration startedConf;
    private final DynamicCacheDescriptor desc;
    @Nullable
    private final NearCacheConfiguration reqNearCfg;
    private final AffinityTopologyVersion exchTopVer;
    private final boolean disabledAfterStart;

    public StartCacheInfo(DynamicCacheDescriptor desc, NearCacheConfiguration reqNearCfg, AffinityTopologyVersion exchTopVer, boolean disabledAfterStart) {
        this(desc.cacheConfiguration(), desc, reqNearCfg, exchTopVer, disabledAfterStart);
    }

    public StartCacheInfo(CacheConfiguration conf, DynamicCacheDescriptor desc, NearCacheConfiguration reqNearCfg, AffinityTopologyVersion exchTopVer, boolean disabledAfterStart) {
        this.startedConf = conf;
        this.desc = desc;
        this.reqNearCfg = reqNearCfg;
        this.exchTopVer = exchTopVer;
        this.disabledAfterStart = disabledAfterStart;
    }

    public CacheConfiguration getStartedConfiguration() {
        return this.startedConf;
    }

    public DynamicCacheDescriptor getCacheDescriptor() {
        return this.desc;
    }

    @Nullable
    public NearCacheConfiguration getReqNearCfg() {
        return this.reqNearCfg;
    }

    public AffinityTopologyVersion getExchangeTopVer() {
        return this.exchTopVer;
    }

    public boolean isDisabledAfterStart() {
        return this.disabledAfterStart;
    }

    public String toString() {
        return S.toString(StartCacheInfo.class, this);
    }
}

