/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheTtlManager;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;

public class GridCacheSharedTtlCleanupManager
extends GridCacheSharedManagerAdapter {
    private static final long CLEANUP_WORKER_SLEEP_INTERVAL = 500L;
    private static final int CLEANUP_WORKER_ENTRIES_PROCESS_LIMIT = 1000;
    private CleanupWorker cleanupWorker;
    private final Object mux = new Object();
    private List<GridCacheTtlManager> mgrs = new CopyOnWriteArrayList<GridCacheTtlManager>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onKernalStop0(boolean cancel) {
        Object object = this.mux;
        synchronized (object) {
            this.stopCleanupWorker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(GridCacheTtlManager mgr) {
        Object object = this.mux;
        synchronized (object) {
            if (this.cleanupWorker == null) {
                this.startCleanupWorker();
            }
            this.mgrs.add(mgr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(GridCacheTtlManager mgr) {
        Object object = this.mux;
        synchronized (object) {
            this.mgrs.remove(mgr);
            if (this.mgrs.isEmpty()) {
                this.stopCleanupWorker();
            }
        }
    }

    public boolean eagerTtlEnabled() {
        assert (this.cctx != null) : "Manager is not started";
        return this.cleanupWorker != null;
    }

    private void startCleanupWorker() {
        this.cleanupWorker = new CleanupWorker();
        new IgniteThread(this.cleanupWorker).start();
    }

    private void stopCleanupWorker() {
        if (null != this.cleanupWorker) {
            U.cancel(this.cleanupWorker);
            U.join(this.cleanupWorker, this.log);
            this.cleanupWorker = null;
        }
    }

    static /* synthetic */ List access$000(GridCacheSharedTtlCleanupManager x0) {
        return x0.mgrs;
    }

    private class CleanupWorker
    extends GridWorker {
        CleanupWorker() {
            super(GridCacheSharedTtlCleanupManager.this.cctx.igniteInstanceName(), "ttl-cleanup-worker", GridCacheSharedTtlCleanupManager.this.cctx.logger(GridCacheSharedTtlCleanupManager.class), GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().workersRegistry());
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            block21: {
                block20: {
                    err = null;
                    try {
                        this.blockingSectionBegin();
                        try {
                            GridCacheSharedTtlCleanupManager.this.cctx.discovery().localJoin();
                        }
                        finally {
                            this.blockingSectionEnd();
                        }
                        if (!CleanupWorker.$assertionsDisabled && GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().recoveryMode()) {
                            throw new AssertionError();
                        }
lbl14:
                        // 3 sources

                        while (!this.isCancelled()) {
                            expiredRemains = false;
                            for (GridCacheTtlManager mgr : GridCacheSharedTtlCleanupManager.access$000(GridCacheSharedTtlCleanupManager.this)) {
                                this.updateHeartbeat();
                                if (mgr.expire(1000)) {
                                    expiredRemains = true;
                                }
                                if (!this.isCancelled()) continue;
                                if (err == null && !this.isCancelled) {
                                    err = new IllegalStateException("Thread " + this.name() + " is terminated unexpectedly");
                                }
                                break block20;
                            }
                            ** GOTO lbl-1000
                        }
                        break block21;
                    }
                    catch (Throwable t) {
                        try {
                            if (X.hasCause(t, new Class[]{IgniteInterruptedCheckedException.class, InterruptedException.class}) != false) throw t;
                            err = t;
                            throw t;
                        }
                        catch (Throwable var5_7) {
                            if (err == null && !this.isCancelled) {
                                err = new IllegalStateException("Thread " + this.name() + " is terminated unexpectedly");
                            }
                            if (err instanceof OutOfMemoryError) {
                                GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                                throw var5_7;
                            }
                            if (err == null) throw var5_7;
                            GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                            throw var5_7;
                        }
                    }
                }
                if (err instanceof OutOfMemoryError) {
                    GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                    return;
                }
                if (err == null) return;
                GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                return;
lbl-1000:
                // 1 sources

                {
                    this.updateHeartbeat();
                    if (!expiredRemains) {
                        U.sleep(500L);
                    }
                    this.onIdle();
                    ** GOTO lbl14
                }
            }
            if (err == null && !this.isCancelled) {
                err = new IllegalStateException("Thread " + this.name() + " is terminated unexpectedly");
            }
            if (err instanceof OutOfMemoryError) {
                GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                return;
            }
            if (err == null) return;
            GridCacheSharedTtlCleanupManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
        }
    }
}

