/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.cache.Cache;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheEntry;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheGateway;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.affinity.GridCacheAffinityProxy;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrInfo;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.mxbean.CacheMetricsMXBean;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class GridCacheProxyImpl<K, V>
implements IgniteInternalCache<K, V>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private GridCacheContext<K, V> ctx;
    private GridCacheGateway<K, V> gate;
    @GridToStringExclude
    private IgniteInternalCache<K, V> delegate;
    @GridToStringExclude
    private CacheOperationContext opCtx;
    private Affinity<K> aff;

    public GridCacheProxyImpl() {
    }

    public GridCacheProxyImpl(GridCacheContext<K, V> ctx, IgniteInternalCache<K, V> delegate, @Nullable CacheOperationContext opCtx) {
        assert (ctx != null);
        assert (delegate != null);
        this.ctx = ctx;
        this.delegate = delegate;
        this.opCtx = opCtx;
        this.gate = ctx.gate();
        this.aff = new GridCacheAffinityProxy<K, V>(ctx, ctx.cache().affinity());
    }

    @Override
    public GridCacheContext<K, V> context() {
        return this.ctx;
    }

    public IgniteInternalCache<K, V> delegate() {
        return this.delegate;
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public <K1, V1> IgniteInternalCache<K1, V1> cache() {
        return this.delegate.cache();
    }

    @Override
    public boolean skipStore() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.opCtx != null && this.opCtx.skipStore();
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public Affinity<K> affinity() {
        return this.aff;
    }

    @Override
    public CacheMetrics clusterMetrics() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            CacheMetrics cacheMetrics = this.delegate.clusterMetrics();
            return cacheMetrics;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheMetrics clusterMetrics(ClusterGroup grp) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            CacheMetrics cacheMetrics = this.delegate.clusterMetrics(grp);
            return cacheMetrics;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public CacheConfiguration configuration() {
        return this.delegate.configuration();
    }

    @Override
    public CacheMetrics localMetrics() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            CacheMetrics cacheMetrics = this.delegate.localMetrics();
            return cacheMetrics;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public CacheMetricsMXBean clusterMxBean() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            CacheMetricsMXBean cacheMetricsMXBean = this.delegate.clusterMxBean();
            return cacheMetricsMXBean;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public CacheMetricsMXBean localMxBean() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            CacheMetricsMXBean cacheMetricsMXBean = this.delegate.localMxBean();
            return cacheMetricsMXBean;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void localLoadCache(IgniteBiPredicate<K, V> p, @Nullable Object[] args) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.delegate.localLoadCache(p, args);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<?> localLoadCacheAsync(IgniteBiPredicate<K, V> p, @Nullable Object[] args) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.delegate.localLoadCacheAsync(p, args);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public void preloadPartition(int part) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.delegate.preloadPartition(part);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<?> preloadPartitionAsync(int part) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.delegate.preloadPartitionAsync(part);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean localPreloadPartition(int part) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.localPreloadPartition(part);
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public GridCacheProxyImpl<K, V> forSubjectId(UUID subjId) {
        return new GridCacheProxyImpl<K, V>(this.ctx, this.delegate, this.opCtx != null ? this.opCtx.forSubjectId(subjId) : new CacheOperationContext(false, subjId, false, null, false, null, false, CacheOperationContext.DFLT_ALLOW_ATOMIC_OPS_IN_TX));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCacheProxyImpl<K, V> setSkipStore(boolean skipStore) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            if (this.opCtx != null && this.opCtx.skipStore() == skipStore) {
                GridCacheProxyImpl gridCacheProxyImpl = this;
                return gridCacheProxyImpl;
            }
            GridCacheProxyImpl<K, V> gridCacheProxyImpl = new GridCacheProxyImpl<K, V>(this.ctx, this.delegate, this.opCtx != null ? this.opCtx.setSkipStore(skipStore) : new CacheOperationContext(true, null, false, null, false, null, false, CacheOperationContext.DFLT_ALLOW_ATOMIC_OPS_IN_TX));
            return gridCacheProxyImpl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public <K1, V1> GridCacheProxyImpl<K1, V1> keepBinary() {
        if (this.opCtx != null && this.opCtx.isKeepBinary()) {
            return this;
        }
        return new GridCacheProxyImpl<K, V>(this.ctx, (GridCacheAdapter)this.delegate, this.opCtx != null ? this.opCtx.keepBinary() : new CacheOperationContext(false, null, true, null, false, null, false, CacheOperationContext.DFLT_ALLOW_ATOMIC_OPS_IN_TX));
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(K key) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.containsKey(key);
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKeys(Collection<? extends K> keys) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.containsKeys(keys);
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Boolean> containsKeyAsync(K key) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Boolean> igniteInternalFuture = this.delegate.containsKeyAsync(key);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Boolean> containsKeysAsync(Collection<? extends K> keys) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Boolean> igniteInternalFuture = this.delegate.containsKeysAsync(keys);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V get(K key) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            V v = this.delegate.get(key);
            return v;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CacheEntry<K, V> getEntry(K key) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            CacheEntry<K, V> cacheEntry = this.delegate.getEntry(key);
            return cacheEntry;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<V> getAsync(K key) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<V> igniteInternalFuture = this.delegate.getAsync(key);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<CacheEntry<K, V>> getEntryAsync(K key) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<CacheEntry<K, V>> igniteInternalFuture = this.delegate.getEntryAsync(key);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getForcePrimary(K key) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            V v = this.delegate.getForcePrimary(key);
            return v;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<V> getForcePrimaryAsync(K key) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<V> igniteInternalFuture = this.delegate.getForcePrimaryAsync(key);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Map<K, V> getAllOutTx(Set<? extends K> keys) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            Map<? extends K, V> map = this.delegate.getAllOutTx(keys);
            return map;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public IgniteInternalFuture<Map<K, V>> getAllOutTxAsync(Set<? extends K> keys) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Map<K, V>> igniteInternalFuture = this.delegate.getAllOutTxAsync(keys);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public boolean isIgfsDataCache() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.isIgfsDataCache();
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long igfsDataSpaceUsed() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            long l = this.delegate.igfsDataSpaceUsed();
            return l;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> getAll(@Nullable Collection<? extends K> keys) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            Map<? extends K, V> map = this.delegate.getAll(keys);
            return map;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CacheEntry<K, V>> getEntries(@Nullable Collection<? extends K> keys) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            Collection<CacheEntry<K, V>> collection = this.delegate.getEntries(keys);
            return collection;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Map<K, V>> getAllAsync(@Nullable Collection<? extends K> keys) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Map<K, V>> igniteInternalFuture = this.delegate.getAllAsync(keys);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Collection<CacheEntry<K, V>>> getEntriesAsync(@Nullable Collection<? extends K> keys) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Collection<CacheEntry<K, V>>> igniteInternalFuture = this.delegate.getEntriesAsync(keys);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V getAndPut(K key, V val) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            V v = this.delegate.getAndPut(key, val);
            return v;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<V> getAndPutAsync(K key, V val) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<V> igniteInternalFuture = this.delegate.getAndPutAsync(key, val);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(K key, V val) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.put(key, val);
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public void putAllConflict(Map<KeyCacheObject, GridCacheDrInfo> drMap) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.delegate.putAllConflict(drMap);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<?> putAllConflictAsync(Map<KeyCacheObject, GridCacheDrInfo> drMap) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.delegate.putAllConflictAsync(drMap);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> EntryProcessorResult<T> invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            EntryProcessorResult<T> entryProcessorResult = this.delegate.invoke(key, entryProcessor, args);
            return entryProcessorResult;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> IgniteInternalFuture<EntryProcessorResult<T>> invokeAsync(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<EntryProcessorResult<T>> igniteInternalFuture = this.delegate.invokeAsync(key, entryProcessor, args);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            Map<? extends K, EntryProcessorResult<T>> map = this.delegate.invokeAll(keys, entryProcessor, args);
            return map;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> igniteInternalFuture = this.delegate.invokeAllAsync(keys, entryProcessor, args);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            Map map2 = this.delegate.invokeAll(map, args);
            return map2;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> igniteInternalFuture = this.delegate.invokeAllAsync(map, args);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Boolean> putAsync(K key, V val) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Boolean> igniteInternalFuture = this.delegate.putAsync(key, val);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V getAndPutIfAbsent(K key, V val) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            V v = this.delegate.getAndPutIfAbsent(key, val);
            return v;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<V> getAndPutIfAbsentAsync(K key, V val) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<V> igniteInternalFuture = this.delegate.getAndPutIfAbsentAsync(key, val);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putIfAbsent(K key, V val) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.putIfAbsent(key, val);
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Boolean> putIfAbsentAsync(K key, V val) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Boolean> igniteInternalFuture = this.delegate.putIfAbsentAsync(key, val);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V getAndReplace(K key, V val) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            V v = this.delegate.getAndReplace(key, val);
            return v;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<V> getAndReplaceAsync(K key, V val) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<V> igniteInternalFuture = this.delegate.getAndReplaceAsync(key, val);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V val) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.replace(key, val);
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Boolean> replaceAsync(K key, V val) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Boolean> igniteInternalFuture = this.delegate.replaceAsync(key, val);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldVal, V newVal) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.replace(key, oldVal, newVal);
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Boolean> replaceAsync(K key, V oldVal, V newVal) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Boolean> igniteInternalFuture = this.delegate.replaceAsync(key, oldVal, newVal);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public void putAll(@Nullable Map<? extends K, ? extends V> m) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.delegate.putAll(m);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<?> putAllAsync(@Nullable Map<? extends K, ? extends V> m) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.delegate.putAllAsync(m);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public Set<K> keySet() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            Set<K> set = this.delegate.keySet();
            return set;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public Set<Cache.Entry<K, V>> entrySet() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            Set<Cache.Entry<K, V>> set = this.delegate.entrySet();
            return set;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Cache.Entry<K, V>> scanIterator(boolean keepBinary, @Nullable IgniteBiPredicate<Object, Object> p) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            Iterator<Cache.Entry<K, V>> iterator = this.delegate.scanIterator(keepBinary, p);
            return iterator;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridNearTxLocal txStartEx(TransactionConcurrency concurrency, TransactionIsolation isolation) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            GridNearTxLocal gridNearTxLocal = this.delegate.txStartEx(concurrency, isolation);
            return gridNearTxLocal;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transaction txStart(TransactionConcurrency concurrency, TransactionIsolation isolation) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            Transaction transaction = this.delegate.txStart(concurrency, isolation);
            return transaction;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transaction txStart(TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, int txSize) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            Transaction transaction = this.delegate.txStart(concurrency, isolation, timeout, txSize);
            return transaction;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public GridNearTxLocal tx() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            GridNearTxLocal gridNearTxLocal = this.delegate.tx();
            return gridNearTxLocal;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V localPeek(K key, CachePeekMode[] peekModes) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            V v = this.delegate.localPeek(key, peekModes);
            return v;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Cache.Entry<K, V>> localEntries(CachePeekMode[] peekModes) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            Iterable<Cache.Entry<K, V>> iterable = this.delegate.localEntries(peekModes);
            return iterable;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean evict(K key) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.evict(key);
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public void evictAll(@Nullable Collection<? extends K> keys) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.delegate.evictAll(keys);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearLocally(boolean srv, boolean near, boolean readers) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.delegate.clearLocally(srv, near, readers);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public void clear() throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.delegate.clear();
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public IgniteInternalFuture<?> clearAsync() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.delegate.clearAsync();
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<?> clearAsync(K key) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.delegate.clearAsync(key);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<?> clearAllAsync(Set<? extends K> keys) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.delegate.clearAllAsync(keys);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clearLocally(K key) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.clearLocally(key);
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearLocallyAll(Set<? extends K> keys, boolean srv, boolean near, boolean readers) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.delegate.clearLocallyAll(keys, srv, near, readers);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public void clear(K key) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.delegate.clear(key);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public void clearAll(Set<? extends K> keys) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.delegate.clearAll(keys);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V getAndRemove(K key) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            V v = this.delegate.getAndRemove(key);
            return v;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<V> getAndRemoveAsync(K key) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<V> igniteInternalFuture = this.delegate.getAndRemoveAsync(key);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.remove(key);
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public void removeAllConflict(Map<KeyCacheObject, GridCacheVersion> drMap) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.delegate.removeAllConflict(drMap);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<?> removeAllConflictAsync(Map<KeyCacheObject, GridCacheVersion> drMap) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.delegate.removeAllConflictAsync(drMap);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Boolean> removeAsync(K key) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Boolean> igniteInternalFuture = this.delegate.removeAsync(key);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key, V val) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.remove(key, val);
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Boolean> removeAsync(K key, V val) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Boolean> igniteInternalFuture = this.delegate.removeAsync(key, val);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public void removeAll(@Nullable Collection<? extends K> keys) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.delegate.removeAll(keys);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<?> removeAllAsync(@Nullable Collection<? extends K> keys) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.delegate.removeAllAsync(keys);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> EntryProcessorResult<T> invoke(AffinityTopologyVersion topVer, K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            EntryProcessorResult<T> entryProcessorResult = this.delegate.invoke(topVer, key, entryProcessor, args);
            return entryProcessorResult;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public void removeAll() throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.delegate.removeAll();
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public IgniteInternalFuture<?> removeAllAsync() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.delegate.removeAllAsync();
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(K key, long timeout) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.lock(key, timeout);
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Boolean> lockAsync(K key, long timeout) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Boolean> igniteInternalFuture = this.delegate.lockAsync(key, timeout);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockAll(@Nullable Collection<? extends K> keys, long timeout) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.lockAll(keys, timeout);
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Boolean> lockAllAsync(@Nullable Collection<? extends K> keys, long timeout) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Boolean> igniteInternalFuture = this.delegate.lockAllAsync(keys, timeout);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public void unlock(K key) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.delegate.unlock(key);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public void unlockAll(@Nullable Collection<? extends K> keys) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            this.delegate.unlockAll(keys);
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocked(K key) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.isLocked(key);
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLockedByThread(K key) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            boolean bl = this.delegate.isLockedByThread(key);
            return bl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public int size() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sizeLong() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            long l = this.delegate.sizeLong();
            return l;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(CachePeekMode[] peekModes) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            int n = this.delegate.size(peekModes);
            return n;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sizeLong(CachePeekMode[] peekModes) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            long l = this.delegate.sizeLong(peekModes);
            return l;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sizeLong(int partition, CachePeekMode[] peekModes) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            long l = this.delegate.sizeLong(partition, peekModes);
            return l;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Integer> sizeAsync(CachePeekMode[] peekModes) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Integer> igniteInternalFuture = this.delegate.sizeAsync(peekModes);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Long> sizeLongAsync(CachePeekMode[] peekModes) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Long> igniteInternalFuture = this.delegate.sizeLongAsync(peekModes);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<Long> sizeLongAsync(int partition, CachePeekMode[] peekModes) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<Long> igniteInternalFuture = this.delegate.sizeLongAsync(partition, peekModes);
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int localSize(CachePeekMode[] peekModes) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            int n = this.delegate.localSize(peekModes);
            return n;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long localSizeLong(CachePeekMode[] peekModes) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            long l = this.delegate.localSizeLong(peekModes);
            return l;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long localSizeLong(int partition, CachePeekMode[] peekModes) throws IgniteCheckedException {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            long l = this.delegate.localSizeLong(partition, peekModes);
            return l;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public int nearSize() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            int n = this.delegate.nearSize();
            return n;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public int primarySize() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            int n = this.delegate.primarySize();
            return n;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long primarySizeLong() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            long l = this.delegate.primarySizeLong();
            return l;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long offHeapEntriesCount() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            long l = this.delegate.offHeapEntriesCount();
            return l;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long offHeapAllocatedSize() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            long l = this.delegate.offHeapAllocatedSize();
            return l;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            Iterator<Cache.Entry<K, V>> iterator = this.delegate.iterator();
            return iterator;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public IgniteInternalFuture<?> rebalance() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            IgniteInternalFuture<?> igniteInternalFuture = this.delegate.rebalance();
            return igniteInternalFuture;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    @Nullable
    public ExpiryPolicy expiry() {
        return this.opCtx != null ? this.opCtx.expiry() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCacheProxyImpl<K, V> withExpiryPolicy(ExpiryPolicy plc) {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            GridCacheProxyImpl<K, V> gridCacheProxyImpl = new GridCacheProxyImpl<K, V>(this.ctx, this.delegate, this.opCtx != null ? this.opCtx.withExpiryPolicy(plc) : new CacheOperationContext(false, null, false, plc, false, null, false, CacheOperationContext.DFLT_ALLOW_ATOMIC_OPS_IN_TX));
            return gridCacheProxyImpl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public IgniteInternalCache<K, V> withNoRetries() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            GridCacheProxyImpl<K, V> gridCacheProxyImpl = new GridCacheProxyImpl<K, V>(this.ctx, this.delegate, new CacheOperationContext(false, null, false, null, true, null, false, CacheOperationContext.DFLT_ALLOW_ATOMIC_OPS_IN_TX));
            return gridCacheProxyImpl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public Collection<Integer> lostPartitions() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            Collection<Integer> collection = this.delegate.lostPartitions();
            return collection;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public IgniteInternalCache<K, V> withAllowAtomicOpsInTx() {
        CacheOperationContext prev = this.gate.enter(this.opCtx);
        try {
            GridCacheProxyImpl<K, V> gridCacheProxyImpl = new GridCacheProxyImpl<K, V>(this.ctx, this.delegate, this.opCtx.setAllowAtomicOpsInTx());
            return gridCacheProxyImpl;
        }
        finally {
            this.gate.leave(prev);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx);
        out.writeObject(this.delegate);
        out.writeObject(this.opCtx);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ctx = (GridCacheContext)in.readObject();
        this.delegate = (IgniteInternalCache)in.readObject();
        this.opCtx = (CacheOperationContext)in.readObject();
        this.gate = this.ctx.gate();
        this.aff = new GridCacheAffinityProxy<K, V>(this.ctx, this.ctx.cache().affinity());
    }

    public String toString() {
        return S.toString(GridCacheProxyImpl.class, this);
    }
}

