/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheEvent;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class GridCacheEventManager
extends GridCacheManagerAdapter {
    private boolean forceKeepBinary;

    public void addListener(GridLocalEventListener lsnr, int ... evts) {
        this.cctx.gridEvents().addLocalEventListener(lsnr, evts);
    }

    public void removeListener(GridLocalEventListener lsnr) {
        this.cctx.gridEvents().removeLocalEventListener(lsnr, new int[0]);
    }

    public void readEvent(KeyCacheObject key, @Nullable IgniteInternalTx tx, @Nullable String txLbl, @Nullable CacheObject val, @Nullable UUID subjId, @Nullable String taskName, boolean keepBinary) {
        if (this.isRecordable(64)) {
            this.addEvent(this.cctx.affinity().partition(key), key, this.cctx.localNodeId(), tx, txLbl, null, 64, val, val != null, val, val != null, subjId, null, taskName, keepBinary);
        }
    }

    public void addEvent(int part, KeyCacheObject key, @Nullable IgniteInternalTx tx, @Nullable GridCacheMvccCandidate owner, int type, @Nullable CacheObject newVal, boolean hasNewVal, @Nullable CacheObject oldVal, boolean hasOldVal, UUID subjId, String cloClsName, String taskName, boolean keepBinary) {
        this.addEvent(part, key, this.cctx.localNodeId(), tx, owner, type, newVal, hasNewVal, oldVal, hasOldVal, subjId, cloClsName, taskName, keepBinary);
    }

    public void addEvent(int type) {
        this.addEvent(0, null, this.cctx.localNodeId(), null, null, null, type, null, false, null, false, null, null, null, false);
    }

    public void addEvent(int part, KeyCacheObject key, UUID nodeId, @Nullable IgniteInternalTx tx, GridCacheMvccCandidate owner, int type, CacheObject newVal, boolean hasNewVal, CacheObject oldVal, boolean hasOldVal, UUID subjId, String cloClsName, String taskName, boolean keepBinary) {
        this.addEvent(part, key, nodeId, tx, null, owner == null ? null : owner.version(), type, newVal, hasNewVal, oldVal, hasOldVal, subjId, cloClsName, taskName, keepBinary);
    }

    public void addEvent(int part, KeyCacheObject key, UUID evtNodeId, @Nullable GridCacheMvccCandidate owner, int type, @Nullable CacheObject newVal, boolean hasNewVal, CacheObject oldVal, boolean hasOldVal, UUID subjId, String cloClsName, String taskName, boolean keepBinary) {
        IgniteInternalTx tx = owner == null ? null : (IgniteInternalTx)this.cctx.tm().tx(owner.version());
        this.addEvent(part, key, evtNodeId, tx, null, owner == null ? null : owner.version(), type, newVal, hasNewVal, oldVal, hasOldVal, subjId, cloClsName, taskName, keepBinary);
    }

    public void addEvent(int part, KeyCacheObject key, UUID evtNodeId, @Nullable IgniteInternalTx tx, @Nullable String txLbl, @Nullable Object lockId, int type, @Nullable CacheObject newVal, boolean hasNewVal, @Nullable CacheObject oldVal, boolean hasOldVal, UUID subjId, @Nullable String cloClsName, @Nullable String taskName, boolean keepBinary) {
        assert (key != null || type == 98 || type == 99);
        if (!this.cctx.events().isRecordable(type)) {
            LT.warn(this.log, "Added event without checking if event is recordable: " + U.gridEventName(type));
        }
        if (key == null || !key.internal()) {
            Object oldVal0;
            Object val0;
            Object key0;
            ClusterNode evtNode = this.cctx.discovery().node(evtNodeId);
            if (evtNode == null) {
                evtNode = this.findNodeInHistory(evtNodeId);
            }
            if (evtNode == null) {
                LT.warn(this.log, "Failed to find event node in grid topology history (try to increase topology history size configuration property of configured discovery SPI): " + evtNodeId);
            }
            keepBinary = keepBinary || this.forceKeepBinary;
            try {
                key0 = this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(key, keepBinary, false);
                val0 = this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(newVal, keepBinary, false);
                oldVal0 = this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(oldVal, keepBinary, false);
            }
            catch (Exception e) {
                if (!this.cctx.cacheObjectContext().kernalContext().cacheObjects().isBinaryEnabled(this.cctx.config())) {
                    throw e;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to unmarshall cache object value for the event notification: " + e);
                }
                if (!this.forceKeepBinary) {
                    LT.warn(this.log, "Failed to unmarshall cache object value for the event notification (all further notifications will keep binary object format).");
                }
                this.forceKeepBinary = true;
                key0 = this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(key, true, false);
                val0 = this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(newVal, true, false);
                oldVal0 = this.cctx.cacheObjectContext().unwrapBinaryIfNeeded(oldVal, true, false);
            }
            IgniteUuid xid = tx == null ? null : tx.xid();
            String finalTxLbl = tx == null || tx.label() == null ? txLbl : tx.label();
            this.cctx.gridEvents().record(new CacheEvent(this.cctx.name(), this.cctx.localNode(), evtNode, "Cache event.", type, part, this.cctx.isNear(), key0, xid, finalTxLbl, lockId, val0, hasNewVal, oldVal0, hasOldVal, subjId, cloClsName, taskName));
        }
    }

    @Nullable
    private ClusterNode findNodeInHistory(UUID nodeId) {
        Collection<ClusterNode> top;
        for (long topVer = this.cctx.discovery().topologyVersion() - 1L; topVer > 0L && (top = this.cctx.discovery().topology(topVer)) != null; --topVer) {
            for (ClusterNode node : top) {
                if (!F.eq(node.id(), nodeId)) continue;
                return node;
            }
        }
        return null;
    }

    public boolean isRecordable(int type) {
        GridCacheContext cctx0 = this.cctx;
        if (cctx0 != null && cctx0.kernalContext().recoveryMode()) {
            return false;
        }
        return cctx0 != null && cctx0.userCache() && cctx0.gridEvents().isRecordable(type) && cctx0.config().isEventsDisabled() == false;
    }

    @Override
    public void printMemoryStats() {
        X.println(">>> ", new Object[0]);
        X.println(">>> Cache event manager memory stats [igniteInstanceName=" + this.cctx.igniteInstanceName() + ", cache=" + this.cctx.name() + ", stats=N/A" + ']', new Object[0]);
    }
}

