/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.AllocatedPageTracker;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.mxbean.CacheGroupMetricsMXBean;

public class CacheGroupMetricsMXBeanImpl
implements CacheGroupMetricsMXBean {
    private final CacheGroupContext ctx;
    private final GroupAllocationTracker groupPageAllocationTracker;

    public CacheGroupMetricsMXBeanImpl(CacheGroupContext ctx) {
        this.ctx = ctx;
        DataRegion region = ctx.dataRegion();
        if (region != null) {
            DataRegionMetricsImpl dataRegionMetrics = ctx.dataRegion().memoryMetrics();
            this.groupPageAllocationTracker = dataRegionMetrics.getOrAllocateGroupPageAllocationTracker(ctx.groupId());
        } else {
            this.groupPageAllocationTracker = new GroupAllocationTracker(AllocatedPageTracker.NO_OP);
        }
    }

    @Override
    public int getGroupId() {
        return this.ctx.groupId();
    }

    @Override
    public String getGroupName() {
        return this.ctx.name();
    }

    @Override
    public List<String> getCaches() {
        ArrayList<String> caches = new ArrayList<String>(this.ctx.caches().size());
        for (GridCacheContext cache : this.ctx.caches()) {
            caches.add(cache.name());
        }
        Collections.sort(caches);
        return caches;
    }

    @Override
    public int getBackups() {
        return this.ctx.config().getBackups();
    }

    @Override
    public int getPartitions() {
        return this.ctx.topology().partitions();
    }

    private int numberOfPartitionCopies(IntBiPredicate pred) {
        int parts = this.ctx.topology().partitions();
        GridDhtPartitionFullMap partFullMap = this.ctx.topology().partitionMap(false);
        int res = -1;
        for (int part = 0; part < parts; ++part) {
            int cnt = 0;
            for (Map.Entry entry : partFullMap.entrySet()) {
                if (((GridDhtPartitionMap)entry.getValue()).get(part) != GridDhtPartitionState.OWNING) continue;
                ++cnt;
            }
            if (part != 0 && !pred.apply(res, cnt)) continue;
            res = cnt;
        }
        return res;
    }

    @Override
    public int getMinimumNumberOfPartitionCopies() {
        return this.numberOfPartitionCopies(new IntBiPredicate(){

            @Override
            public boolean apply(int targetVal, int nextVal) {
                return nextVal < targetVal;
            }
        });
    }

    @Override
    public int getMaximumNumberOfPartitionCopies() {
        return this.numberOfPartitionCopies(new IntBiPredicate(){

            @Override
            public boolean apply(int targetVal, int nextVal) {
                return nextVal > targetVal;
            }
        });
    }

    private int nodePartitionsCountByState(UUID nodeId, GridDhtPartitionState state) {
        int parts = this.ctx.topology().partitions();
        GridDhtPartitionMap partMap = (GridDhtPartitionMap)this.ctx.topology().partitionMap(false).get(nodeId);
        int cnt = 0;
        for (int part = 0; part < parts; ++part) {
            if (partMap.get(part) != state) continue;
            ++cnt;
        }
        return cnt;
    }

    private int clusterPartitionsCountByState(GridDhtPartitionState state) {
        GridDhtPartitionFullMap partFullMap = this.ctx.topology().partitionMap(true);
        int cnt = 0;
        for (UUID nodeId : partFullMap.keySet()) {
            cnt += this.nodePartitionsCountByState(nodeId, state);
        }
        return cnt;
    }

    private int localNodePartitionsCountByState(GridDhtPartitionState state) {
        int cnt = 0;
        for (GridDhtLocalPartition part : this.ctx.topology().localPartitions()) {
            if (part.state() != state) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public int getLocalNodeOwningPartitionsCount() {
        return this.localNodePartitionsCountByState(GridDhtPartitionState.OWNING);
    }

    @Override
    public int getLocalNodeMovingPartitionsCount() {
        return this.localNodePartitionsCountByState(GridDhtPartitionState.MOVING);
    }

    @Override
    public int getLocalNodeRentingPartitionsCount() {
        return this.localNodePartitionsCountByState(GridDhtPartitionState.RENTING);
    }

    @Override
    public long getLocalNodeRentingEntriesCount() {
        long entriesCnt = 0L;
        for (GridDhtLocalPartition part : this.ctx.topology().localPartitions()) {
            if (part.state() != GridDhtPartitionState.RENTING) continue;
            entriesCnt += part.dataStore().fullSize();
        }
        return entriesCnt;
    }

    @Override
    public int getClusterOwningPartitionsCount() {
        return this.clusterPartitionsCountByState(GridDhtPartitionState.OWNING);
    }

    @Override
    public int getClusterMovingPartitionsCount() {
        return this.clusterPartitionsCountByState(GridDhtPartitionState.MOVING);
    }

    private Map<Integer, Set<String>> clusterPartitionsMapByState(GridDhtPartitionState state) {
        int parts = this.ctx.topology().partitions();
        GridDhtPartitionFullMap partFullMap = this.ctx.topology().partitionMap(false);
        LinkedHashMap<Integer, Set<String>> partsMap = new LinkedHashMap<Integer, Set<String>>();
        for (int part = 0; part < parts; ++part) {
            HashSet<String> partNodesSet = new HashSet<String>();
            for (Map.Entry entry : partFullMap.entrySet()) {
                if (((GridDhtPartitionMap)entry.getValue()).get(part) != state) continue;
                partNodesSet.add(((UUID)entry.getKey()).toString());
            }
            partsMap.put(part, partNodesSet);
        }
        return partsMap;
    }

    @Override
    public Map<Integer, Set<String>> getOwningPartitionsAllocationMap() {
        return this.clusterPartitionsMapByState(GridDhtPartitionState.OWNING);
    }

    @Override
    public Map<Integer, Set<String>> getMovingPartitionsAllocationMap() {
        return this.clusterPartitionsMapByState(GridDhtPartitionState.MOVING);
    }

    @Override
    public Map<Integer, List<String>> getAffinityPartitionsAssignmentMap() {
        AffinityAssignment assignment = this.ctx.affinity().cachedAffinity(AffinityTopologyVersion.NONE);
        int part = 0;
        LinkedHashMap<Integer, List<String>> assignmentMap = new LinkedHashMap<Integer, List<String>>();
        for (List<ClusterNode> partAssignment : assignment.assignment()) {
            ArrayList<String> partNodeIds = new ArrayList<String>(partAssignment.size());
            for (ClusterNode node : partAssignment) {
                partNodeIds.add(node.id().toString());
            }
            assignmentMap.put(part, partNodeIds);
            ++part;
        }
        return assignmentMap;
    }

    @Override
    public String getType() {
        CacheMode type = this.ctx.config().getCacheMode();
        return String.valueOf((Object)type);
    }

    @Override
    public List<Integer> getPartitionIds() {
        List<GridDhtLocalPartition> parts = this.ctx.topology().localPartitions();
        ArrayList<Integer> partsRes = new ArrayList<Integer>(parts.size());
        for (GridDhtLocalPartition part : parts) {
            partsRes.add(part.id());
        }
        return partsRes;
    }

    @Override
    public long getTotalAllocatedPages() {
        return this.groupPageAllocationTracker.totalAllocatedPages.longValue();
    }

    @Override
    public long getTotalAllocatedSize() {
        return this.getTotalAllocatedPages() * (long)this.ctx.dataRegion().pageMemory().pageSize();
    }

    public static class GroupAllocationTracker
    implements AllocatedPageTracker {
        private final LongAdder totalAllocatedPages = new LongAdder();
        private final AllocatedPageTracker delegate;

        public GroupAllocationTracker(AllocatedPageTracker delegate) {
            this.delegate = delegate;
        }

        @Override
        public void updateTotalAllocatedPages(long delta) {
            this.totalAllocatedPages.add(delta);
            this.delegate.updateTotalAllocatedPages(delta);
        }

        public void reset() {
            this.totalAllocatedPages.reset();
        }
    }

    private static interface IntBiPredicate {
        public boolean apply(int var1, int var2);
    }
}

