/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.affinity;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.BitSetIntSet;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgnitePredicate;

public class HistoryAffinityAssignment
implements AffinityAssignment {
    private final AffinityTopologyVersion topVer;
    private final List<List<ClusterNode>> assignment;
    private final List<List<ClusterNode>> idealAssignment;
    private final ClusterNode[] nodes;
    private final char[] idealParts;
    private final Map<Integer, char[]> assignmentDiff;

    public HistoryAffinityAssignment(AffinityAssignment assign, int backups) {
        this.topVer = assign.topologyVersion();
        if (IGNITE_DISABLE_AFFINITY_MEMORY_OPTIMIZATION || backups > IGNITE_AFFINITY_BACKUPS_THRESHOLD) {
            this.assignment = assign.assignment();
            this.idealAssignment = assign.idealAssignment();
            this.nodes = null;
            this.idealParts = null;
            this.assignmentDiff = null;
            return;
        }
        List<List<ClusterNode>> assignment = assign.assignment();
        List<List<ClusterNode>> idealAssignment = assign.idealAssignment();
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (List<ClusterNode> nodes : idealAssignment) {
            int size = nodes.size();
            if (size > max) {
                max = size;
            }
            if (size >= min) continue;
            min = size;
        }
        if (max != min) {
            this.assignment = assign.assignment();
            this.idealAssignment = assign.idealAssignment();
            this.nodes = null;
            this.idealParts = null;
            this.assignmentDiff = null;
            return;
        }
        final int cpys = max;
        boolean same = assignment == idealAssignment;
        final int partsCnt = assignment.size();
        this.idealParts = new char[partsCnt * cpys];
        HashMap<ClusterNode, Character> orderMap = new HashMap<ClusterNode, Character>();
        char order = '\u0001';
        this.assignmentDiff = new HashMap<Integer, char[]>();
        for (int p = 0; p < assignment.size(); ++p) {
            List<ClusterNode> curr = assignment.get(p);
            List<ClusterNode> ideal = idealAssignment.get(p);
            for (int i = 0; i < ideal.size(); ++i) {
                ClusterNode node = ideal.get(i);
                Character nodeOrder = (Character)orderMap.get(node);
                if (nodeOrder == null) {
                    char c = order;
                    order = (char)(order + 1);
                    nodeOrder = Character.valueOf(c);
                    orderMap.put(node, nodeOrder);
                }
                this.idealParts[p * cpys + i] = nodeOrder.charValue();
            }
            if (same || curr.equals(ideal)) continue;
            char[] idx = new char[curr.size()];
            this.assignmentDiff.put(p, idx);
            for (int i = 0; i < curr.size(); ++i) {
                ClusterNode node = curr.get(i);
                Character nodeOrder = (Character)orderMap.get(node);
                if (nodeOrder == null) {
                    char c = order;
                    order = (char)(order + '\u0001');
                    nodeOrder = Character.valueOf(c);
                    orderMap.put(node, nodeOrder);
                }
                idx[i] = nodeOrder.charValue();
            }
        }
        this.nodes = (ClusterNode[])orderMap.keySet().stream().toArray(ClusterNode[]::new);
        Arrays.sort(this.nodes, (o1, o2) -> ((Character)orderMap.get(o1)).compareTo((Character)orderMap.get(o2)));
        this.idealAssignment = new AbstractList<List<ClusterNode>>(){

            @Override
            public List<ClusterNode> get(int idx) {
                return HistoryAffinityAssignment.this.partitionNodes(idx, true, cpys);
            }

            @Override
            public int size() {
                return partsCnt;
            }
        };
        AbstractList<List<ClusterNode>> abstractList = this.assignment = same ? this.idealAssignment : new AbstractList<List<ClusterNode>>(){

            @Override
            public List<ClusterNode> get(int idx) {
                return HistoryAffinityAssignment.this.partitionNodes(idx, false, cpys);
            }

            @Override
            public int size() {
                return partsCnt;
            }
        };
        assert (this.assignment.equals(assign.assignment())) : "new=" + this.assignment + ", old=" + assign.assignment();
        assert (this.idealAssignment.equals(assign.idealAssignment())) : "new=" + this.idealAssignment + ", old=" + assign.idealAssignment();
    }

    private List<ClusterNode> partitionNodes(int p, boolean ideal, int cpys) {
        char ord;
        char[] order;
        if (!ideal && (order = this.assignmentDiff.get(p)) != null) {
            ArrayList<ClusterNode> ret = new ArrayList<ClusterNode>(order.length);
            for (int i = 0; i < order.length; ++i) {
                ret.add(this.nodes[order[i] - '\u0001']);
            }
            return ret;
        }
        ArrayList<ClusterNode> ret = new ArrayList<ClusterNode>(cpys);
        for (int i = 0; i < cpys && (ord = this.idealParts[p * cpys + i]) != '\u0000'; ++i) {
            ret.add(this.nodes[ord - '\u0001']);
        }
        return ret;
    }

    @Override
    public List<List<ClusterNode>> idealAssignment() {
        return this.idealAssignment;
    }

    @Override
    public List<List<ClusterNode>> assignment() {
        return this.assignment;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public List<ClusterNode> get(int part) {
        assert (part >= 0 && part < this.assignment.size()) : "Affinity partition is out of range [part=" + part + ", partitions=" + this.assignment.size() + ']';
        return this.assignment.get(part);
    }

    @Override
    public Collection<UUID> getIds(int part) {
        assert (part >= 0 && part < this.assignment.size()) : "Affinity partition is out of range [part=" + part + ", partitions=" + this.assignment.size() + ']';
        if (IGNITE_DISABLE_AFFINITY_MEMORY_OPTIMIZATION) {
            return this.assignments2ids(this.assignment.get(part));
        }
        List<ClusterNode> nodes = this.assignment.get(part);
        return nodes.size() > AffinityAssignment.IGNITE_AFFINITY_BACKUPS_THRESHOLD ? this.assignments2ids(nodes) : F.viewReadOnly(nodes, F.node2id(), new IgnitePredicate[0]);
    }

    @Override
    public Set<ClusterNode> nodes() {
        HashSet<ClusterNode> res = new HashSet<ClusterNode>();
        for (int p = 0; p < this.assignment.size(); ++p) {
            List<ClusterNode> nodes = this.assignment.get(p);
            if (F.isEmpty(nodes)) continue;
            res.addAll(nodes);
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<ClusterNode> primaryPartitionNodes() {
        HashSet<ClusterNode> res = new HashSet<ClusterNode>();
        for (int p = 0; p < this.assignment.size(); ++p) {
            List<ClusterNode> nodes = this.assignment.get(p);
            if (F.isEmpty(nodes)) continue;
            res.add(nodes.get(0));
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<Integer> primaryPartitions(UUID nodeId) {
        AbstractCollection res = IGNITE_DISABLE_AFFINITY_MEMORY_OPTIMIZATION ? new HashSet() : new BitSetIntSet();
        for (int p = 0; p < this.assignment.size(); ++p) {
            List<ClusterNode> nodes = this.assignment.get(p);
            if (F.isEmpty(nodes) || !nodes.get(0).id().equals(nodeId)) continue;
            res.add(p);
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<Integer> backupPartitions(UUID nodeId) {
        AbstractCollection res = IGNITE_DISABLE_AFFINITY_MEMORY_OPTIMIZATION ? new HashSet() : new BitSetIntSet();
        block0: for (int p = 0; p < this.assignment.size(); ++p) {
            List<ClusterNode> nodes = this.assignment.get(p);
            for (int i = 1; i < nodes.size(); ++i) {
                ClusterNode node = nodes.get(i);
                if (!node.id().equals(nodeId)) continue;
                res.add(p);
                continue block0;
            }
        }
        return Collections.unmodifiableSet(res);
    }

    public int hashCode() {
        return this.topVer.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof AffinityAssignment)) {
            return false;
        }
        return this.topVer.equals(((AffinityAssignment)o).topologyVersion());
    }

    public String toString() {
        return S.toString(HistoryAffinityAssignment.class, this);
    }
}

