/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.affinity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.BitSetIntSet;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;

public class GridAffinityAssignmentV2
extends IgniteDataTransferObject
implements AffinityAssignment {
    private static final long serialVersionUID = 0L;
    private AffinityTopologyVersion topVer;
    private List<List<ClusterNode>> assignment;
    private Map<UUID, Set<Integer>> primary;
    private Map<UUID, Set<Integer>> backup;
    private volatile transient List<Collection<UUID>> assignmentIds;
    private volatile transient Set<ClusterNode> nodes;
    private volatile transient Set<ClusterNode> primaryPartsNodes;
    private transient List<List<ClusterNode>> idealAssignment;

    public GridAffinityAssignmentV2() {
    }

    GridAffinityAssignmentV2(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
        this.primary = Collections.emptyMap();
        this.backup = Collections.emptyMap();
    }

    public GridAffinityAssignmentV2(AffinityTopologyVersion topVer, List<List<ClusterNode>> assignment, List<List<ClusterNode>> idealAssignment) {
        assert (topVer != null);
        assert (assignment != null);
        assert (idealAssignment != null);
        this.topVer = topVer;
        this.assignment = Collections.unmodifiableList(assignment);
        this.idealAssignment = idealAssignment.equals(assignment) ? this.assignment : Collections.unmodifiableList(idealAssignment);
        HashMap<UUID, Set> tmpPrimary = new HashMap<UUID, Set>();
        HashMap tmpBackup = new HashMap();
        int partsCnt = assignment.size();
        for (int p = 0; p < partsCnt; ++p) {
            boolean isPrimary = true;
            for (ClusterNode node : assignment.get(p)) {
                UUID id = node.id();
                HashMap<UUID, Set> tmp = isPrimary ? tmpPrimary : tmpBackup;
                tmp.computeIfAbsent(id, uuid -> !IGNITE_DISABLE_AFFINITY_MEMORY_OPTIMIZATION ? new BitSetIntSet() : new HashSet()).add(p);
                isPrimary = false;
            }
        }
        this.primary = Collections.unmodifiableMap(tmpPrimary);
        this.backup = Collections.unmodifiableMap(tmpBackup);
    }

    GridAffinityAssignmentV2(AffinityTopologyVersion topVer, GridAffinityAssignmentV2 aff) {
        this.topVer = topVer;
        this.assignment = aff.assignment;
        this.idealAssignment = aff.idealAssignment;
        this.primary = aff.primary;
        this.backup = aff.backup;
    }

    @Override
    public List<List<ClusterNode>> idealAssignment() {
        return this.idealAssignment;
    }

    @Override
    public List<List<ClusterNode>> assignment() {
        return this.assignment;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    @Override
    public List<ClusterNode> get(int part) {
        assert (part >= 0 && part < this.assignment.size()) : "Affinity partition is out of range [part=" + part + ", partitions=" + this.assignment.size() + ']';
        return this.assignment.get(part);
    }

    @Override
    public Collection<UUID> getIds(int part) {
        assert (part >= 0 && part < this.assignment.size()) : "Affinity partition is out of range [part=" + part + ", partitions=" + this.assignment.size() + ']';
        if (IGNITE_DISABLE_AFFINITY_MEMORY_OPTIMIZATION) {
            return this.getOrCreateAssignmentsIds(part);
        }
        List<ClusterNode> nodes = this.assignment.get(part);
        return nodes.size() > IGNITE_AFFINITY_BACKUPS_THRESHOLD ? this.getOrCreateAssignmentsIds(part) : F.viewReadOnly(nodes, F.node2id(), new IgnitePredicate[0]);
    }

    private Collection<UUID> getOrCreateAssignmentsIds(int part) {
        List<Collection<UUID>> assignmentIds0 = this.assignmentIds;
        if (assignmentIds0 == null) {
            assignmentIds0 = new ArrayList<Collection<UUID>>(this.assignment.size());
            for (List<ClusterNode> assignmentPart : this.assignment) {
                assignmentIds0.add(this.assignments2ids(assignmentPart));
            }
            this.assignmentIds = assignmentIds0;
        }
        return assignmentIds0.get(part);
    }

    @Override
    public Set<ClusterNode> nodes() {
        Set<ClusterNode> res = this.nodes;
        if (res == null) {
            res = new HashSet<ClusterNode>();
            for (int p = 0; p < this.assignment.size(); ++p) {
                List<ClusterNode> nodes = this.assignment.get(p);
                if (nodes.isEmpty()) continue;
                res.addAll(nodes);
            }
            this.nodes = Collections.unmodifiableSet(res);
        }
        return res;
    }

    @Override
    public Set<ClusterNode> primaryPartitionNodes() {
        Set<ClusterNode> res = this.primaryPartsNodes;
        if (res == null) {
            res = new HashSet<ClusterNode>();
            for (int p = 0; p < this.assignment.size(); ++p) {
                List<ClusterNode> nodes = this.assignment.get(p);
                if (nodes.isEmpty()) continue;
                res.add(nodes.get(0));
            }
            this.primaryPartsNodes = Collections.unmodifiableSet(res);
        }
        return res;
    }

    @Override
    public Set<Integer> primaryPartitions(UUID nodeId) {
        Set<Integer> set = this.primary.get(nodeId);
        return set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    @Override
    public Set<Integer> backupPartitions(UUID nodeId) {
        Set<Integer> set = this.backup.get(nodeId);
        return set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    public int hashCode() {
        return this.topVer.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AffinityAssignment)) {
            return false;
        }
        return this.topVer.equals(((AffinityAssignment)o).topologyVersion());
    }

    public String toString() {
        return S.toString(GridAffinityAssignmentV2.class, this, super.toString());
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeObject(this.topVer);
        U.writeCollection(out, this.assignment);
        U.writeMap(out, this.primary);
        U.writeMap(out, this.backup);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.topVer = (AffinityTopologyVersion)in.readObject();
        this.assignment = U.readList(in);
        this.primary = U.readMap(in);
        this.backup = U.readMap(in);
    }
}

