/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.InitNewPageRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MetaPageInitRecord
extends InitNewPageRecord {
    private long treeRoot;
    private long reuseListRoot;
    private int ioType;

    public MetaPageInitRecord(int grpId, long pageId, int ioType, int ioVer, long treeRoot, long reuseListRoot) {
        super(grpId, pageId, ioType, ioVer, pageId);
        this.treeRoot = treeRoot;
        this.reuseListRoot = reuseListRoot;
        this.ioType = ioType;
    }

    public long treeRoot() {
        return this.treeRoot;
    }

    public long reuseListRoot() {
        return this.reuseListRoot;
    }

    @Override
    public int ioType() {
        return this.ioType;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        PageMetaIO io = (PageMetaIO)PageMetaIO.getPageIO(this.ioType, this.ioVer);
        io.initNewPage(pageAddr, this.newPageId, pageMem.realPageSize(this.groupId()));
        io.setTreeRoot(pageAddr, this.treeRoot);
        io.setReuseListRoot(pageAddr, this.reuseListRoot);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.META_PAGE_INIT;
    }

    @Override
    public String toString() {
        return S.toString(MetaPageInitRecord.class, this, "super", super.toString());
    }
}

