/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public abstract class WALRecord {
    private int size;
    private int chainSize;
    @GridToStringExclude
    private WALRecord prev;
    private WALPointer pos;

    public void chainSize(int chainSize) {
        this.chainSize = chainSize;
    }

    public int chainSize() {
        return this.chainSize;
    }

    public WALRecord previous() {
        return this.prev;
    }

    public void previous(WALRecord prev) {
        this.prev = prev;
    }

    public WALPointer position() {
        return this.pos;
    }

    public void position(WALPointer pos) {
        assert (pos != null);
        this.pos = pos;
    }

    public int size() {
        return this.size;
    }

    public void size(int size) {
        assert (size >= 0) : size;
        this.size = size;
    }

    public abstract RecordType type();

    public String toString() {
        return S.toString(WALRecord.class, this, "type", (Object)this.type());
    }

    public static enum RecordPurpose {
        INTERNAL,
        PHYSICAL,
        LOGICAL,
        MIXED,
        CUSTOM;

    }

    public static enum RecordType {
        TX_RECORD(RecordPurpose.LOGICAL),
        PAGE_RECORD(RecordPurpose.PHYSICAL),
        DATA_RECORD(RecordPurpose.LOGICAL),
        CHECKPOINT_RECORD(RecordPurpose.PHYSICAL),
        HEADER_RECORD(RecordPurpose.INTERNAL),
        INIT_NEW_PAGE_RECORD(RecordPurpose.PHYSICAL),
        DATA_PAGE_INSERT_RECORD(RecordPurpose.PHYSICAL),
        DATA_PAGE_INSERT_FRAGMENT_RECORD(RecordPurpose.PHYSICAL),
        DATA_PAGE_REMOVE_RECORD(RecordPurpose.PHYSICAL),
        DATA_PAGE_SET_FREE_LIST_PAGE(RecordPurpose.PHYSICAL),
        BTREE_META_PAGE_INIT_ROOT(RecordPurpose.PHYSICAL),
        BTREE_META_PAGE_ADD_ROOT(RecordPurpose.PHYSICAL),
        BTREE_META_PAGE_CUT_ROOT(RecordPurpose.PHYSICAL),
        BTREE_INIT_NEW_ROOT(RecordPurpose.PHYSICAL),
        BTREE_PAGE_RECYCLE(RecordPurpose.PHYSICAL),
        BTREE_PAGE_INSERT(RecordPurpose.PHYSICAL),
        BTREE_FIX_LEFTMOST_CHILD(RecordPurpose.PHYSICAL),
        BTREE_FIX_COUNT(RecordPurpose.PHYSICAL),
        BTREE_PAGE_REPLACE(RecordPurpose.PHYSICAL),
        BTREE_PAGE_REMOVE(RecordPurpose.PHYSICAL),
        BTREE_PAGE_INNER_REPLACE(RecordPurpose.PHYSICAL),
        BTREE_FIX_REMOVE_ID(RecordPurpose.PHYSICAL),
        BTREE_FORWARD_PAGE_SPLIT(RecordPurpose.PHYSICAL),
        BTREE_EXISTING_PAGE_SPLIT(RecordPurpose.PHYSICAL),
        BTREE_PAGE_MERGE(RecordPurpose.PHYSICAL),
        PAGES_LIST_SET_NEXT(RecordPurpose.PHYSICAL),
        PAGES_LIST_SET_PREVIOUS(RecordPurpose.PHYSICAL),
        PAGES_LIST_INIT_NEW_PAGE(RecordPurpose.PHYSICAL),
        PAGES_LIST_ADD_PAGE(RecordPurpose.PHYSICAL),
        PAGES_LIST_REMOVE_PAGE(RecordPurpose.PHYSICAL),
        META_PAGE_INIT(RecordPurpose.PHYSICAL),
        PARTITION_META_PAGE_UPDATE_COUNTERS(RecordPurpose.PHYSICAL),
        MEMORY_RECOVERY,
        TRACKING_PAGE_DELTA(RecordPurpose.PHYSICAL),
        META_PAGE_UPDATE_LAST_SUCCESSFUL_SNAPSHOT_ID(RecordPurpose.MIXED),
        META_PAGE_UPDATE_LAST_SUCCESSFUL_FULL_SNAPSHOT_ID(RecordPurpose.MIXED),
        META_PAGE_UPDATE_NEXT_SNAPSHOT_ID(RecordPurpose.MIXED),
        META_PAGE_UPDATE_LAST_ALLOCATED_INDEX(RecordPurpose.MIXED),
        PART_META_UPDATE_STATE(RecordPurpose.MIXED),
        PAGE_LIST_META_RESET_COUNT_RECORD(RecordPurpose.PHYSICAL),
        SWITCH_SEGMENT_RECORD(RecordPurpose.INTERNAL),
        DATA_PAGE_UPDATE_RECORD(RecordPurpose.PHYSICAL),
        BTREE_META_PAGE_INIT_ROOT2(RecordPurpose.PHYSICAL),
        PARTITION_DESTROY(RecordPurpose.PHYSICAL),
        SNAPSHOT,
        METASTORE_DATA_RECORD(RecordPurpose.LOGICAL),
        EXCHANGE,
        RESERVED,
        ROTATED_ID_PART_RECORD(RecordPurpose.PHYSICAL),
        MVCC_DATA_PAGE_MARK_UPDATED_RECORD(RecordPurpose.PHYSICAL),
        MVCC_DATA_PAGE_TX_STATE_HINT_UPDATED_RECORD(RecordPurpose.PHYSICAL),
        MVCC_DATA_PAGE_NEW_TX_STATE_HINT_UPDATED_RECORD(RecordPurpose.PHYSICAL),
        ENCRYPTED_RECORD(RecordPurpose.PHYSICAL),
        ENCRYPTED_DATA_RECORD(RecordPurpose.LOGICAL),
        MVCC_DATA_RECORD(RecordPurpose.LOGICAL),
        MVCC_TX_RECORD(RecordPurpose.LOGICAL);

        private final RecordPurpose purpose;
        private static final RecordType[] VALS;
        public static final int STOP_ITERATION_RECORD_TYPE = 0;

        private RecordType(RecordPurpose purpose) {
            this.purpose = purpose;
        }

        private RecordType() {
            this(RecordPurpose.CUSTOM);
        }

        public RecordPurpose purpose() {
            return this.purpose;
        }

        public static RecordType fromOrdinal(int ord) {
            return ord < 0 || ord >= VALS.length ? null : VALS[ord];
        }

        static {
            VALS = RecordType.values();
        }
    }
}

