/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import org.jetbrains.annotations.Nullable;

public enum CacheCommand {
    HELP("help"),
    IDLE_VERIFY("idle_verify"),
    LIST("list"),
    VALIDATE_INDEXES("validate_indexes"),
    CONTENTION("contention"),
    DISTRIBUTION("distribution"),
    RESET_LOST_PARTITIONS("reset_lost_partitions");

    private static final CacheCommand[] VALS;
    private final String name;

    private CacheCommand(String name) {
        this.name = name;
    }

    public static CacheCommand of(String text) {
        for (CacheCommand cmd : CacheCommand.values()) {
            if (!cmd.text().equalsIgnoreCase(text)) continue;
            return cmd;
        }
        return null;
    }

    public String text() {
        return this.name;
    }

    @Nullable
    public static CacheCommand fromOrdinal(int ord) {
        return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
    }

    public String toString() {
        return this.name;
    }

    static {
        VALS = CacheCommand.values();
    }
}

