/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.TrustManager;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientAuthenticationException;
import org.apache.ignite.internal.client.GridClientClosedException;
import org.apache.ignite.internal.client.GridClientClusterState;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientHandshakeException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridServerUnreachableException;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionResetException;
import org.apache.ignite.internal.client.ssl.GridSslBasicContextFactory;
import org.apache.ignite.internal.commandline.Arguments;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.GridConsole;
import org.apache.ignite.internal.commandline.GridConsoleAdapter;
import org.apache.ignite.internal.commandline.OutputFormat;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.cache.CacheArguments;
import org.apache.ignite.internal.commandline.cache.CacheCommand;
import org.apache.ignite.internal.commandline.cache.argument.DistributionCommandArg;
import org.apache.ignite.internal.commandline.cache.argument.IdleVerifyCommandArg;
import org.apache.ignite.internal.commandline.cache.argument.ListCommandArg;
import org.apache.ignite.internal.commandline.cache.argument.ValidateIndexesCommandArg;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionTask;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionTaskArg;
import org.apache.ignite.internal.commandline.cache.distribution.CacheDistributionTaskResult;
import org.apache.ignite.internal.commandline.cache.reset_lost_partitions.CacheResetLostPartitionsTask;
import org.apache.ignite.internal.commandline.cache.reset_lost_partitions.CacheResetLostPartitionsTaskArg;
import org.apache.ignite.internal.commandline.cache.reset_lost_partitions.CacheResetLostPartitionsTaskResult;
import org.apache.ignite.internal.processors.cache.verify.CacheInfo;
import org.apache.ignite.internal.processors.cache.verify.ContentionInfo;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecord;
import org.apache.ignite.internal.processors.cache.verify.PartitionKey;
import org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsTaskV2;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.baseline.VisorBaselineNode;
import org.apache.ignite.internal.visor.baseline.VisorBaselineOperation;
import org.apache.ignite.internal.visor.baseline.VisorBaselineTask;
import org.apache.ignite.internal.visor.baseline.VisorBaselineTaskArg;
import org.apache.ignite.internal.visor.baseline.VisorBaselineTaskResult;
import org.apache.ignite.internal.visor.cache.VisorCacheAffinityConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheConfigurationCollectorTask;
import org.apache.ignite.internal.visor.cache.VisorCacheConfigurationCollectorTaskArg;
import org.apache.ignite.internal.visor.cache.VisorCacheEvictionConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheNearConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheRebalanceConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheStoreConfiguration;
import org.apache.ignite.internal.visor.misc.VisorClusterNode;
import org.apache.ignite.internal.visor.misc.VisorWalTask;
import org.apache.ignite.internal.visor.misc.VisorWalTaskArg;
import org.apache.ignite.internal.visor.misc.VisorWalTaskOperation;
import org.apache.ignite.internal.visor.misc.VisorWalTaskResult;
import org.apache.ignite.internal.visor.query.VisorQueryConfiguration;
import org.apache.ignite.internal.visor.tx.VisorTxInfo;
import org.apache.ignite.internal.visor.tx.VisorTxOperation;
import org.apache.ignite.internal.visor.tx.VisorTxProjection;
import org.apache.ignite.internal.visor.tx.VisorTxSortOrder;
import org.apache.ignite.internal.visor.tx.VisorTxTask;
import org.apache.ignite.internal.visor.tx.VisorTxTaskArg;
import org.apache.ignite.internal.visor.tx.VisorTxTaskResult;
import org.apache.ignite.internal.visor.verify.CacheFilterEnum;
import org.apache.ignite.internal.visor.verify.IndexIntegrityCheckIssue;
import org.apache.ignite.internal.visor.verify.IndexValidationIssue;
import org.apache.ignite.internal.visor.verify.ValidateIndexesPartitionResult;
import org.apache.ignite.internal.visor.verify.VisorContentionTask;
import org.apache.ignite.internal.visor.verify.VisorContentionTaskArg;
import org.apache.ignite.internal.visor.verify.VisorContentionTaskResult;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyDumpTask;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyDumpTaskArg;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTask;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskArg;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskResult;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskV2;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskArg;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskResult;
import org.apache.ignite.internal.visor.verify.VisorViewCacheCmd;
import org.apache.ignite.internal.visor.verify.VisorViewCacheTask;
import org.apache.ignite.internal.visor.verify.VisorViewCacheTaskArg;
import org.apache.ignite.internal.visor.verify.VisorViewCacheTaskResult;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;

public class CommandHandler {
    static final String DFLT_HOST = "127.0.0.1";
    static final String DFLT_PORT = "11211";
    private static final String CMD_HELP = "--help";
    private static final String CMD_HOST = "--host";
    private static final String CMD_PORT = "--port";
    private static final String CMD_PASSWORD = "--password";
    private static final String CMD_USER = "--user";
    private static final String CMD_AUTO_CONFIRMATION = "--yes";
    private static final String CMD_PING_INTERVAL = "--ping-interval";
    private static final String CMD_PING_TIMEOUT = "--ping-timeout";
    public static final String ONE_CACHE_FILTER_OPT_SHOULD_USED_MSG = "Should use only one of option: " + IdleVerifyCommandArg.EXCLUDE_CACHES + ", " + IdleVerifyCommandArg.CACHE_FILTER + " or pass caches explicitly";
    private static final String CMD_SSL_PROTOCOL = "--ssl-protocol";
    private static final String CMD_SSL_KEY_ALGORITHM = "--ssl-key-algorithm";
    private static final String CMD_SSL_CIPHER_SUITES = "--ssl-cipher-suites";
    private static final String CMD_KEYSTORE = "--keystore";
    private static final String CMD_KEYSTORE_PASSWORD = "--keystore-password";
    private static final String CMD_KEYSTORE_TYPE = "--keystore-type";
    private static final String CMD_TRUSTSTORE = "--truststore";
    private static final String CMD_TRUSTSTORE_PASSWORD = "--truststore-password";
    private static final String CMD_TRUSTSTORE_TYPE = "--truststore-type";
    private static final Set<String> AUX_COMMANDS = new HashSet<String>();
    private static final UUID BROADCAST_UUID;
    public static final String CONFIRM_MSG = "y";
    private static final String BASELINE_ADD = "add";
    private static final String BASELINE_REMOVE = "remove";
    private static final String BASELINE_COLLECT = "collect";
    private static final String BASELINE_SET = "set";
    private static final String BASELINE_SET_VERSION = "version";
    static final String WAL_PRINT = "print";
    static final String WAL_DELETE = "delete";
    static final String DELIM = "--------------------------------------------------------------------------------";
    public static final int EXIT_CODE_OK = 0;
    public static final int EXIT_CODE_INVALID_ARGUMENTS = 1;
    public static final int EXIT_CODE_CONNECTION_FAILED = 2;
    public static final int ERR_AUTHENTICATION_FAILED = 3;
    public static final int EXIT_CODE_UNEXPECTED_ERROR = 4;
    private static final long DFLT_PING_INTERVAL = 5000L;
    private static final long DFLT_PING_TIMEOUT = 30000L;
    private static final Scanner IN;
    private static final String VALIDATE_INDEXES_TASK = "org.apache.ignite.internal.visor.verify.VisorValidateIndexesTask";
    private static final String TX_LIMIT = "--limit";
    private static final String TX_ORDER = "--order";
    private static final String TX_SERVERS = "--servers";
    private static final String TX_CLIENTS = "--clients";
    private static final String TX_DURATION = "--min-duration";
    private static final String TX_SIZE = "--min-size";
    private static final String TX_LABEL = "--label";
    private static final String TX_NODES = "--nodes";
    private static final String TX_XID = "--xid";
    private static final String TX_KILL = "--kill";
    private static final String UTILITY_NAME = "control.sh";
    private static final String COMMON_OPTIONS;
    private static final String UTILITY_NAME_WITH_COMMON_OPTIONS;
    private static final String INDENT = "  ";
    private static final String NULL = "null";
    private static final String NODE_ID = "nodeId";
    private static final String OP_NODE_ID;
    private Iterator<String> argsIt;
    private String peekedArg;
    private Object lastOperationRes;
    private GridClientConfiguration clientCfg;
    private final boolean enableExperimental = IgniteSystemProperties.getBoolean("IGNITE_ENABLE_EXPERIMENTAL_COMMAND", false);
    public GridConsole console = GridConsoleAdapter.getInstance();

    private static String[] getCommonOptions() {
        ArrayList<String> list = new ArrayList<String>(32);
        list.add(CommandHandler.op(CMD_HOST, "HOST_OR_IP"));
        list.add(CommandHandler.op(CMD_PORT, "PORT"));
        list.add(CommandHandler.op(CMD_USER, "USER"));
        list.add(CommandHandler.op(CMD_PASSWORD, "PASSWORD"));
        list.add(CommandHandler.op(CMD_PING_INTERVAL, "PING_INTERVAL"));
        list.add(CommandHandler.op(CMD_PING_TIMEOUT, "PING_TIMEOUT"));
        list.add(CommandHandler.op(CMD_SSL_PROTOCOL, "SSL_PROTOCOL[, SSL_PROTOCOL_2, ..., SSL_PROTOCOL_N]"));
        list.add(CommandHandler.op(CMD_SSL_CIPHER_SUITES, "SSL_CIPHER_1[, SSL_CIPHER_2, ..., SSL_CIPHER_N]"));
        list.add(CommandHandler.op(CMD_SSL_KEY_ALGORITHM, "SSL_KEY_ALGORITHM"));
        list.add(CommandHandler.op(CMD_KEYSTORE_TYPE, "KEYSTORE_TYPE"));
        list.add(CommandHandler.op(CMD_KEYSTORE, "KEYSTORE_PATH"));
        list.add(CommandHandler.op(CMD_KEYSTORE_PASSWORD, "KEYSTORE_PASSWORD"));
        list.add(CommandHandler.op(CMD_TRUSTSTORE_TYPE, "TRUSTSTORE_TYPE"));
        list.add(CommandHandler.op(CMD_TRUSTSTORE, "TRUSTSTORE_PATH"));
        list.add(CommandHandler.op(CMD_TRUSTSTORE_PASSWORD, "TRUSTSTORE_PASSWORD"));
        return list.toArray(new String[0]);
    }

    private void log(String s) {
        System.out.println(s);
    }

    private static String i(Object o) {
        return CommandHandler.i(o, 1);
    }

    private static String i(Object o, int indentCnt) {
        assert (indentCnt >= 0);
        String s = o == null ? null : o.toString();
        switch (indentCnt) {
            case 0: {
                return s;
            }
            case 1: {
                return INDENT + s;
            }
        }
        int sLen = s == null ? 4 : s.length();
        SB sb = new SB(sLen + indentCnt * INDENT.length());
        for (int i = 0; i < indentCnt; ++i) {
            sb.a(INDENT);
        }
        return sb.a(s).toString();
    }

    private void log(String format, Object ... args) {
        System.out.printf(format, args);
    }

    private String readLine(String prompt) {
        System.out.print(prompt);
        return IN.nextLine();
    }

    private void nl() {
        System.out.println();
    }

    private int error(int errCode, String s, Throwable e) {
        String msg;
        if (!F.isEmpty(s)) {
            this.log(s);
        }
        if (F.isEmpty(msg = e.getMessage())) {
            msg = e.getClass().getName();
        }
        if (msg.startsWith("Failed to handle request")) {
            int p = msg.indexOf("err=");
            msg = msg.substring(p + 4, msg.length() - 1);
        }
        this.log("Error: " + msg);
        return errCode;
    }

    private boolean confirm(Arguments args) {
        String prompt = this.confirmationPrompt(args);
        if (prompt == null) {
            return true;
        }
        return CONFIRM_MSG.equalsIgnoreCase(this.readLine(prompt));
    }

    private String confirmationPrompt(Arguments args) {
        String str = null;
        switch (args.command()) {
            case DEACTIVATE: {
                str = "Warning: the command will deactivate a cluster.";
                break;
            }
            case BASELINE: {
                if (BASELINE_COLLECT.equals(args.baselineAction())) break;
                str = "Warning: the command will perform changes in baseline.";
                break;
            }
            case WAL: {
                if (!WAL_DELETE.equals(args.walAction())) break;
                str = "Warning: the command will delete unused WAL segments.";
                break;
            }
            case TX: {
                if (args.transactionArguments().getOperation() != VisorTxOperation.KILL) break;
                str = "Warning: the command will kill some transactions.";
                break;
            }
        }
        return str == null ? null : str + "\nPress '" + CONFIRM_MSG + "' to continue . . . ";
    }

    private void initArgIterator(List<String> rawArgs) {
        this.argsIt = rawArgs.iterator();
        this.peekedArg = null;
    }

    private boolean hasNextArg() {
        return this.peekedArg != null || this.argsIt.hasNext();
    }

    private void activate(GridClient client) throws Throwable {
        try {
            GridClientClusterState state = client.state();
            state.active(true);
            this.log("Cluster activated");
        }
        catch (Throwable e) {
            this.log("Failed to activate cluster.");
            throw e;
        }
    }

    private void deactivate(GridClient client) throws Throwable {
        try {
            GridClientClusterState state = client.state();
            state.active(false);
            this.log("Cluster deactivated");
        }
        catch (Throwable e) {
            this.log("Failed to deactivate cluster.");
            throw e;
        }
    }

    private void state(GridClient client) throws Throwable {
        try {
            GridClientClusterState state = client.state();
            this.log("Cluster is " + (state.active() ? "active" : "inactive"));
        }
        catch (Throwable e) {
            this.log("Failed to get cluster state.");
            throw e;
        }
    }

    private <R> R executeTask(GridClient client, Class<? extends ComputeTask<?, R>> taskCls, Object taskArgs) throws GridClientException {
        return this.executeTaskByNameOnNode(client, taskCls.getName(), taskArgs, null);
    }

    private Stream<IgniteBiTuple<GridClientNode, String>> listHosts(GridClient client) throws GridClientException {
        return client.compute().nodes(GridClientNode::connectable).stream().flatMap(node -> Stream.concat(node.tcpAddresses() == null ? Stream.empty() : node.tcpAddresses().stream(), node.tcpHostNames() == null ? Stream.empty() : node.tcpHostNames().stream()).map(addr -> new IgniteBiTuple<GridClientNode, String>((GridClientNode)node, addr + ":" + node.tcpPort())));
    }

    private Stream<IgniteBiTuple<GridClientNode, List<String>>> listHostsByClientNode(GridClient client) throws GridClientException {
        return client.compute().nodes(GridClientNode::connectable).stream().map(node -> new IgniteBiTuple((GridClientNode)node, Stream.concat(node.tcpAddresses() == null ? Stream.empty() : node.tcpAddresses().stream(), node.tcpHostNames() == null ? Stream.empty() : node.tcpHostNames().stream()).map(addr -> addr + ":" + node.tcpPort()).collect(Collectors.toList())));
    }

    private <R> R executeTaskByNameOnNode(GridClient client, String taskClsName, Object taskArgs, UUID nodeId) throws GridClientException {
        GridClientCompute compute = client.compute();
        if (nodeId == BROADCAST_UUID) {
            Collection<GridClientNode> nodes = compute.nodes(GridClientNode::connectable);
            if (F.isEmpty(nodes)) {
                throw new GridClientDisconnectedException("Connectable nodes not found", null);
            }
            List<UUID> nodeIds = nodes.stream().map(GridClientNode::nodeId).collect(Collectors.toList());
            return client.compute().execute(taskClsName, new VisorTaskArgument<Object>(nodeIds, taskArgs, false));
        }
        GridClientNode node = null;
        if (nodeId == null) {
            String cfgAddr = this.clientCfg.getServers().iterator().next();
            String[] parts = cfgAddr.split(":");
            if (DFLT_HOST.equals(parts[0])) {
                InetAddress addr;
                try {
                    addr = IgniteUtils.getLocalHost();
                }
                catch (IOException e) {
                    throw new GridClientException("Can't get localhost name.", e);
                }
                if (addr.isLoopbackAddress()) {
                    throw new GridClientException("Can't find localhost name.");
                }
                String origAddr = addr.getHostName() + ":" + parts[1];
                node = this.listHosts(client).filter(tuple -> origAddr.equals(tuple.get2())).findFirst().map(IgniteBiTuple::get1).orElse(null);
                if (node == null) {
                    node = this.listHostsByClientNode(client).filter(tuple -> ((List)tuple.get2()).size() == 1 && cfgAddr.equals(((List)tuple.get2()).get(0))).findFirst().map(IgniteBiTuple::get1).orElse(null);
                }
            } else {
                node = this.listHosts(client).filter(tuple -> cfgAddr.equals(tuple.get2())).findFirst().map(IgniteBiTuple::get1).orElse(null);
            }
            if (node == null) {
                node = this.getBalancedNode(compute);
            }
        } else {
            for (GridClientNode n : compute.nodes()) {
                if (!n.connectable() || !nodeId.equals(n.nodeId())) continue;
                node = n;
                break;
            }
            if (node == null) {
                throw new IllegalArgumentException("Node with id=" + nodeId + " not found");
            }
        }
        return compute.projection(node).execute(taskClsName, new VisorTaskArgument<Object>(node.nodeId(), taskArgs, false));
    }

    private GridClientNode getBalancedNode(GridClientCompute compute) throws GridClientException {
        Collection<GridClientNode> nodes = compute.nodes(GridClientNode::connectable);
        if (F.isEmpty(nodes)) {
            throw new GridClientDisconnectedException("Connectable node not found", null);
        }
        return compute.balancer().balancedNode(nodes);
    }

    private void cache(GridClient client, CacheArguments cacheArgs) throws Throwable {
        switch (cacheArgs.command()) {
            case HELP: {
                this.printCacheHelp();
                break;
            }
            case IDLE_VERIFY: {
                this.cacheIdleVerify(client, cacheArgs);
                break;
            }
            case VALIDATE_INDEXES: {
                this.cacheValidateIndexes(client, cacheArgs);
                break;
            }
            case CONTENTION: {
                this.cacheContention(client, cacheArgs);
                break;
            }
            case DISTRIBUTION: {
                this.cacheDistribution(client, cacheArgs);
                break;
            }
            case RESET_LOST_PARTITIONS: {
                this.cacheResetLostPartitions(client, cacheArgs);
                break;
            }
            default: {
                this.cacheView(client, cacheArgs);
            }
        }
    }

    private void printCacheHelp() {
        this.log(CommandHandler.i("The '" + (Object)((Object)Command.CACHE) + " subcommand' is used to get information about and perform actions with caches. The command has the following syntax:"));
        this.nl();
        this.log(CommandHandler.i(UTILITY_NAME_WITH_COMMON_OPTIONS + " " + (Object)((Object)Command.CACHE) + " [subcommand] <subcommand_parameters>"));
        this.nl();
        this.log(CommandHandler.i("The subcommands that take " + OP_NODE_ID + " as an argument ('" + (Object)((Object)CacheCommand.LIST) + "', '" + (Object)((Object)CacheCommand.CONTENTION) + "' and '" + (Object)((Object)CacheCommand.VALIDATE_INDEXES) + "') will be executed on the given node or on all server nodes if the option is not specified. Other commands will run on a random server node."));
        this.nl();
        this.nl();
        this.log(CommandHandler.i("Subcommands:"));
        String CACHES = "cacheName1,...,cacheNameN";
        this.usageCache(CacheCommand.LIST, "regexPattern", CommandHandler.op(CommandHandler.or(ListCommandArg.GROUP, ListCommandArg.SEQUENCE)), OP_NODE_ID, CommandHandler.op(ListCommandArg.CONFIG), CommandHandler.op(new Object[]{ListCommandArg.OUTPUT_FORMAT, OutputFormat.MULTI_LINE}));
        this.usageCache(CacheCommand.CONTENTION, "minQueueSize", OP_NODE_ID, CommandHandler.op("maxPrint"));
        this.usageCache(CacheCommand.IDLE_VERIFY, CommandHandler.op(IdleVerifyCommandArg.DUMP), CommandHandler.op(IdleVerifyCommandArg.SKIP_ZEROS), CommandHandler.op(IdleVerifyCommandArg.CHECK_CRC), CommandHandler.op(CommandHandler.or(CommandHandler.g(IdleVerifyCommandArg.EXCLUDE_CACHES, CACHES), CommandHandler.g(IdleVerifyCommandArg.CACHE_FILTER, CommandHandler.or((Object[])CacheFilterEnum.values())), CACHES)));
        this.usageCache(CacheCommand.VALIDATE_INDEXES, CommandHandler.op(CACHES), OP_NODE_ID, CommandHandler.op(CommandHandler.or(ValidateIndexesCommandArg.CHECK_FIRST + " N", ValidateIndexesCommandArg.CHECK_THROUGH + " K")));
        this.usageCache(CacheCommand.DISTRIBUTION, CommandHandler.or(NODE_ID, NULL), CommandHandler.op(CACHES), CommandHandler.op(DistributionCommandArg.USER_ATTRIBUTES, "attrName1,...,attrNameN"));
        this.usageCache(CacheCommand.RESET_LOST_PARTITIONS, CACHES);
        this.nl();
    }

    private void cacheContention(GridClient client, CacheArguments cacheArgs) throws GridClientException {
        VisorContentionTaskArg taskArg = new VisorContentionTaskArg(cacheArgs.minQueueSize(), cacheArgs.maxPrint());
        UUID nodeId = cacheArgs.nodeId() == null ? BROADCAST_UUID : cacheArgs.nodeId();
        VisorContentionTaskResult res = (VisorContentionTaskResult)this.executeTaskByNameOnNode(client, VisorContentionTask.class.getName(), taskArg, nodeId);
        if (!F.isEmpty(res.exceptions())) {
            this.log("Contention check failed on nodes:");
            for (Map.Entry entry : res.exceptions().entrySet()) {
                this.log("Node ID: " + entry.getKey());
                this.log("Exception message:");
                this.log(((Exception)entry.getValue()).getMessage());
                this.nl();
            }
        }
        for (ContentionInfo contentionInfo : res.getInfos()) {
            contentionInfo.print();
        }
    }

    private void cacheValidateIndexes(GridClient client, CacheArguments cacheArgs) throws GridClientException {
        VisorValidateIndexesTaskArg taskArg = new VisorValidateIndexesTaskArg(cacheArgs.caches(), cacheArgs.nodeId() != null ? Collections.singleton(cacheArgs.nodeId()) : null, cacheArgs.checkFirst(), cacheArgs.checkThrough());
        VisorValidateIndexesTaskResult taskRes = (VisorValidateIndexesTaskResult)this.executeTaskByNameOnNode(client, VALIDATE_INDEXES_TASK, taskArg, null);
        boolean errors = false;
        if (!F.isEmpty(taskRes.exceptions())) {
            errors = true;
            this.log("Index validation failed on nodes:");
            for (Map.Entry<UUID, Serializable> entry : taskRes.exceptions().entrySet()) {
                this.log(CommandHandler.i("Node ID: " + entry.getKey()));
                this.log(CommandHandler.i("Exception message:"));
                this.log(CommandHandler.i(((Exception)entry.getValue()).getMessage(), 2));
                this.nl();
            }
        }
        for (Map.Entry<UUID, VisorValidateIndexesJobResult> entry : taskRes.results().entrySet()) {
            if (!entry.getValue().hasIssues()) continue;
            errors = true;
            this.log("Index issues found on node " + entry.getKey() + ":");
            Collection<IndexIntegrityCheckIssue> integrityCheckFailures = entry.getValue().integrityCheckFailures();
            if (!integrityCheckFailures.isEmpty()) {
                for (IndexIntegrityCheckIssue indexIntegrityCheckIssue : integrityCheckFailures) {
                    this.log(CommandHandler.i(indexIntegrityCheckIssue));
                }
            }
            Map<PartitionKey, ValidateIndexesPartitionResult> partRes = entry.getValue().partitionResult();
            for (Map.Entry<PartitionKey, ValidateIndexesPartitionResult> e : partRes.entrySet()) {
                ValidateIndexesPartitionResult res = e.getValue();
                if (res.issues().isEmpty()) continue;
                this.log(CommandHandler.i(CommandHandler.j(" ", e.getKey(), e.getValue())));
                for (IndexValidationIssue is3 : res.issues()) {
                    this.log(CommandHandler.i(is3, 2));
                }
            }
            Map<String, ValidateIndexesPartitionResult> map = entry.getValue().indexResult();
            for (Map.Entry<String, ValidateIndexesPartitionResult> e : map.entrySet()) {
                ValidateIndexesPartitionResult res = e.getValue();
                if (res.issues().isEmpty()) continue;
                this.log(CommandHandler.i(CommandHandler.j(" ", "SQL Index", e.getKey(), e.getValue())));
                for (IndexValidationIssue is4 : res.issues()) {
                    this.log(CommandHandler.i(is4, 2));
                }
            }
        }
        if (!errors) {
            this.log("no issues found.");
        } else {
            this.log("issues found (listed above).");
        }
        this.nl();
    }

    private void cacheView(GridClient client, CacheArguments cacheArgs) throws GridClientException {
        VisorViewCacheTaskArg taskArg = new VisorViewCacheTaskArg(cacheArgs.regex(), cacheArgs.cacheCommand());
        VisorViewCacheTaskResult res = (VisorViewCacheTaskResult)this.executeTaskByNameOnNode(client, VisorViewCacheTask.class.getName(), taskArg, cacheArgs.nodeId());
        if (cacheArgs.fullConfig() && cacheArgs.cacheCommand() == VisorViewCacheCmd.CACHES) {
            this.cachesConfig(client, cacheArgs, res);
        } else {
            this.printCacheInfos(res.cacheInfos(), cacheArgs.cacheCommand());
        }
    }

    private void cacheIdleVerify(GridClient client, CacheArguments cacheArgs) throws GridClientException {
        Collection<GridClientNode> nodes = client.compute().nodes(GridClientNode::connectable);
        boolean idleVerifyV2 = true;
        for (GridClientNode node : nodes) {
            String nodeVerStr = (String)node.attribute("org.apache.ignite.build.ver");
            IgniteProductVersion nodeVer = IgniteProductVersion.fromString(nodeVerStr);
            if (nodeVer.compareTo(VerifyBackupPartitionsTaskV2.V2_SINCE_VER) >= 0) continue;
            idleVerifyV2 = false;
            break;
        }
        if (cacheArgs.dump()) {
            this.cacheIdleVerifyDump(client, cacheArgs);
        } else if (idleVerifyV2) {
            this.cacheIdleVerifyV2(client, cacheArgs);
        } else {
            this.legacyCacheIdleVerify(client, cacheArgs);
        }
    }

    private void legacyCacheIdleVerify(GridClient client, CacheArguments cacheArgs) throws GridClientException {
        VisorIdleVerifyTaskResult res = (VisorIdleVerifyTaskResult)this.executeTask(client, VisorIdleVerifyTask.class, new VisorIdleVerifyTaskArg(cacheArgs.caches(), cacheArgs.excludeCaches(), cacheArgs.idleCheckCrc()));
        Map<PartitionKey, List<PartitionHashRecord>> conflicts = res.getConflicts();
        if (conflicts.isEmpty()) {
            this.log("idle_verify check has finished, no conflicts have been found.");
            this.nl();
        } else {
            this.log("idle_verify check has finished, found " + conflicts.size() + " conflict partitions.");
            this.nl();
            for (Map.Entry<PartitionKey, List<PartitionHashRecord>> entry : conflicts.entrySet()) {
                this.log("Conflict partition: " + entry.getKey());
                this.log("Partition instances: " + entry.getValue());
            }
        }
    }

    private void cacheDistribution(GridClient client, CacheArguments cacheArgs) throws GridClientException {
        CacheDistributionTaskArg taskArg = new CacheDistributionTaskArg(cacheArgs.caches(), cacheArgs.getUserAttributes());
        UUID nodeId = cacheArgs.nodeId() == null ? BROADCAST_UUID : cacheArgs.nodeId();
        CacheDistributionTaskResult res = (CacheDistributionTaskResult)this.executeTaskByNameOnNode(client, CacheDistributionTask.class.getName(), taskArg, nodeId);
        res.print(System.out);
    }

    private void cachesConfig(GridClient client, CacheArguments cacheArgs, VisorViewCacheTaskResult viewRes) throws GridClientException {
        VisorCacheConfigurationCollectorTaskArg taskArg = new VisorCacheConfigurationCollectorTaskArg(cacheArgs.regex());
        UUID nodeId = cacheArgs.nodeId() == null ? BROADCAST_UUID : cacheArgs.nodeId();
        Map res = (Map)this.executeTaskByNameOnNode(client, VisorCacheConfigurationCollectorTask.class.getName(), taskArg, nodeId);
        Map<String, Integer> cacheToMapped = viewRes.cacheInfos().stream().collect(Collectors.toMap(CacheInfo::getCacheName, CacheInfo::getMapped));
        this.printCachesConfig(res, cacheArgs.outputFormat(), cacheToMapped);
    }

    private void printCacheInfos(Collection<CacheInfo> infos, VisorViewCacheCmd cmd) {
        for (CacheInfo info : infos) {
            Map<String, Object> map = info.toMap(cmd);
            SB sb = new SB("[");
            for (Map.Entry<String, Object> e : map.entrySet()) {
                sb.a(e.getKey()).a("=").a(e.getValue()).a(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.a("]");
            this.log(sb.toString());
        }
    }

    private void printCachesConfig(Map<String, VisorCacheConfiguration> caches, OutputFormat outputFormat, Map<String, Integer> cacheToMapped) {
        block3: for (Map.Entry<String, VisorCacheConfiguration> entry : caches.entrySet()) {
            String cacheName = entry.getKey();
            switch (outputFormat) {
                case MULTI_LINE: {
                    Map<String, Object> params = this.mapToPairs(entry.getValue());
                    params.put("Mapped", cacheToMapped.get(cacheName));
                    this.log("[cache = '%s']%n", cacheName);
                    for (Map.Entry<String, Object> innerEntry : params.entrySet()) {
                        this.log("%s: %s%n", innerEntry.getKey(), innerEntry.getValue());
                    }
                    this.nl();
                    continue block3;
                }
            }
            int mapped = cacheToMapped.get(cacheName);
            this.log("%s: %s %s=%s%n", entry.getKey(), this.toString(entry.getValue()), "mapped", mapped);
        }
    }

    private String toString(VisorCacheConfiguration cfg) {
        return cfg.toString().substring(cfg.getClass().getSimpleName().length() + 1);
    }

    private void cacheResetLostPartitions(GridClient client, CacheArguments cacheArgs) throws GridClientException {
        CacheResetLostPartitionsTaskArg taskArg = new CacheResetLostPartitionsTaskArg(cacheArgs.caches());
        CacheResetLostPartitionsTaskResult res = (CacheResetLostPartitionsTaskResult)this.executeTaskByNameOnNode(client, CacheResetLostPartitionsTask.class.getName(), taskArg, null);
        res.print(System.out);
    }

    private void cacheIdleVerifyDump(GridClient client, CacheArguments cacheArgs) throws GridClientException {
        VisorIdleVerifyDumpTaskArg arg = new VisorIdleVerifyDumpTaskArg(cacheArgs.caches(), cacheArgs.excludeCaches(), cacheArgs.isSkipZeros(), cacheArgs.getCacheFilterEnum(), cacheArgs.idleCheckCrc());
        String path = (String)this.executeTask(client, VisorIdleVerifyDumpTask.class, arg);
        this.log("VisorIdleVerifyDumpTask successfully written output to '" + path + "'");
    }

    private void cacheIdleVerifyV2(GridClient client, CacheArguments cacheArgs) throws GridClientException {
        IdleVerifyResultV2 res = (IdleVerifyResultV2)this.executeTask(client, VisorIdleVerifyTaskV2.class, new VisorIdleVerifyTaskArg(cacheArgs.caches(), cacheArgs.excludeCaches(), cacheArgs.idleCheckCrc()));
        res.print(System.out::print);
    }

    private void baseline(GridClient client, String baselineAct, String baselineArgs) throws Throwable {
        switch (baselineAct) {
            case "add": {
                this.baselineAdd(client, baselineArgs);
                break;
            }
            case "remove": {
                this.baselineRemove(client, baselineArgs);
                break;
            }
            case "set": {
                this.baselineSet(client, baselineArgs);
                break;
            }
            case "version": {
                this.baselineVersion(client, baselineArgs);
                break;
            }
            case "collect": {
                this.baselinePrint(client);
            }
        }
    }

    private VisorBaselineTaskArg arg(VisorBaselineOperation op, String s) {
        switch (op) {
            case ADD: 
            case REMOVE: 
            case SET: {
                List<String> consistentIds = this.getConsistentIds(s);
                return new VisorBaselineTaskArg(op, -1L, consistentIds);
            }
            case VERSION: {
                try {
                    long topVer = Long.parseLong(s);
                    return new VisorBaselineTaskArg(op, topVer, null);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid topology version: " + s, e);
                }
            }
        }
        return new VisorBaselineTaskArg(op, -1L, null);
    }

    private List<String> getConsistentIds(String s) {
        if (F.isEmpty(s)) {
            throw new IllegalArgumentException("Empty list of consistent IDs");
        }
        ArrayList<String> consistentIds = new ArrayList<String>();
        for (String consistentId : s.split(",")) {
            consistentIds.add(consistentId.trim());
        }
        return consistentIds;
    }

    private void baselinePrint0(VisorBaselineTaskResult res) {
        this.log("Cluster state: " + (res.isActive() ? "active" : "inactive"));
        Map<String, VisorBaselineNode> baseline = res.getBaseline();
        Map<String, VisorBaselineNode> srvs = res.getServers();
        String crdStr = srvs.values().stream().filter(node -> node.getOrder() != null).min(Comparator.comparing(VisorBaselineNode::getOrder)).map(crd -> " (Coordinator: ConsistentId=" + crd.getConsistentId() + ", Order=" + crd.getOrder() + ")").orElse("");
        this.log("Current topology version: " + res.getTopologyVersion() + crdStr);
        this.nl();
        if (F.isEmpty(baseline)) {
            this.log("Baseline nodes not found.");
        } else {
            this.log("Baseline nodes:");
            for (VisorBaselineNode node2 : baseline.values()) {
                VisorBaselineNode srvNode = srvs.get(node2.getConsistentId());
                String state = ", State=" + (srvNode != null ? "ONLINE" : "OFFLINE");
                String order = srvNode != null ? ", Order=" + srvNode.getOrder() : "";
                this.log(CommandHandler.i("ConsistentId=" + node2.getConsistentId() + state + order, 2));
            }
            this.log(DELIM);
            this.log("Number of baseline nodes: " + baseline.size());
            this.nl();
            ArrayList<VisorBaselineNode> others = new ArrayList<VisorBaselineNode>();
            for (VisorBaselineNode node3 : srvs.values()) {
                if (baseline.containsKey(node3.getConsistentId())) continue;
                others.add(node3);
            }
            if (F.isEmpty(others)) {
                this.log("Other nodes not found.");
            } else {
                this.log("Other nodes:");
                for (VisorBaselineNode node3 : others) {
                    this.log(CommandHandler.i("ConsistentId=" + node3.getConsistentId() + ", Order=" + node3.getOrder(), 2));
                }
                this.log("Number of other nodes: " + others.size());
            }
        }
    }

    private void baselinePrint(GridClient client) throws GridClientException {
        VisorBaselineTaskResult res = (VisorBaselineTaskResult)this.executeTask(client, VisorBaselineTask.class, this.arg(VisorBaselineOperation.COLLECT, ""));
        this.baselinePrint0(res);
    }

    private void baselineAdd(GridClient client, String baselineArgs) throws Throwable {
        try {
            VisorBaselineTaskResult res = (VisorBaselineTaskResult)this.executeTask(client, VisorBaselineTask.class, this.arg(VisorBaselineOperation.ADD, baselineArgs));
            this.baselinePrint0(res);
        }
        catch (Throwable e) {
            this.log("Failed to add nodes to baseline.");
            throw e;
        }
    }

    private void baselineRemove(GridClient client, String consistentIds) throws Throwable {
        try {
            VisorBaselineTaskResult res = (VisorBaselineTaskResult)this.executeTask(client, VisorBaselineTask.class, this.arg(VisorBaselineOperation.REMOVE, consistentIds));
            this.baselinePrint0(res);
        }
        catch (Throwable e) {
            this.log("Failed to remove nodes from baseline.");
            throw e;
        }
    }

    private void baselineSet(GridClient client, String consistentIds) throws Throwable {
        try {
            VisorBaselineTaskResult res = (VisorBaselineTaskResult)this.executeTask(client, VisorBaselineTask.class, this.arg(VisorBaselineOperation.SET, consistentIds));
            this.baselinePrint0(res);
        }
        catch (Throwable e) {
            this.log("Failed to set baseline.");
            throw e;
        }
    }

    private void baselineVersion(GridClient client, String arg) throws GridClientException {
        try {
            VisorBaselineTaskResult res = (VisorBaselineTaskResult)this.executeTask(client, VisorBaselineTask.class, this.arg(VisorBaselineOperation.VERSION, arg));
            this.baselinePrint0(res);
        }
        catch (Throwable e) {
            this.log("Failed to set baseline with specified topology version.");
            throw e;
        }
    }

    private void transactions(GridClient client, VisorTxTaskArg arg) throws GridClientException {
        try {
            Map res = (Map)this.executeTask(client, VisorTxTask.class, arg);
            this.lastOperationRes = res;
            if (res.isEmpty()) {
                this.log("Nothing found.");
            } else if (arg.getOperation() == VisorTxOperation.KILL) {
                this.log("Killed transactions:");
            } else {
                this.log("Matching transactions:");
            }
            for (Map.Entry entry : res.entrySet()) {
                if (((VisorTxTaskResult)entry.getValue()).getInfos().isEmpty()) continue;
                ClusterNode key = (ClusterNode)entry.getKey();
                this.log(key.getClass().getSimpleName() + " [id=" + key.id() + ", addrs=" + key.addresses() + ", order=" + key.order() + ", ver=" + key.version() + ", isClient=" + key.isClient() + ", consistentId=" + key.consistentId() + "]");
                for (VisorTxInfo info : ((VisorTxTaskResult)entry.getValue()).getInfos()) {
                    this.log(info.toUserString());
                }
            }
        }
        catch (Throwable e) {
            this.log("Failed to perform operation.");
            throw e;
        }
    }

    private void wal(GridClient client, String walAct, String walArgs) throws Throwable {
        switch (walAct) {
            case "delete": {
                this.deleteUnusedWalSegments(client, walArgs);
                break;
            }
            default: {
                this.printUnusedWalSegments(client, walArgs);
            }
        }
    }

    private void deleteUnusedWalSegments(GridClient client, String walArgs) throws Throwable {
        VisorWalTaskResult res = (VisorWalTaskResult)this.executeTask(client, VisorWalTask.class, this.walArg(VisorWalTaskOperation.DELETE_UNUSED_WAL_SEGMENTS, walArgs));
        this.printDeleteWalSegments0(res);
    }

    private void printUnusedWalSegments(GridClient client, String walArgs) throws Throwable {
        VisorWalTaskResult res = (VisorWalTaskResult)this.executeTask(client, VisorWalTask.class, this.walArg(VisorWalTaskOperation.PRINT_UNUSED_WAL_SEGMENTS, walArgs));
        this.printUnusedWalSegments0(res);
    }

    private VisorWalTaskArg walArg(VisorWalTaskOperation op, String s) {
        ArrayList<String> consistentIds = null;
        if (!F.isEmpty(s)) {
            consistentIds = new ArrayList<String>();
            for (String consistentId : s.split(",")) {
                consistentIds.add(consistentId.trim());
            }
        }
        switch (op) {
            case DELETE_UNUSED_WAL_SEGMENTS: 
            case PRINT_UNUSED_WAL_SEGMENTS: {
                return new VisorWalTaskArg(op, consistentIds);
            }
        }
        return new VisorWalTaskArg(VisorWalTaskOperation.PRINT_UNUSED_WAL_SEGMENTS, consistentIds);
    }

    private void printUnusedWalSegments0(VisorWalTaskResult taskRes) {
        VisorClusterNode node;
        this.log("Unused wal segments per node:");
        this.nl();
        Map<String, Collection<String>> res = taskRes.results();
        Map<String, Exception> failRes = taskRes.exceptions();
        Map<String, VisorClusterNode> nodesInfo = taskRes.getNodesInfo();
        for (Map.Entry<String, Collection<String>> entry : res.entrySet()) {
            node = nodesInfo.get(entry.getKey());
            this.log("Node=" + node.getConsistentId());
            this.log(CommandHandler.i("addresses " + U.addressesAsString(node.getAddresses(), node.getHostNames()), 2));
            for (String fileName : entry.getValue()) {
                this.log(CommandHandler.i(fileName));
            }
            this.nl();
        }
        for (Map.Entry<String, Object> entry : failRes.entrySet()) {
            node = nodesInfo.get(entry.getKey());
            this.log("Node=" + node.getConsistentId());
            this.log(CommandHandler.i("addresses " + U.addressesAsString(node.getAddresses(), node.getHostNames())), 2);
            this.log(CommandHandler.i("failed with error: " + ((Exception)entry.getValue()).getMessage()));
            this.nl();
        }
    }

    private void printDeleteWalSegments0(VisorWalTaskResult taskRes) {
        VisorClusterNode node;
        this.log("WAL segments deleted for nodes:");
        this.nl();
        Map<String, Collection<String>> res = taskRes.results();
        Map<String, Exception> errors = taskRes.exceptions();
        Map<String, VisorClusterNode> nodesInfo = taskRes.getNodesInfo();
        for (Map.Entry<String, Collection<String>> entry : res.entrySet()) {
            node = nodesInfo.get(entry.getKey());
            this.log("Node=" + node.getConsistentId());
            this.log(CommandHandler.i("addresses " + U.addressesAsString(node.getAddresses(), node.getHostNames())), 2);
            this.nl();
        }
        for (Map.Entry<String, Object> entry : errors.entrySet()) {
            node = nodesInfo.get(entry.getKey());
            this.log("Node=" + node.getConsistentId());
            this.log(CommandHandler.i("addresses " + U.addressesAsString(node.getAddresses(), node.getHostNames())), 2);
            this.log(CommandHandler.i("failed with error: " + ((Exception)entry.getValue()).getMessage()));
            this.nl();
        }
    }

    private boolean isAuthError(Throwable e) {
        return X.hasCause(e, GridClientAuthenticationException.class);
    }

    private boolean isConnectionError(Throwable e) {
        return e instanceof GridClientClosedException || e instanceof GridClientConnectionResetException || e instanceof GridClientDisconnectedException || e instanceof GridClientHandshakeException || e instanceof GridServerUnreachableException;
    }

    private void usage(String desc, Command cmd, String ... args) {
        this.log(desc);
        this.log(CommandHandler.i(CommandHandler.j(" ", new Object[]{UTILITY_NAME, cmd, CommandHandler.j(" ", args)}), 2));
        this.nl();
    }

    private void usageCache(CacheCommand cmd, String ... args) {
        this.usageCache(1, cmd, args);
    }

    private void usageCache(int indentsNum, CacheCommand cmd, String ... args) {
        this.log(CommandHandler.i(DELIM, indentsNum));
        this.nl();
        this.log(CommandHandler.i(CommandHandler.j(" ", new Object[]{Command.CACHE, cmd, CommandHandler.j(" ", args)}), indentsNum++));
        this.nl();
        this.log(CommandHandler.i(this.getCacheSubcommandDesc(cmd), indentsNum));
        this.nl();
        Map<String, String> paramsDesc = this.createCacheArgsDesc(cmd);
        if (!paramsDesc.isEmpty()) {
            this.log(CommandHandler.i("Parameters:", indentsNum));
            this.usageCacheParams(paramsDesc, indentsNum + 1);
            this.nl();
        }
    }

    private void usageCacheParams(Map<String, String> paramsDesc, int indentsNum) {
        int maxParamLen = paramsDesc.keySet().stream().max(Comparator.comparingInt(String::length)).get().length();
        for (Map.Entry<String, String> param : paramsDesc.entrySet()) {
            this.log(CommandHandler.i(this.extendToLen(param.getKey(), maxParamLen) + INDENT + "- " + param.getValue(), indentsNum));
        }
    }

    private String extendToLen(String s, int targetLen) {
        assert (targetLen >= 0);
        assert (s.length() <= targetLen);
        if (s.length() == targetLen) {
            return s;
        }
        SB sb = new SB(targetLen);
        sb.a(s);
        for (int i = 0; i < targetLen - s.length(); ++i) {
            sb.a(" ");
        }
        return sb.toString();
    }

    private String getCacheSubcommandDesc(CacheCommand cmd) {
        switch (cmd) {
            case LIST: {
                return "Show information about caches, groups or sequences that match a regular expression. When executed without parameters, this subcommand prints the list of caches.";
            }
            case CONTENTION: {
                return "Show the keys that are point of contention for multiple transactions.";
            }
            case IDLE_VERIFY: {
                return "Verify counters and hash sums of primary and backup partitions for the specified caches on an idle cluster and print out the differences, if any.";
            }
            case VALIDATE_INDEXES: {
                return "Validate indexes on an idle cluster and print out the keys that are missing in the indexes.";
            }
            case DISTRIBUTION: {
                return "Prints the information about partition distribution.";
            }
            case RESET_LOST_PARTITIONS: {
                return "Reset the state of lost partitions for the specified caches.";
            }
        }
        throw new IllegalArgumentException("Unknown command: " + (Object)((Object)cmd));
    }

    private Map<String, String> createCacheArgsDesc(CacheCommand cmd) {
        LinkedHashMap<String, String> map = U.newLinkedHashMap(16);
        switch (cmd) {
            case LIST: {
                map.put(ListCommandArg.CONFIG.toString(), "print all configuration parameters for each cache.");
                map.put(ListCommandArg.OUTPUT_FORMAT + " " + (Object)((Object)OutputFormat.MULTI_LINE), "print configuration parameters per line. This option has effect only when used with " + ListCommandArg.CONFIG + " and without " + CommandHandler.op(CommandHandler.or(ListCommandArg.GROUP, ListCommandArg.SEQUENCE)) + ".");
                map.put(ListCommandArg.GROUP.toString(), "print information about groups.");
                map.put(ListCommandArg.SEQUENCE.toString(), "print information about sequences.");
                break;
            }
            case VALIDATE_INDEXES: {
                map.put(ValidateIndexesCommandArg.CHECK_FIRST + " N", "validate only the first N keys");
                map.put(ValidateIndexesCommandArg.CHECK_THROUGH + " K", "validate every Kth key");
                break;
            }
            case IDLE_VERIFY: {
                map.put(IdleVerifyCommandArg.CHECK_CRC.toString(), "check the CRC-sum of pages stored on disk before verifying data consistency in partitions between primary and backup nodes.");
            }
        }
        return map;
    }

    private static String op(Object ... params) {
        return CommandHandler.j(new SB(), "[", " ", params).a("]").toString();
    }

    private static String j(String delimeter, Object ... params) {
        return CommandHandler.j(new SB(), "", delimeter, params).toString();
    }

    private static SB j(SB sb, String sbDelimeter, String delimeter, Object ... params) {
        if (!F.isEmpty(params)) {
            sb.a(sbDelimeter);
            for (Object par : params) {
                sb.a(par).a(delimeter);
            }
            sb.setLength(sb.length() - delimeter.length());
        }
        return sb;
    }

    private static String or(Object ... params) {
        return CommandHandler.j("|", params);
    }

    private static String g(Object ... params) {
        return CommandHandler.j(new SB(), "(", " ", params).a(")").toString();
    }

    private String nextArg(String err) {
        if (this.peekedArg != null) {
            String res = this.peekedArg;
            this.peekedArg = null;
            return res;
        }
        if (this.argsIt.hasNext()) {
            return this.argsIt.next();
        }
        throw new IllegalArgumentException(err);
    }

    private String peekNextArg() {
        if (this.peekedArg == null && this.argsIt.hasNext()) {
            this.peekedArg = this.argsIt.next();
        }
        return this.peekedArg;
    }

    Arguments parseAndValidate(List<String> rawArgs) {
        Command cmd;
        String host = DFLT_HOST;
        String port = DFLT_PORT;
        String user = null;
        String pwd = null;
        String baselineAct = "";
        String baselineArgs = "";
        Long pingInterval = 5000L;
        Long pingTimeout = 30000L;
        String walAct = "";
        String walArgs = "";
        boolean autoConfirmation = false;
        CacheArguments cacheArgs = null;
        ArrayList<Command> commands = new ArrayList<Command>();
        this.initArgIterator(rawArgs);
        VisorTxTaskArg txArgs = null;
        String sslProtocol = "TLS";
        String sslCipherSuites = "";
        String sslKeyAlgorithm = "SunX509";
        String sslKeyStoreType = "JKS";
        String sslKeyStorePath = null;
        char[] sslKeyStorePassword = null;
        String sslTrustStoreType = "JKS";
        String sslTrustStorePath = null;
        char[] sslTrustStorePassword = null;
        String pwdArgWarnFmt = "Warning: %s is insecure. Whenever possible, use interactive prompt for password (just discard %s option).";
        block45: while (this.hasNextArg()) {
            String str = this.nextArg("").toLowerCase();
            cmd = Command.of(str);
            if (cmd != null) {
                switch (cmd) {
                    case DEACTIVATE: 
                    case ACTIVATE: 
                    case STATE: {
                        commands.add(cmd);
                        continue block45;
                    }
                    case TX: {
                        commands.add(Command.TX);
                        txArgs = this.parseTransactionArguments();
                        continue block45;
                    }
                    case BASELINE: {
                        commands.add(Command.BASELINE);
                        baselineAct = BASELINE_COLLECT;
                        str = this.peekNextArg();
                        if (str == null || !BASELINE_ADD.equals(str = str.toLowerCase()) && !BASELINE_REMOVE.equals(str) && !BASELINE_SET.equals(str) && !BASELINE_SET_VERSION.equals(str)) continue block45;
                        baselineAct = this.nextArg("Expected baseline action");
                        baselineArgs = this.nextArg("Expected baseline arguments");
                        continue block45;
                    }
                    case CACHE: {
                        commands.add(Command.CACHE);
                        cacheArgs = this.parseAndValidateCacheArgs();
                        continue block45;
                    }
                    case WAL: {
                        if (!this.enableExperimental) {
                            throw new IllegalArgumentException("Experimental command is disabled.");
                        }
                        commands.add(Command.WAL);
                        str = this.nextArg("Expected arguments for " + Command.WAL.text());
                        walAct = str.toLowerCase();
                        if (WAL_PRINT.equals(walAct) || WAL_DELETE.equals(walAct)) {
                            str = this.peekNextArg();
                            walArgs = str != null && !this.isCommandOrOption(str) ? this.nextArg("Unexpected argument for " + Command.WAL.text() + ": " + walAct) : "";
                            continue block45;
                        }
                        throw new IllegalArgumentException("Unexpected action " + walAct + " for " + Command.WAL.text());
                    }
                }
                throw new IllegalArgumentException("Unexpected command: " + str);
            }
            switch (str) {
                case "--host": {
                    host = this.nextArg("Expected host name");
                    break;
                }
                case "--port": {
                    port = this.nextArg("Expected port number");
                    try {
                        int p = Integer.parseInt(port);
                        if (p > 0 && p <= 65535) continue block45;
                        throw new IllegalArgumentException("Invalid value for port: " + port);
                    }
                    catch (NumberFormatException ignored) {
                        throw new IllegalArgumentException("Invalid value for port: " + port);
                    }
                }
                case "--ping-interval": {
                    pingInterval = this.getPingParam("Expected ping interval", "Invalid value for ping interval");
                    break;
                }
                case "--ping-timeout": {
                    pingTimeout = this.getPingParam("Expected ping timeout", "Invalid value for ping timeout");
                    break;
                }
                case "--user": {
                    user = this.nextArg("Expected user name");
                    break;
                }
                case "--password": {
                    pwd = this.nextArg("Expected password");
                    this.log(String.format("Warning: %s is insecure. Whenever possible, use interactive prompt for password (just discard %s option).", CMD_PASSWORD, CMD_PASSWORD));
                    break;
                }
                case "--ssl-protocol": {
                    sslProtocol = this.nextArg("Expected SSL protocol");
                    break;
                }
                case "--ssl-cipher-suites": {
                    sslCipherSuites = this.nextArg("Expected SSL cipher suites");
                    break;
                }
                case "--ssl-key-algorithm": {
                    sslKeyAlgorithm = this.nextArg("Expected SSL key algorithm");
                    break;
                }
                case "--keystore": {
                    sslKeyStorePath = this.nextArg("Expected SSL key store path");
                    break;
                }
                case "--keystore-password": {
                    sslKeyStorePassword = this.nextArg("Expected SSL key store password").toCharArray();
                    this.log(String.format("Warning: %s is insecure. Whenever possible, use interactive prompt for password (just discard %s option).", CMD_KEYSTORE_PASSWORD, CMD_KEYSTORE_PASSWORD));
                    break;
                }
                case "--keystore-type": {
                    sslKeyStoreType = this.nextArg("Expected SSL key store type");
                    break;
                }
                case "--truststore": {
                    sslTrustStorePath = this.nextArg("Expected SSL trust store path");
                    break;
                }
                case "--truststore-password": {
                    sslTrustStorePassword = this.nextArg("Expected SSL trust store password").toCharArray();
                    this.log(String.format("Warning: %s is insecure. Whenever possible, use interactive prompt for password (just discard %s option).", CMD_TRUSTSTORE_PASSWORD, CMD_TRUSTSTORE_PASSWORD));
                    break;
                }
                case "--truststore-type": {
                    sslTrustStoreType = this.nextArg("Expected SSL trust store type");
                    break;
                }
                case "--yes": {
                    autoConfirmation = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected argument: " + str);
                }
            }
        }
        int sz = commands.size();
        if (sz < 1) {
            throw new IllegalArgumentException("No action was specified");
        }
        if (sz > 1) {
            throw new IllegalArgumentException("Only one action can be specified, but found: " + sz);
        }
        cmd = (Command)((Object)commands.get(0));
        return new Arguments(cmd, host, port, user, pwd, baselineAct, baselineArgs, txArgs, cacheArgs, walAct, walArgs, pingTimeout, pingInterval, autoConfirmation, sslProtocol, sslCipherSuites, sslKeyAlgorithm, sslKeyStorePath, sslKeyStorePassword, sslKeyStoreType, sslTrustStorePath, sslTrustStorePassword, sslTrustStoreType);
    }

    private CacheArguments parseAndValidateCacheArgs() {
        if (!this.hasNextCacheArg()) {
            throw new IllegalArgumentException("Arguments are expected for --cache subcommand, run --cache help for more info.");
        }
        CacheArguments cacheArgs = new CacheArguments();
        String str = this.nextArg("").toLowerCase();
        CacheCommand cmd = CacheCommand.of(str);
        if (cmd == null) {
            cmd = CacheCommand.HELP;
        }
        cacheArgs.command(cmd);
        switch (cmd) {
            case HELP: {
                break;
            }
            case IDLE_VERIFY: {
                int idleVerifyArgsCnt = 3;
                while (this.hasNextCacheArg() && idleVerifyArgsCnt-- > 0) {
                    String nextArg = this.nextArg("");
                    IdleVerifyCommandArg arg = CommandArgUtils.of(nextArg, IdleVerifyCommandArg.class);
                    if (arg == null) {
                        if (cacheArgs.excludeCaches() != null || cacheArgs.getCacheFilterEnum() != CacheFilterEnum.ALL) {
                            throw new IllegalArgumentException(ONE_CACHE_FILTER_OPT_SHOULD_USED_MSG);
                        }
                        this.parseCacheNames(nextArg, cacheArgs);
                        continue;
                    }
                    switch (arg) {
                        case DUMP: {
                            cacheArgs.dump(true);
                            break;
                        }
                        case SKIP_ZEROS: {
                            cacheArgs.skipZeros(true);
                            break;
                        }
                        case CHECK_CRC: {
                            cacheArgs.idleCheckCrc(true);
                            break;
                        }
                        case CACHE_FILTER: {
                            if (cacheArgs.caches() != null || cacheArgs.excludeCaches() != null) {
                                throw new IllegalArgumentException(ONE_CACHE_FILTER_OPT_SHOULD_USED_MSG);
                            }
                            String filter = this.nextArg("The cache filter should be specified. The following values can be used: " + Arrays.toString((Object[])CacheFilterEnum.values()) + '.');
                            cacheArgs.setCacheFilterEnum(CacheFilterEnum.valueOf(filter.toUpperCase()));
                            break;
                        }
                        case EXCLUDE_CACHES: {
                            if (cacheArgs.caches() != null || cacheArgs.getCacheFilterEnum() != CacheFilterEnum.ALL) {
                                throw new IllegalArgumentException(ONE_CACHE_FILTER_OPT_SHOULD_USED_MSG);
                            }
                            this.parseExcludeCacheNames(this.nextArg("Specify caches, which will be excluded."), cacheArgs);
                        }
                    }
                }
                break;
            }
            case CONTENTION: {
                cacheArgs.minQueueSize(Integer.parseInt(this.nextArg("Min queue size expected")));
                if (this.hasNextCacheArg()) {
                    cacheArgs.nodeId(UUID.fromString(this.nextArg("")));
                }
                if (this.hasNextCacheArg()) {
                    cacheArgs.maxPrint(Integer.parseInt(this.nextArg("")));
                    break;
                }
                cacheArgs.maxPrint(10);
                break;
            }
            case VALIDATE_INDEXES: {
                int argsCnt = 0;
                while (this.hasNextCacheArg() && argsCnt++ < 4) {
                    String nextArg = this.nextArg("");
                    ValidateIndexesCommandArg arg = CommandArgUtils.of(nextArg, ValidateIndexesCommandArg.class);
                    if (arg == ValidateIndexesCommandArg.CHECK_FIRST || arg == ValidateIndexesCommandArg.CHECK_THROUGH) {
                        int numVal;
                        if (!this.hasNextCacheArg()) {
                            throw new IllegalArgumentException("Numeric value for '" + nextArg + "' parameter expected.");
                        }
                        String numStr = this.nextArg("");
                        try {
                            numVal = Integer.parseInt(numStr);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Not numeric value was passed for '" + nextArg + "' parameter: " + numStr);
                        }
                        if (numVal <= 0) {
                            throw new IllegalArgumentException("Value for '" + nextArg + "' property should be positive.");
                        }
                        if (arg == ValidateIndexesCommandArg.CHECK_FIRST) {
                            cacheArgs.checkFirst(numVal);
                            continue;
                        }
                        cacheArgs.checkThrough(numVal);
                        continue;
                    }
                    try {
                        cacheArgs.nodeId(UUID.fromString(nextArg));
                    }
                    catch (IllegalArgumentException numVal) {
                        this.parseCacheNames(nextArg, cacheArgs);
                    }
                }
                break;
            }
            case DISTRIBUTION: {
                String nodeIdStr = this.nextArg("Node id expected or null");
                if (!NULL.equals(nodeIdStr)) {
                    cacheArgs.nodeId(UUID.fromString(nodeIdStr));
                }
                while (this.hasNextCacheArg()) {
                    String nextArg = this.nextArg("");
                    DistributionCommandArg arg = CommandArgUtils.of(nextArg, DistributionCommandArg.class);
                    if (arg == DistributionCommandArg.USER_ATTRIBUTES) {
                        nextArg = this.nextArg("User attributes are expected to be separated by commas");
                        HashSet<String> userAttrs = new HashSet<String>();
                        for (String userAttribute : nextArg.split(",")) {
                            userAttrs.add(userAttribute.trim());
                        }
                        cacheArgs.setUserAttributes(userAttrs);
                        String string = nextArg = this.hasNextCacheArg() ? this.nextArg("") : null;
                    }
                    if (nextArg == null) continue;
                    this.parseCacheNames(nextArg, cacheArgs);
                }
                break;
            }
            case RESET_LOST_PARTITIONS: {
                this.parseCacheNames(this.nextArg("Cache name expected"), cacheArgs);
                break;
            }
            case LIST: {
                cacheArgs.regex(this.nextArg("Regex is expected"));
                VisorViewCacheCmd cacheCmd = VisorViewCacheCmd.CACHES;
                OutputFormat outputFormat = OutputFormat.SINGLE_LINE;
                while (this.hasNextCacheArg()) {
                    String nextArg = this.nextArg("").toLowerCase();
                    ListCommandArg arg = CommandArgUtils.of(nextArg, ListCommandArg.class);
                    if (arg != null) {
                        switch (arg) {
                            case GROUP: {
                                cacheCmd = VisorViewCacheCmd.GROUPS;
                                break;
                            }
                            case SEQUENCE: {
                                cacheCmd = VisorViewCacheCmd.SEQ;
                                break;
                            }
                            case OUTPUT_FORMAT: {
                                String tmp2 = this.nextArg("output format must be defined!").toLowerCase();
                                outputFormat = OutputFormat.fromConsoleName(tmp2);
                                break;
                            }
                            case CONFIG: {
                                cacheArgs.fullConfig(true);
                            }
                        }
                        continue;
                    }
                    cacheArgs.nodeId(UUID.fromString(nextArg));
                }
                cacheArgs.cacheCommand(cacheCmd);
                cacheArgs.outputFormat(outputFormat);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown --cache subcommand " + (Object)((Object)cmd));
            }
        }
        if (this.hasNextCacheArg()) {
            throw new IllegalArgumentException("Unexpected argument of --cache subcommand: " + this.peekNextArg());
        }
        return cacheArgs;
    }

    private boolean hasNextCacheArg() {
        return this.hasNextArg() && Command.of(this.peekNextArg()) == null && !AUX_COMMANDS.contains(this.peekNextArg());
    }

    private void parseCacheNames(String cacheNames, CacheArguments cacheArgs) {
        cacheArgs.caches(this.parseCacheNames(cacheNames));
    }

    private void parseExcludeCacheNames(String cacheNames, CacheArguments cacheArgs) {
        cacheArgs.excludeCaches(this.parseCacheNames(cacheNames));
    }

    private Set<String> parseCacheNames(String cacheNames) {
        String[] cacheNamesArr = cacheNames.split(",");
        HashSet<String> cacheNamesSet = new HashSet<String>();
        for (String cacheName : cacheNamesArr) {
            if (F.isEmpty(cacheName)) {
                throw new IllegalArgumentException("Non-empty cache names expected.");
            }
            cacheNamesSet.add(cacheName.trim());
        }
        return cacheNamesSet;
    }

    private Long getPingParam(String nextArgErr, String invalidErr) {
        String raw = this.nextArg(nextArgErr);
        try {
            long val = Long.valueOf(raw);
            if (val <= 0L) {
                throw new IllegalArgumentException(invalidErr + ": " + val);
            }
            return val;
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException(invalidErr + ": " + raw);
        }
    }

    private VisorTxTaskArg parseTransactionArguments() {
        String str;
        VisorTxProjection proj = null;
        Integer limit = null;
        VisorTxSortOrder sortOrder = null;
        Long duration = null;
        Integer size = null;
        String lbRegex = null;
        List<String> consistentIds = null;
        VisorTxOperation op = VisorTxOperation.LIST;
        String xid = null;
        boolean end = false;
        while ((str = this.peekNextArg()) != null) {
            switch (str) {
                case "--limit": {
                    this.nextArg("");
                    limit = (int)this.nextLongArg(TX_LIMIT);
                    break;
                }
                case "--order": {
                    this.nextArg("");
                    sortOrder = VisorTxSortOrder.valueOf(this.nextArg(TX_ORDER).toUpperCase());
                    break;
                }
                case "--servers": {
                    this.nextArg("");
                    proj = VisorTxProjection.SERVER;
                    break;
                }
                case "--clients": {
                    this.nextArg("");
                    proj = VisorTxProjection.CLIENT;
                    break;
                }
                case "--nodes": {
                    this.nextArg("");
                    consistentIds = this.getConsistentIds(this.nextArg(TX_NODES));
                    break;
                }
                case "--min-duration": {
                    this.nextArg("");
                    duration = this.nextLongArg(TX_DURATION) * 1000L;
                    break;
                }
                case "--min-size": {
                    this.nextArg("");
                    size = (int)this.nextLongArg(TX_SIZE);
                    break;
                }
                case "--label": {
                    this.nextArg("");
                    lbRegex = this.nextArg(TX_LABEL);
                    try {
                        Pattern.compile(lbRegex);
                        break;
                    }
                    catch (PatternSyntaxException ignored) {
                        throw new IllegalArgumentException("Illegal regex syntax");
                    }
                }
                case "--xid": {
                    this.nextArg("");
                    xid = this.nextArg(TX_XID);
                    break;
                }
                case "--kill": {
                    this.nextArg("");
                    op = VisorTxOperation.KILL;
                    break;
                }
                default: {
                    end = true;
                }
            }
            if (!end) continue;
        }
        if (proj != null && consistentIds != null) {
            throw new IllegalArgumentException("Projection can't be used together with list of consistent ids.");
        }
        return new VisorTxTaskArg(op, limit, duration, size, null, proj, consistentIds, xid, lbRegex, sortOrder);
    }

    private long nextLongArg(String lb) {
        String str = this.nextArg("Expecting " + lb);
        try {
            long val = Long.parseLong(str);
            if (val < 0L) {
                throw new IllegalArgumentException("Invalid value for " + lb + ": " + val);
            }
            return val;
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException("Invalid value for " + lb + ": " + str);
        }
    }

    private char[] requestPasswordFromConsole(String msg) {
        if (this.console == null) {
            throw new UnsupportedOperationException("Failed to securely read password (console is unavailable): " + msg);
        }
        return this.console.readPassword(msg, new Object[0]);
    }

    private String requestDataFromConsole(String msg) {
        if (this.console != null) {
            return this.console.readLine(msg, new Object[0]);
        }
        Scanner scanner = new Scanner(System.in);
        this.log(msg);
        return scanner.nextLine();
    }

    private boolean isCommandOrOption(String raw) {
        return raw != null && raw.contains("--");
    }

    private Map<String, Object> mapToPairs(VisorCacheConfiguration cfg) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        VisorCacheAffinityConfiguration affinityCfg = cfg.getAffinityConfiguration();
        VisorCacheNearConfiguration nearCfg = cfg.getNearConfiguration();
        VisorCacheRebalanceConfiguration rebalanceCfg = cfg.getRebalanceConfiguration();
        VisorCacheEvictionConfiguration evictCfg = cfg.getEvictionConfiguration();
        VisorCacheStoreConfiguration storeCfg = cfg.getStoreConfiguration();
        VisorQueryConfiguration qryCfg = cfg.getQueryConfiguration();
        params.put("Name", cfg.getName());
        params.put("Group", cfg.getGroupName());
        params.put("Dynamic Deployment ID", cfg.getDynamicDeploymentId());
        params.put("System", cfg.isSystem());
        params.put("Mode", (Object)cfg.getMode());
        params.put("Atomicity Mode", (Object)cfg.getAtomicityMode());
        params.put("Statistic Enabled", cfg.isStatisticsEnabled());
        params.put("Management Enabled", cfg.isManagementEnabled());
        params.put("On-heap cache enabled", cfg.isOnheapCacheEnabled());
        params.put("Partition Loss Policy", (Object)cfg.getPartitionLossPolicy());
        params.put("Query Parallelism", cfg.getQueryParallelism());
        params.put("Copy On Read", cfg.isCopyOnRead());
        params.put("Listener Configurations", cfg.getListenerConfigurations());
        params.put("Load Previous Value", cfg.isLoadPreviousValue());
        params.put("Memory Policy Name", cfg.getMemoryPolicyName());
        params.put("Node Filter", cfg.getNodeFilter());
        params.put("Read From Backup", cfg.isReadFromBackup());
        params.put("Topology Validator", cfg.getTopologyValidator());
        params.put("Time To Live Eager Flag", cfg.isEagerTtl());
        params.put("Write Synchronization Mode", (Object)cfg.getWriteSynchronizationMode());
        params.put("Invalidate", cfg.isInvalidate());
        params.put("Affinity Function", affinityCfg.getFunction());
        params.put("Affinity Backups", affinityCfg.getPartitionedBackups());
        params.put("Affinity Partitions", affinityCfg.getPartitions());
        params.put("Affinity Exclude Neighbors", affinityCfg.isExcludeNeighbors());
        params.put("Affinity Mapper", affinityCfg.getMapper());
        params.put("Rebalance Mode", (Object)rebalanceCfg.getMode());
        params.put("Rebalance Batch Size", rebalanceCfg.getBatchSize());
        params.put("Rebalance Timeout", rebalanceCfg.getTimeout());
        params.put("Rebalance Delay", rebalanceCfg.getPartitionedDelay());
        params.put("Time Between Rebalance Messages", rebalanceCfg.getThrottle());
        params.put("Rebalance Batches Count", rebalanceCfg.getBatchesPrefetchCnt());
        params.put("Rebalance Cache Order", rebalanceCfg.getRebalanceOrder());
        params.put("Eviction Policy Enabled", evictCfg.getPolicy() != null);
        params.put("Eviction Policy Factory", evictCfg.getPolicy());
        params.put("Eviction Policy Max Size", evictCfg.getPolicyMaxSize());
        params.put("Eviction Filter", evictCfg.getFilter());
        params.put("Near Cache Enabled", nearCfg.isNearEnabled());
        params.put("Near Start Size", nearCfg.getNearStartSize());
        params.put("Near Eviction Policy Factory", nearCfg.getNearEvictPolicy());
        params.put("Near Eviction Policy Max Size", nearCfg.getNearEvictMaxSize());
        params.put("Default Lock Timeout", cfg.getDefaultLockTimeout());
        params.put("Query Entities", cfg.getQueryEntities());
        params.put("Cache Interceptor", cfg.getInterceptor());
        params.put("Store Enabled", storeCfg.isEnabled());
        params.put("Store Class", storeCfg.getStore());
        params.put("Store Factory Class", storeCfg.getStoreFactory());
        params.put("Store Keep Binary", storeCfg.isStoreKeepBinary());
        params.put("Store Read Through", storeCfg.isReadThrough());
        params.put("Store Write Through", storeCfg.isWriteThrough());
        params.put("Store Write Coalescing", storeCfg.getWriteBehindCoalescing());
        params.put("Write-Behind Enabled", storeCfg.isWriteBehindEnabled());
        params.put("Write-Behind Flush Size", storeCfg.getFlushSize());
        params.put("Write-Behind Frequency", storeCfg.getFlushFrequency());
        params.put("Write-Behind Flush Threads Count", storeCfg.getFlushThreadCount());
        params.put("Write-Behind Batch Size", storeCfg.getBatchSize());
        params.put("Concurrent Asynchronous Operations Number", cfg.getMaxConcurrentAsyncOperations());
        params.put("Loader Factory Class Name", cfg.getLoaderFactory());
        params.put("Writer Factory Class Name", cfg.getWriterFactory());
        params.put("Expiry Policy Factory Class Name", cfg.getExpiryPolicyFactory());
        params.put("Query Execution Time Threshold", qryCfg.getLongQueryWarningTimeout());
        params.put("Query Escaped Names", qryCfg.isSqlEscapeAll());
        params.put("Query SQL Schema", qryCfg.getSqlSchema());
        params.put("Query SQL functions", qryCfg.getSqlFunctionClasses());
        params.put("Query Indexed Types", qryCfg.getIndexedTypes());
        params.put("Maximum payload size for offheap indexes", cfg.getSqlIndexMaxInlineSize());
        params.put("Query Metrics History Size", cfg.getQueryDetailMetricsSize());
        return params;
    }

    private List<String> split(String s, String delim) {
        if (F.isEmpty(s)) {
            return Collections.emptyList();
        }
        return Arrays.stream(s.split(delim)).map(String::trim).filter(item -> !item.isEmpty()).collect(Collectors.toList());
    }

    private String[] getTxOptions() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(CommandHandler.op(TX_XID, "XID"));
        list.add(CommandHandler.op(TX_DURATION, "SECONDS"));
        list.add(CommandHandler.op(TX_SIZE, "SIZE"));
        list.add(CommandHandler.op(TX_LABEL, "PATTERN_REGEX"));
        list.add(CommandHandler.op(CommandHandler.or(TX_SERVERS, TX_CLIENTS)));
        list.add(CommandHandler.op(TX_NODES, "consistentId1[,consistentId2,....,consistentIdN]"));
        list.add(CommandHandler.op(TX_LIMIT, "NUMBER"));
        list.add(CommandHandler.op(TX_ORDER, CommandHandler.or((Object[])VisorTxSortOrder.values())));
        list.add(CommandHandler.op(TX_KILL));
        list.add(CommandHandler.op(CMD_AUTO_CONFIRMATION));
        return list.toArray(new String[list.size()]);
    }

    private void printHelp() {
        String constistIds = "consistentId1[,consistentId2,....,consistentIdN]";
        this.log("Control.sh is used to execute admin commands on cluster or get common cluster info. The command has the following syntax:");
        this.nl();
        this.log(CommandHandler.i(CommandHandler.j(" ", UTILITY_NAME_WITH_COMMON_OPTIONS, CommandHandler.op("command"), "<command_parameters>")));
        this.nl();
        this.nl();
        this.log("This utility can do the following commands:");
        this.usage(CommandHandler.i("Activate cluster:"), Command.ACTIVATE, new String[0]);
        this.usage(CommandHandler.i("Deactivate cluster:"), Command.DEACTIVATE, CommandHandler.op(CMD_AUTO_CONFIRMATION));
        this.usage(CommandHandler.i("Print current cluster state:"), Command.STATE, new String[0]);
        this.usage(CommandHandler.i("Print cluster baseline topology:"), Command.BASELINE, new String[0]);
        this.usage(CommandHandler.i("Add nodes into baseline topology:"), Command.BASELINE, BASELINE_ADD, "consistentId1[,consistentId2,....,consistentIdN]", CommandHandler.op(CMD_AUTO_CONFIRMATION));
        this.usage(CommandHandler.i("Remove nodes from baseline topology:"), Command.BASELINE, BASELINE_REMOVE, "consistentId1[,consistentId2,....,consistentIdN]", CommandHandler.op(CMD_AUTO_CONFIRMATION));
        this.usage(CommandHandler.i("Set baseline topology:"), Command.BASELINE, BASELINE_SET, "consistentId1[,consistentId2,....,consistentIdN]", CommandHandler.op(CMD_AUTO_CONFIRMATION));
        this.usage(CommandHandler.i("Set baseline topology based on version:"), Command.BASELINE, "version topologyVersion", CommandHandler.op(CMD_AUTO_CONFIRMATION));
        this.usage(CommandHandler.i("List or kill transactions:"), Command.TX, this.getTxOptions());
        if (this.enableExperimental) {
            this.usage(CommandHandler.i("Print absolute paths of unused archived wal segments on each node:"), Command.WAL, WAL_PRINT, "[consistentId1,consistentId2,....,consistentIdN]");
            this.usage(CommandHandler.i("Delete unused archived wal segments on each node:"), Command.WAL, WAL_DELETE, "[consistentId1,consistentId2,....,consistentIdN]", CommandHandler.op(CMD_AUTO_CONFIRMATION));
        }
        this.log(CommandHandler.i("View caches information in a cluster. For more details type:"));
        this.log(CommandHandler.i(CommandHandler.j(" ", new Object[]{UTILITY_NAME, Command.CACHE, CacheCommand.HELP}), 2));
        this.nl();
        this.log("By default commands affecting the cluster require interactive confirmation.");
        this.log("Use --yes option to disable it.");
        this.nl();
        this.log("Default values:");
        this.log(CommandHandler.i("HOST_OR_IP=127.0.0.1", 2));
        this.log(CommandHandler.i("PORT=11211", 2));
        this.log(CommandHandler.i("PING_INTERVAL=5000", 2));
        this.log(CommandHandler.i("PING_TIMEOUT=30000", 2));
        this.log(CommandHandler.i("SSL_PROTOCOL=TLS", 2));
        this.log(CommandHandler.i("SSL_KEY_ALGORITHM=SunX509", 2));
        this.log(CommandHandler.i("KEYSTORE_TYPE=JKS", 2));
        this.log(CommandHandler.i("TRUSTSTORE_TYPE=JKS", 2));
        this.nl();
        this.log("Exit codes:");
        this.log(CommandHandler.i("0 - successful execution.", 2));
        this.log(CommandHandler.i("1 - invalid arguments.", 2));
        this.log(CommandHandler.i("2 - connection failed.", 2));
        this.log(CommandHandler.i("3 - authentication failed.", 2));
        this.log(CommandHandler.i("4 - unexpected error.", 2));
    }

    /*
     * Unable to fully structure code
     */
    public int execute(List<String> rawArgs) {
        this.log("Control utility [ver. " + IgniteVersionUtils.ACK_VER_STR + "]");
        this.log(IgniteVersionUtils.COPYRIGHT);
        this.log("User: " + System.getProperty("user.name"));
        this.log("Time: " + LocalDateTime.now());
        this.log("--------------------------------------------------------------------------------");
        try {
            if (F.isEmpty(rawArgs) || rawArgs.size() == 1 && "--help".equalsIgnoreCase(rawArgs.get(0))) {
                this.printHelp();
                return 0;
            }
            args = this.parseAndValidate(rawArgs);
            if (args.command() == Command.CACHE && args.cacheArgs().command() == CacheCommand.HELP) {
                this.printCacheHelp();
                return 0;
            }
            if (!args.autoConfirmation() && !this.confirm(args)) {
                this.log("Operation cancelled.");
                return 0;
            }
            this.clientCfg = new GridClientConfiguration();
            this.clientCfg.setPingInterval(args.pingInterval());
            this.clientCfg.setPingTimeout(args.pingTimeout());
            this.clientCfg.setServers(Collections.singletonList(args.host() + ":" + args.port()));
            tryConnectAgain = true;
            tryConnectMaxCount = 3;
lbl26:
            // 14 sources

            block23: while (tryConnectAgain) {
                tryConnectAgain = false;
                if (!F.isEmpty(args.getUserName())) {
                    securityCredential = this.clientCfg.getSecurityCredentialsProvider();
                    if (securityCredential == null) {
                        securityCredential = new SecurityCredentialsBasicProvider(new SecurityCredentials(args.getUserName(), args.getPassword()));
                        this.clientCfg.setSecurityCredentialsProvider(securityCredential);
                    }
                    credential = securityCredential.credentials();
                    credential.setLogin(args.getUserName());
                    credential.setPassword(args.getPassword());
                }
                if (!F.isEmpty(args.sslKeyStorePath())) {
                    factory = new GridSslBasicContextFactory();
                    sslProtocols = this.split(args.sslProtocol(), ",");
                    sslProtocol = F.isEmpty(sslProtocols) != false ? "TLS" : sslProtocols.get(0);
                    factory.setProtocol(sslProtocol);
                    factory.setKeyAlgorithm(args.sslKeyAlgorithm());
                    if (sslProtocols.size() > 1) {
                        factory.setProtocols(sslProtocols);
                    }
                    factory.setCipherSuites(this.split(args.getSslCipherSuites(), ","));
                    factory.setKeyStoreFilePath(args.sslKeyStorePath());
                    if (args.sslKeyStorePassword() != null) {
                        factory.setKeyStorePassword(args.sslKeyStorePassword());
                    } else {
                        factory.setKeyStorePassword(this.requestPasswordFromConsole("SSL keystore password: "));
                    }
                    factory.setKeyStoreType(args.sslKeyStoreType());
                    if (F.isEmpty(args.sslTrustStorePath())) {
                        factory.setTrustManagers(new TrustManager[]{GridSslBasicContextFactory.getDisabledTrustManager()});
                    } else {
                        factory.setTrustStoreFilePath(args.sslTrustStorePath());
                        if (args.sslTrustStorePassword() != null) {
                            factory.setTrustStorePassword(args.sslTrustStorePassword());
                        } else {
                            factory.setTrustStorePassword(this.requestPasswordFromConsole("SSL truststore password: "));
                        }
                        factory.setTrustStoreType(args.sslTrustStoreType());
                    }
                    this.clientCfg.setSslContextFactory(factory);
                }
                try {
                    client = GridClientFactory.start(this.clientCfg);
                    var6_9 = null;
                    try {
                        switch (1.$SwitchMap$org$apache$ignite$internal$commandline$Command[args.command().ordinal()]) {
                            case 5: {
                                this.activate(client);
                                ** break;
                            }
                            case 1: {
                                this.deactivate(client);
                                ** break;
                            }
                            case 6: {
                                this.state(client);
                                ** break;
                            }
                            case 2: {
                                this.baseline(client, args.baselineAction(), args.baselineArguments());
                                ** break;
                            }
                            case 4: {
                                this.transactions(client, args.transactionArguments());
                                ** break;
                            }
                            case 7: {
                                this.cache(client, args.cacheArgs());
                                ** break;
                            }
                            case 3: {
                                this.wal(client, args.walAction(), args.walArguments());
                                continue block23;
                            }
                            ** default:
lbl90:
                            // 1 sources

                            continue block23;
                        }
                    }
                    catch (Throwable var7_12) {
                        var6_9 = var7_12;
                        throw var7_12;
                    }
                    finally {
                        if (client == null) continue;
                        if (var6_9 != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable var7_11) {
                                var6_9.addSuppressed(var7_11);
                            }
                            continue;
                        }
                        client.close();
                    }
                }
                catch (Throwable e) {
                    if (tryConnectMaxCount > 0 && this.isAuthError(e)) {
                        this.log("Authentication error, try connection again.");
                        if (F.isEmpty(args.getUserName())) {
                            args.setUserName(this.requestDataFromConsole("user: "));
                        }
                        args.setPassword(new String(this.requestPasswordFromConsole("password: ")));
                        tryConnectAgain = true;
                        --tryConnectMaxCount;
                        continue;
                    }
                    if (tryConnectMaxCount == 0) {
                        throw new GridClientAuthenticationException("Authentication error, maximum number of retries exceeded");
                    }
                    throw e;
                }
            }
            return 0;
        }
        catch (IllegalArgumentException e) {
            return this.error(1, "Check arguments.", e);
        }
        catch (Throwable e) {
            if (this.isAuthError(e)) {
                return this.error(3, "Authentication error.", e);
            }
            if (this.isConnectionError(e)) {
                return this.error(2, "Connection to cluster failed.", e);
            }
            return this.error(4, "", e);
        }
    }

    public static void main(String[] args) {
        CommandHandler hnd = new CommandHandler();
        System.exit(hnd.execute(Arrays.asList(args)));
    }

    public <T> T getLastOperationResult() {
        return (T)this.lastOperationRes;
    }

    static {
        AUX_COMMANDS.add(CMD_HELP);
        AUX_COMMANDS.add(CMD_HOST);
        AUX_COMMANDS.add(CMD_PORT);
        AUX_COMMANDS.add(CMD_PASSWORD);
        AUX_COMMANDS.add(CMD_USER);
        AUX_COMMANDS.add(CMD_AUTO_CONFIRMATION);
        AUX_COMMANDS.add(CMD_PING_INTERVAL);
        AUX_COMMANDS.add(CMD_PING_TIMEOUT);
        AUX_COMMANDS.add(CMD_SSL_PROTOCOL);
        AUX_COMMANDS.add(CMD_SSL_KEY_ALGORITHM);
        AUX_COMMANDS.add(CMD_SSL_CIPHER_SUITES);
        AUX_COMMANDS.add(CMD_KEYSTORE);
        AUX_COMMANDS.add(CMD_KEYSTORE_PASSWORD);
        AUX_COMMANDS.add(CMD_KEYSTORE_TYPE);
        AUX_COMMANDS.add(CMD_TRUSTSTORE);
        AUX_COMMANDS.add(CMD_TRUSTSTORE_PASSWORD);
        AUX_COMMANDS.add(CMD_TRUSTSTORE_TYPE);
        BROADCAST_UUID = UUID.randomUUID();
        IN = new Scanner(System.in);
        COMMON_OPTIONS = CommandHandler.j(" ", CommandHandler.getCommonOptions());
        UTILITY_NAME_WITH_COMMON_OPTIONS = CommandHandler.j(" ", UTILITY_NAME, COMMON_OPTIONS);
        OP_NODE_ID = CommandHandler.op(NODE_ID);
    }
}

