/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.ignite.internal.IgniteProperties;
import org.apache.ignite.lang.IgniteProductVersion;

public class IgniteVersionUtils {
    public static final String VER_STR = IgniteProperties.get("ignite.version").replace(".a", "-a").replace(".b", "-b").replace(".final", "-final");
    public static final IgniteProductVersion VER;
    public static final String BUILD_TSTAMP_STR;
    public static final long BUILD_TSTAMP;
    private static final String BUILD_TSTAMP_FROM_PROPERTY;
    public static final String REV_HASH_STR;
    public static final String RELEASE_DATE_STR;
    public static final String ACK_VER_STR;
    public static final String COPYRIGHT;

    private IgniteVersionUtils() {
    }

    static {
        BUILD_TSTAMP_FROM_PROPERTY = IgniteProperties.get("ignite.build");
        BUILD_TSTAMP = !BUILD_TSTAMP_FROM_PROPERTY.isEmpty() && Long.parseLong(BUILD_TSTAMP_FROM_PROPERTY) != 0L ? Long.parseLong(BUILD_TSTAMP_FROM_PROPERTY) : System.currentTimeMillis() / 1000L;
        BUILD_TSTAMP_STR = new SimpleDateFormat("yyyyMMdd").format(new Date(BUILD_TSTAMP * 1000L));
        COPYRIGHT = BUILD_TSTAMP_STR.substring(0, 4) + " Copyright(C) Apache Software Foundation";
        REV_HASH_STR = IgniteProperties.get("ignite.revision");
        RELEASE_DATE_STR = IgniteProperties.get("ignite.rel.date");
        String rev = REV_HASH_STR.length() > 8 ? REV_HASH_STR.substring(0, 8) : REV_HASH_STR;
        ACK_VER_STR = VER_STR + '#' + BUILD_TSTAMP_STR + "-sha1:" + rev;
        VER = IgniteProductVersion.fromString(VER_STR + '-' + BUILD_TSTAMP + '-' + REV_HASH_STR);
    }
}

