/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.BitSet;
import org.apache.ignite.cluster.ClusterNode;

public final class IgniteFeatures
extends Enum<IgniteFeatures> {
    public static final /* enum */ IgniteFeatures TCP_COMMUNICATION_SPI_HANDSHAKE_WAIT_MESSAGE = new IgniteFeatures(0);
    public static final /* enum */ IgniteFeatures CACHE_METRICS_V2 = new IgniteFeatures(1);
    public static final /* enum */ IgniteFeatures DISTRIBUTED_METASTORAGE = new IgniteFeatures(2);
    public static final /* enum */ IgniteFeatures DATA_PACKET_COMPRESSION = new IgniteFeatures(3);
    public static final /* enum */ IgniteFeatures DIFFERENT_REBALANCE_POOL_SIZE = new IgniteFeatures(4);
    private final int featureId;
    private static final /* synthetic */ IgniteFeatures[] $VALUES;

    public static IgniteFeatures[] values() {
        return (IgniteFeatures[])$VALUES.clone();
    }

    public static IgniteFeatures valueOf(String name) {
        return Enum.valueOf(IgniteFeatures.class, name);
    }

    private IgniteFeatures(int featureId) {
        this.featureId = featureId;
    }

    public int getFeatureId() {
        return this.featureId;
    }

    public static boolean nodeSupports(ClusterNode clusterNode, IgniteFeatures feature) {
        boolean res;
        byte[] features = (byte[])clusterNode.attribute("org.apache.ignite.features");
        if (features == null) {
            return false;
        }
        int featureId = feature.getFeatureId();
        int byteIdx = featureId >>> 3;
        if (byteIdx >= features.length) {
            return false;
        }
        int bitIdx = featureId & 7;
        boolean bl = res = (features[byteIdx] & 1 << bitIdx) != 0;
        assert (res == BitSet.valueOf(features).get(featureId));
        return res;
    }

    public static boolean allNodesSupports(Iterable<ClusterNode> nodes, IgniteFeatures feature) {
        for (ClusterNode next : nodes) {
            if (IgniteFeatures.nodeSupports(next, feature)) continue;
            return false;
        }
        return true;
    }

    public static byte[] allFeatures() {
        BitSet set = new BitSet();
        for (IgniteFeatures value : IgniteFeatures.values()) {
            int featureId = value.getFeatureId();
            assert (!set.get(featureId)) : "Duplicate feature ID found for [" + (Object)((Object)value) + "] having same ID [" + featureId + "]";
            set.set(featureId);
        }
        return set.toByteArray();
    }

    static {
        $VALUES = new IgniteFeatures[]{TCP_COMMUNICATION_SPI_HANDSHAKE_WAIT_MESSAGE, CACHE_METRICS_V2, DISTRIBUTED_METASTORAGE, DATA_PACKET_COMPRESSION, DIFFERENT_REBALANCE_POOL_SIZE};
    }
}

