/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.mxbean.ClusterMetricsMXBean;

public class ClusterLocalNodeMetricsMXBeanImpl
implements ClusterMetricsMXBean {
    private final ClusterNode node;
    private final GridDiscoveryManager discoMgr;

    public ClusterLocalNodeMetricsMXBeanImpl(GridDiscoveryManager discoMgr) {
        assert (discoMgr != null);
        this.discoMgr = discoMgr;
        this.node = discoMgr.localNode();
    }

    @Override
    public int getTotalCpus() {
        return this.node.metrics().getTotalCpus();
    }

    @Override
    public float getAverageActiveJobs() {
        return this.node.metrics().getAverageActiveJobs();
    }

    @Override
    public float getAverageCancelledJobs() {
        return this.node.metrics().getAverageCancelledJobs();
    }

    @Override
    public double getAverageJobExecuteTime() {
        return this.node.metrics().getAverageJobExecuteTime();
    }

    @Override
    public double getAverageJobWaitTime() {
        return this.node.metrics().getAverageJobWaitTime();
    }

    @Override
    public float getAverageRejectedJobs() {
        return this.node.metrics().getAverageRejectedJobs();
    }

    @Override
    public float getAverageWaitingJobs() {
        return this.node.metrics().getAverageWaitingJobs();
    }

    @Override
    public float getBusyTimePercentage() {
        return this.node.metrics().getBusyTimePercentage() * 100.0f;
    }

    @Override
    public int getCurrentActiveJobs() {
        return this.node.metrics().getCurrentActiveJobs();
    }

    @Override
    public int getCurrentCancelledJobs() {
        return this.node.metrics().getCurrentCancelledJobs();
    }

    @Override
    public long getCurrentIdleTime() {
        return this.node.metrics().getCurrentIdleTime();
    }

    @Override
    public long getCurrentJobExecuteTime() {
        return this.node.metrics().getCurrentJobExecuteTime();
    }

    @Override
    public long getCurrentJobWaitTime() {
        return this.node.metrics().getCurrentJobWaitTime();
    }

    @Override
    public int getCurrentRejectedJobs() {
        return this.node.metrics().getCurrentRejectedJobs();
    }

    @Override
    public int getCurrentWaitingJobs() {
        return this.node.metrics().getCurrentWaitingJobs();
    }

    @Override
    public int getTotalExecutedTasks() {
        return this.node.metrics().getTotalExecutedTasks();
    }

    @Override
    public int getCurrentDaemonThreadCount() {
        return this.node.metrics().getCurrentDaemonThreadCount();
    }

    @Override
    public long getHeapMemoryCommitted() {
        return this.node.metrics().getHeapMemoryCommitted();
    }

    @Override
    public long getHeapMemoryInitialized() {
        return this.node.metrics().getHeapMemoryInitialized();
    }

    @Override
    public long getHeapMemoryMaximum() {
        return this.node.metrics().getHeapMemoryMaximum();
    }

    @Override
    public long getHeapMemoryTotal() {
        return this.node.metrics().getHeapMemoryTotal();
    }

    @Override
    public long getHeapMemoryUsed() {
        return this.node.metrics().getHeapMemoryUsed();
    }

    @Override
    public float getIdleTimePercentage() {
        return this.node.metrics().getIdleTimePercentage() * 100.0f;
    }

    @Override
    public long getLastUpdateTime() {
        return this.node.metrics().getLastUpdateTime();
    }

    @Override
    public int getMaximumActiveJobs() {
        return this.node.metrics().getMaximumActiveJobs();
    }

    @Override
    public int getMaximumCancelledJobs() {
        return this.node.metrics().getMaximumCancelledJobs();
    }

    @Override
    public long getMaximumJobExecuteTime() {
        return this.node.metrics().getMaximumJobExecuteTime();
    }

    @Override
    public long getMaximumJobWaitTime() {
        return this.node.metrics().getMaximumJobWaitTime();
    }

    @Override
    public int getMaximumRejectedJobs() {
        return this.node.metrics().getMaximumRejectedJobs();
    }

    @Override
    public int getMaximumWaitingJobs() {
        return this.node.metrics().getMaximumWaitingJobs();
    }

    @Override
    public long getNonHeapMemoryCommitted() {
        return this.node.metrics().getNonHeapMemoryCommitted();
    }

    @Override
    public long getNonHeapMemoryInitialized() {
        return this.node.metrics().getNonHeapMemoryInitialized();
    }

    @Override
    public long getNonHeapMemoryMaximum() {
        return this.node.metrics().getNonHeapMemoryMaximum();
    }

    @Override
    public long getNonHeapMemoryTotal() {
        return this.node.metrics().getNonHeapMemoryTotal();
    }

    @Override
    public long getNonHeapMemoryUsed() {
        return this.node.metrics().getNonHeapMemoryUsed();
    }

    @Override
    public int getMaximumThreadCount() {
        return this.node.metrics().getMaximumThreadCount();
    }

    @Override
    public long getStartTime() {
        return this.node.metrics().getStartTime();
    }

    @Override
    public long getNodeStartTime() {
        return this.node.metrics().getNodeStartTime();
    }

    @Override
    public double getCurrentCpuLoad() {
        return this.node.metrics().getCurrentCpuLoad() * 100.0;
    }

    @Override
    public double getAverageCpuLoad() {
        return this.node.metrics().getAverageCpuLoad() * 100.0;
    }

    @Override
    public double getCurrentGcCpuLoad() {
        return this.node.metrics().getCurrentGcCpuLoad() * 100.0;
    }

    @Override
    public int getCurrentThreadCount() {
        return this.node.metrics().getCurrentThreadCount();
    }

    @Override
    public long getTotalBusyTime() {
        return this.node.metrics().getTotalBusyTime();
    }

    @Override
    public int getTotalCancelledJobs() {
        return this.node.metrics().getTotalCancelledJobs();
    }

    @Override
    public int getTotalExecutedJobs() {
        return this.node.metrics().getTotalExecutedJobs();
    }

    @Override
    public long getTotalJobsExecutionTime() {
        return this.node.metrics().getTotalJobsExecutionTime();
    }

    @Override
    public long getTotalIdleTime() {
        return this.node.metrics().getTotalIdleTime();
    }

    @Override
    public int getTotalRejectedJobs() {
        return this.node.metrics().getTotalRejectedJobs();
    }

    @Override
    public long getTotalStartedThreadCount() {
        return this.node.metrics().getTotalStartedThreadCount();
    }

    @Override
    public long getUpTime() {
        return this.node.metrics().getUpTime();
    }

    @Override
    public long getLastDataVersion() {
        return this.node.metrics().getLastDataVersion();
    }

    @Override
    public int getSentMessagesCount() {
        return this.node.metrics().getSentMessagesCount();
    }

    @Override
    public long getSentBytesCount() {
        return this.node.metrics().getSentBytesCount();
    }

    @Override
    public int getReceivedMessagesCount() {
        return this.node.metrics().getReceivedMessagesCount();
    }

    @Override
    public long getReceivedBytesCount() {
        return this.node.metrics().getReceivedBytesCount();
    }

    @Override
    public int getOutboundMessagesQueueSize() {
        return this.node.metrics().getOutboundMessagesQueueSize();
    }

    @Override
    public int getTotalNodes() {
        return this.node.metrics().getTotalNodes();
    }

    @Override
    public int getTotalBaselineNodes() {
        List<? extends BaselineNode> baselineNodes;
        if (!this.node.isClient() && !this.node.isDaemon() && (baselineNodes = this.discoMgr.baselineNodes(this.discoMgr.topologyVersionEx())) != null) {
            for (BaselineNode baselineNode : baselineNodes) {
                if (!baselineNode.consistentId().equals(this.node.consistentId())) continue;
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int getActiveBaselineNodes() {
        return this.getTotalBaselineNodes();
    }

    @Override
    public int getTotalServerNodes() {
        return !this.node.isClient() ? 1 : 0;
    }

    @Override
    public int getTotalClientNodes() {
        return this.node.isClient() ? 1 : 0;
    }

    @Override
    public long getTopologyVersion() {
        return this.discoMgr.topologyVersion();
    }

    @Override
    public Set<String> attributeNames() {
        return new TreeSet<String>(this.node.attributes().keySet());
    }

    @Override
    public Set<String> attributeValues(String attrName) {
        Object val = this.node.attribute(attrName);
        return val == null ? Collections.emptySet() : Collections.singleton(val.toString());
    }

    @Override
    public Set<UUID> nodeIdsForAttribute(String attrName, String attrVal, boolean includeSrvs, boolean includeClients) {
        Object nodeVal;
        if ((includeClients && this.node.isClient() || includeSrvs && !this.node.isClient()) && (nodeVal = this.node.attribute(attrName)) != null && nodeVal.toString().equals(attrVal)) {
            return Collections.singleton(this.node.id());
        }
        return Collections.emptySet();
    }

    public String toString() {
        return S.toString(ClusterLocalNodeMetricsMXBeanImpl.class, this);
    }
}

