/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.websocket;

import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import org.apache.ignite.console.json.RawContentDeserializer;
import org.apache.ignite.console.utils.Utils;
import org.apache.ignite.console.websocket.WebSocketEvent;
import org.apache.ignite.console.websocket.WebSocketResponse;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class WebSocketRequest
implements WebSocketEvent<String> {
    private String reqId;
    private String evtType;
    @GridToStringInclude
    private String payload;

    @Override
    public String getRequestId() {
        return this.reqId;
    }

    @Override
    public void setRequestId(String reqId) {
        this.reqId = reqId;
    }

    @Override
    public String getEventType() {
        return this.evtType;
    }

    @Override
    public void setEventType(String evtType) {
        this.evtType = evtType;
    }

    @Override
    @JsonRawValue
    public String getPayload() {
        return this.payload;
    }

    @Override
    @JsonDeserialize(using=RawContentDeserializer.class)
    public void setPayload(String payload) {
        this.payload = payload;
    }

    public WebSocketResponse response(Object payload) {
        return new WebSocketResponse(this.reqId, this.evtType, payload);
    }

    public WebSocketResponse withError(String prefix, Throwable e) {
        HashMap<String, String> err = new HashMap<String, String>();
        err.put("message", e != null ? Utils.extractErrorMessage(prefix, e) : prefix);
        return new WebSocketResponse(this.getRequestId(), "error", err);
    }

    public String toString() {
        return S.toString(WebSocketRequest.class, (Object)this);
    }
}

