/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.websocket;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.console.utils.Utils;
import org.apache.ignite.internal.processors.rest.client.message.GridClientNodeBean;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgniteProductVersion;

public class TopologySnapshot {
    private static final String IGNITE_CLUSTER_ID = "IGNITE_CLUSTER_ID";
    private static final String GRIDGAIN_PLUGIN = "plugins.gg.node";
    private static final String ULTIMATE_CLUSTER = "plugins.gg.ultimate";
    private String id;
    private String name;
    private boolean active;
    private boolean secured;
    private boolean demo;
    private boolean gridgain;
    private boolean ultimate;
    private String clusterVer;
    private Map<UUID, NodeBean> nodes;
    private byte[] supportedFeatures;
    private final long creationTime = U.currentTimeMillis();

    public TopologySnapshot() {
        this.nodes = Collections.emptyMap();
    }

    public TopologySnapshot(Collection<GridClientNodeBean> nodes) {
        Collection<GridClientNodeBean> srvs = this.forServers(nodes);
        this.id = this.firstNonNullAttribute(srvs, IGNITE_CLUSTER_ID);
        this.name = this.firstNonNullAttribute(srvs, "IGNITE_CLUSTER_NAME");
        this.gridgain = this.allHasAttribute(srvs, GRIDGAIN_PLUGIN, true);
        this.ultimate = this.allHasAttribute(srvs, ULTIMATE_CLUSTER, true);
        this.supportedFeatures = this.supportedFeatures(nodes);
        this.clusterVer = this.clusterVersion(nodes);
        this.nodes = this.nodeMap(nodes);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClusterVersion() {
        return this.clusterVer;
    }

    public void setClusterVersion(String clusterVer) {
        this.clusterVer = clusterVer;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    public boolean isDemo() {
        return this.demo;
    }

    public void setDemo(boolean demo) {
        this.demo = demo;
    }

    public Map<UUID, NodeBean> getNodes() {
        return this.nodes;
    }

    public boolean isGridgain() {
        return this.gridgain;
    }

    public boolean isUltimate() {
        return this.ultimate;
    }

    private Map<UUID, NodeBean> nodeMap(Collection<GridClientNodeBean> nodes) {
        return nodes.stream().collect(Collectors.toMap(GridClientNodeBean::getNodeId, node -> {
            Map attrs = node.getAttributes();
            Boolean client = (Boolean)Utils.attribute(attrs, "org.apache.ignite.cache.client");
            Collection nodeAddrs = client != false ? VisorTaskUtils.splitAddresses((String)((String)Utils.attribute(attrs, "org.apache.ignite.ips"))) : node.getTcpAddresses();
            String firstIP = (String)F.first((Iterable)VisorTaskUtils.sortAddresses((Collection)nodeAddrs));
            return new NodeBean(client, firstIP);
        }));
    }

    public Set<UUID> nids() {
        return this.nodes.keySet();
    }

    public byte[] getSupportedFeatures() {
        return this.supportedFeatures;
    }

    private byte[] supportedFeatures(Collection<GridClientNodeBean> nodes) {
        if (F.isEmpty(nodes)) {
            return new byte[0];
        }
        return nodes.stream().map(n -> Utils.attribute(n.getAttributes(), "org.apache.ignite.features")).filter(Objects::nonNull).map(f -> BitSet.valueOf(Base64.getDecoder().decode(f.toString()))).collect(BitSet::new, (acc, f) -> {
            if (acc.isEmpty()) {
                acc.or((BitSet)f);
            } else {
                acc.and((BitSet)f);
            }
        }, BitSet::and).toByteArray();
    }

    private String firstNonNullAttribute(Collection<GridClientNodeBean> nodes, String key) {
        return nodes.stream().map(n -> n.getAttributes().get(key)).filter(Objects::nonNull).findFirst().map(Object::toString).orElse(null);
    }

    private boolean allHasAttribute(Collection<GridClientNodeBean> nodes, String key, Object val) {
        return nodes.stream().allMatch(n -> val.equals(n.getAttributes().get(key)));
    }

    private Collection<GridClientNodeBean> forServers(Collection<GridClientNodeBean> nodes) {
        return nodes.stream().filter(n -> (Boolean)n.getAttributes().get("org.apache.ignite.cache.client") == false).collect(Collectors.toList());
    }

    private String clusterVersion(Collection<GridClientNodeBean> nodes) {
        return nodes.stream().map(n -> n.getAttributes().get("org.apache.ignite.build.ver")).filter(Objects::nonNull).map(Object::toString).min(Comparator.comparing(IgniteProductVersion::fromString)).orElse(null);
    }

    public boolean sameNodes(TopologySnapshot other) {
        return other != null && !F.isEmpty(other.nids()) && !Collections.disjoint(this.nids(), other.nids());
    }

    public boolean isExpired(long maxInactiveInterval) {
        return U.currentTimeMillis() - maxInactiveInterval >= this.creationTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologySnapshot snapshot = (TopologySnapshot)o;
        return this.id.equals(snapshot.id) && this.nids().equals(snapshot.nids()) && this.active == snapshot.active && Objects.equals(this.name, snapshot.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.nids(), this.active, this.name);
    }

    public String toString() {
        return S.toString(TopologySnapshot.class, (Object)this);
    }

    public static class NodeBean {
        private boolean client;
        private String addr;

        @JsonCreator
        public NodeBean(@JsonProperty(value="client") boolean client, @JsonProperty(value="address") String addr) {
            this.client = client;
            this.addr = addr;
        }

        public boolean isClient() {
            return this.client;
        }

        public String getAddress() {
            return this.addr;
        }
    }
}

