/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.console.json.JsonObject;
import org.apache.ignite.internal.util.typedef.F;

public class Utils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private Utils() {
    }

    public static String toJson(Object v) {
        try {
            return MAPPER.writeValueAsString(v);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to serialize as JSON: " + v, e);
        }
    }

    public static JsonObject asJson(Object v) {
        if (v instanceof JsonObject) {
            return (JsonObject)v;
        }
        if (v instanceof Map) {
            return new JsonObject((Map)v);
        }
        throw new ClassCastException("Not a JSON");
    }

    public static <T> T fromJson(String json, Class<T> cls) throws IOException {
        return (T)MAPPER.readValue(json, cls);
    }

    public static <T> T fromJson(byte[] json, Class<T> cls) throws IOException {
        return (T)MAPPER.readValue(json, cls);
    }

    public static <T> T fromJson(byte[] json, TypeReference<T> typeRef) throws IOException {
        return (T)MAPPER.readValue(json, typeRef);
    }

    public static <T> T fromJson(Reader src, Class<T> cls) throws IOException {
        return (T)MAPPER.readValue(src, cls);
    }

    public static <T> T fromJson(String json, TypeReference<T> typeRef) throws IOException {
        return (T)MAPPER.readValue(json, typeRef);
    }

    public static JsonObject fromJson(String json) {
        try {
            return (JsonObject)MAPPER.readValue(json, JsonObject.class);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to deserialize object from JSON: " + json, e);
        }
    }

    public static JsonObject fromJson(byte[] json) {
        try {
            return (JsonObject)MAPPER.readValue(json, JsonObject.class);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to deserialize object from JSON", e);
        }
    }

    public static <T> T attribute(Map<String, Object> attrs, String name) {
        return (T)attrs.get(name);
    }

    public static String errorMessage(Throwable cause) {
        String msg = cause.getMessage();
        return F.isEmpty((String)msg) ? cause.getClass().getName() : msg;
    }

    public static String extractErrorMessage(String prefix, Throwable e) {
        String causeMsg = F.isEmpty((String)e.getMessage()) ? e.getClass().getName() : e.getMessage();
        return prefix + ": " + causeMsg;
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V val) {
        return new AbstractMap.SimpleEntry<K, V>(key, val);
    }

    public static <K, U> Collector<Map.Entry<K, U>, ?, Map<K, U>> entriesToMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T> Set<T> concat(Set<T> evts1, Set<T> evts2) {
        return Stream.concat(evts1.stream(), evts2.stream()).collect(Collectors.toSet());
    }
}

