/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.messages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class WildcardReloadableResourceBundleMessageSource
extends ReloadableResourceBundleMessageSource {
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String CLASSES = "classes/";
    private static final String CLASS_PATH = "classpath:";
    private ResourcePatternResolver ptrnRslvr = new PathMatchingResourcePatternResolver();

    public void setBasenames(String ... passedInBaseNames) {
        if (passedInBaseNames != null) {
            ArrayList baseNames = new ArrayList();
            Stream.of(passedInBaseNames).filter(StringUtils::isNotBlank).map(this::getResources).flatMap(this::getBaseNames).forEach(baseNames::add);
            super.setBasenames(baseNames.toArray(new String[0]));
        }
    }

    private Resource[] getResources(String name) {
        try {
            return this.ptrnRslvr.getResources(name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Stream<String> getBaseNames(Resource[] resources) {
        return Stream.of(resources).map(this::getBaseName);
    }

    private String getBaseName(Resource rsrc) {
        try {
            String baseName = null;
            String uri = rsrc.getURI().toString();
            if (!uri.endsWith(PROPERTIES_SUFFIX)) {
                return baseName;
            }
            baseName = rsrc instanceof ClassPathResource ? StringUtils.substringBefore((String)uri, (String)PROPERTIES_SUFFIX) : (rsrc instanceof UrlResource ? CLASS_PATH + StringUtils.substringBetween((String)uri, (String)".jar!/", (String)PROPERTIES_SUFFIX) : CLASS_PATH + StringUtils.substringBetween((String)uri, (String)CLASSES, (String)PROPERTIES_SUFFIX));
            return baseName;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

