/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.console.json;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.console.json.JsonArray;

public class JsonObject
extends LinkedHashMap<String, Object> {
    public JsonObject() {
    }

    public JsonObject(Map<String, Object> map) {
        super(map);
    }

    public JsonObject add(String key, Object val) {
        this.put(key, val);
        return this;
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public Boolean getBoolean(String key, boolean dflt) {
        Boolean val = (Boolean)this.get(key);
        return val != null || this.containsKey(key) ? val : dflt;
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public String getString(String key, String dflt) {
        String val = (String)this.get(key);
        return val != null || this.containsKey(key) ? val : dflt;
    }

    public Integer getInteger(String key) {
        return (Integer)this.get(key);
    }

    public Integer getInteger(String key, Integer dflt) {
        Integer val = (Integer)this.get(key);
        return val != null ? val : dflt;
    }

    public Long getLong(String key, Long dflt) {
        Long val = (Long)this.get(key);
        return val != null ? val : dflt;
    }

    public UUID getUuid(String key) {
        Object val = this.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof UUID) {
            return (UUID)val;
        }
        if (val instanceof String) {
            return UUID.fromString(val.toString());
        }
        throw new ClassCastException("Failed to get UUID from: " + val);
    }

    public JsonObject getJsonObject(String key) {
        Object val = this.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof JsonObject) {
            return (JsonObject)val;
        }
        if (val instanceof Map) {
            return new JsonObject((Map)val);
        }
        throw new ClassCastException("Failed to get JSON from: " + val);
    }

    public JsonArray getJsonArray(String key) {
        Object val = this.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof JsonArray) {
            return (JsonArray)val;
        }
        if (val instanceof Collection) {
            return new JsonArray((Collection)val);
        }
        throw new ClassCastException("Failed to get JSON from: " + val);
    }

    public JsonObject mergeIn(JsonObject other) {
        this.putAll(other);
        return this;
    }
}

