/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.CompoundLockFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTransactionalCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.ResultSetEnlistFuture;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.opt.DistributedJoinMode;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryType;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RetryException;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.twostep.MapNodeResults;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryLazyWorker;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryLazyWorkerKey;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryResult;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryResults;
import org.apache.ignite.internal.processors.query.h2.twostep.PartitionReservation;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryFailResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2SelectForUpdateTxDetails;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.thread.IgniteThread;
import org.h2.command.Prepared;
import org.h2.jdbc.JdbcResultSet;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class GridMapQueryExecutor {
    public static final boolean FORCE_LAZY = IgniteSystemProperties.getBoolean((String)"IGNITE_SQL_FORCE_LAZY_RESULT_SET");
    private IgniteLogger log;
    private GridKernalContext ctx;
    private IgniteH2Indexing h2;
    private ConcurrentMap<UUID, MapNodeResults> qryRess = new ConcurrentHashMap<UUID, MapNodeResults>();
    private final GridSpinBusyLock busyLock;
    private final ConcurrentHashMap<MapQueryLazyWorkerKey, MapQueryLazyWorker> lazyWorkers = new ConcurrentHashMap();
    private final GridSpinBusyLock lazyWorkerBusyLock = new GridSpinBusyLock();
    private final AtomicBoolean lazyWorkerStopGuard = new AtomicBoolean();

    public GridMapQueryExecutor(GridSpinBusyLock busyLock) {
        this.busyLock = busyLock;
    }

    public void start(final GridKernalContext ctx, IgniteH2Indexing h2) throws IgniteCheckedException {
        this.ctx = ctx;
        this.h2 = h2;
        this.log = ctx.log(GridMapQueryExecutor.class);
        final UUID locNodeId = ctx.localNodeId();
        ctx.event().addLocalEventListener(new GridLocalEventListener(){

            public void onEvent(Event evt) {
                UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
                GridH2QueryContext.clearAfterDeadNode(locNodeId, nodeId);
                MapNodeResults nodeRess = (MapNodeResults)GridMapQueryExecutor.this.qryRess.remove(nodeId);
                if (nodeRess == null) {
                    return;
                }
                nodeRess.cancelAll();
            }
        }, 12, new int[]{11});
        ctx.io().addMessageListener(GridTopic.TOPIC_QUERY, new GridMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(UUID nodeId, Object msg, byte plc) {
                if (!GridMapQueryExecutor.this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    if (msg instanceof GridCacheQueryMarshallable) {
                        ((GridCacheQueryMarshallable)msg).unmarshall(ctx.config().getMarshaller(), ctx);
                    }
                    GridMapQueryExecutor.this.onMessage(nodeId, msg);
                }
                finally {
                    GridMapQueryExecutor.this.busyLock.leaveBusy();
                }
            }
        });
    }

    public void cancelLazyWorkers() {
        if (!this.lazyWorkerStopGuard.compareAndSet(false, true)) {
            return;
        }
        this.lazyWorkerBusyLock.block();
        for (MapQueryLazyWorker worker : this.lazyWorkers.values()) {
            worker.stop(false);
        }
        this.lazyWorkers.clear();
    }

    public void onMessage(UUID nodeId, Object msg) {
        try {
            assert (msg != null);
            ClusterNode node = this.ctx.discovery().node(nodeId);
            if (node == null) {
                return;
            }
            boolean processed = true;
            if (msg instanceof GridH2QueryRequest) {
                this.onQueryRequest(node, (GridH2QueryRequest)msg);
            } else if (msg instanceof GridQueryNextPageRequest) {
                this.onNextPageRequest(node, (GridQueryNextPageRequest)msg);
            } else if (msg instanceof GridQueryCancelRequest) {
                this.onCancel(node, (GridQueryCancelRequest)msg);
            } else if (msg instanceof GridH2DmlRequest) {
                this.onDmlRequest(node, (GridH2DmlRequest)msg);
            } else {
                processed = false;
            }
            if (processed && this.log.isDebugEnabled()) {
                this.log.debug("Processed request: " + nodeId + "->" + this.ctx.localNodeId() + " " + msg);
            }
        }
        catch (Throwable th) {
            U.error((IgniteLogger)this.log, (Object)("Failed to process message: " + msg), (Throwable)th);
        }
    }

    GridSpinBusyLock busyLock() {
        return this.busyLock;
    }

    private void onCancel(ClusterNode node, GridQueryCancelRequest msg) {
        long qryReqId = msg.queryRequestId();
        MapNodeResults nodeRess = this.resultsForNode(node.id());
        boolean clear = GridH2QueryContext.clear(this.ctx.localNodeId(), node.id(), qryReqId, GridH2QueryType.MAP);
        if (!clear) {
            nodeRess.onCancel(qryReqId);
            GridH2QueryContext.clear(this.ctx.localNodeId(), node.id(), qryReqId, GridH2QueryType.MAP);
        }
        nodeRess.cancelRequest(qryReqId);
    }

    private MapNodeResults resultsForNode(UUID nodeId) {
        MapNodeResults old;
        MapNodeResults nodeRess = (MapNodeResults)this.qryRess.get(nodeId);
        if (nodeRess == null && (old = this.qryRess.putIfAbsent(nodeId, nodeRess = new MapNodeResults(nodeId))) != null) {
            nodeRess = old;
        }
        return nodeRess;
    }

    private void onQueryRequest(final ClusterNode node, final GridH2QueryRequest req) throws IgniteCheckedException {
        CompoundLockFuture lockFut;
        AtomicInteger runCntr;
        GridNearTxLocal tx;
        int[] qryParts = req.queryPartitions();
        final Map<UUID, int[]> partsMap = req.partitions();
        final int[] parts = qryParts == null ? (Object)(partsMap == null ? null : partsMap.get(this.ctx.localNodeId())) : qryParts;
        final DistributedJoinMode joinMode = DistributedJoinMode.distributedJoinMode(req.isFlagSet(4), req.isFlagSet(1));
        final boolean enforceJoinOrder = req.isFlagSet(2);
        boolean explain = req.isFlagSet(8);
        boolean replicated = req.isFlagSet(16);
        boolean lazy = FORCE_LAZY && req.queries().size() == 1 || req.isFlagSet(32);
        final List<Integer> cacheIds = req.caches();
        int segments = explain || replicated || F.isEmpty(cacheIds) ? 1 : CU.firstPartitioned((GridCacheSharedContext)this.ctx.cache().context(), cacheIds).config().getQueryParallelism();
        final Object[] params = req.parameters();
        GridH2SelectForUpdateTxDetails txReq = req.txDetails();
        try {
            if (txReq != null) {
                GridCacheContext mainCctx = this.mainCacheContext(cacheIds);
                if (mainCctx == null || mainCctx.atomic() || !mainCctx.mvccEnabled() || cacheIds.size() != 1) {
                    throw new IgniteSQLException("SELECT FOR UPDATE is supported only for queries that involve single transactional cache.");
                }
                GridDhtTransactionalCacheAdapter txCache = (GridDhtTransactionalCacheAdapter)mainCctx.cache();
                if (!node.isLocal()) {
                    tx = txCache.initTxTopologyVersion(node.id(), node, txReq.version(), txReq.futureId(), txReq.miniId(), txReq.firstClientRequest(), req.topologyVersion(), txReq.threadId(), txReq.timeout(), txReq.subjectId(), txReq.taskNameHash(), req.mvccSnapshot());
                } else {
                    tx = MvccUtils.tx((GridKernalContext)this.ctx, (GridCacheVersion)txReq.version());
                    assert (tx != null);
                }
            } else {
                tx = null;
            }
        }
        catch (IgniteCheckedException | IgniteException e) {
            this.releaseReservations();
            U.error((IgniteLogger)this.log, (Object)"Failed to execute local query.", (Throwable)e);
            this.sendError(node, req.requestId(), e);
            return;
        }
        if (txReq != null && segments > 1) {
            runCntr = new AtomicInteger(segments);
            lockFut = new CompoundLockFuture(segments, tx);
            lockFut.init();
        } else {
            runCntr = null;
            lockFut = null;
        }
        for (int i = 1; i < segments; ++i) {
            assert (!F.isEmpty(cacheIds));
            final int segment = i;
            if (lazy) {
                this.onQueryRequest0(node, req.requestId(), segment, req.schemaName(), req.queries(), cacheIds, req.topologyVersion(), partsMap, parts, req.pageSize(), joinMode, enforceJoinOrder, false, req.timeout(), params, true, req.mvccSnapshot(), (GridDhtTxLocalAdapter)tx, txReq, lockFut, runCntr);
                continue;
            }
            this.ctx.closure().callLocal((Callable)new Callable<Void>((GridDhtTxLocalAdapter)tx, txReq, lockFut, runCntr){
                final /* synthetic */ GridDhtTxLocalAdapter val$tx;
                final /* synthetic */ GridH2SelectForUpdateTxDetails val$txReq;
                final /* synthetic */ CompoundLockFuture val$lockFut;
                final /* synthetic */ AtomicInteger val$runCntr;
                {
                    this.val$tx = gridDhtTxLocalAdapter;
                    this.val$txReq = gridH2SelectForUpdateTxDetails;
                    this.val$lockFut = compoundLockFuture;
                    this.val$runCntr = atomicInteger;
                }

                @Override
                public Void call() {
                    GridMapQueryExecutor.this.onQueryRequest0(node, req.requestId(), segment, req.schemaName(), req.queries(), cacheIds, req.topologyVersion(), partsMap, parts, req.pageSize(), joinMode, enforceJoinOrder, false, req.timeout(), params, false, req.mvccSnapshot(), this.val$tx, this.val$txReq, this.val$lockFut, this.val$runCntr);
                    return null;
                }
            }, (byte)10);
        }
        this.onQueryRequest0(node, req.requestId(), 0, req.schemaName(), req.queries(), cacheIds, req.topologyVersion(), partsMap, parts, req.pageSize(), joinMode, enforceJoinOrder, replicated, req.timeout(), params, lazy, req.mvccSnapshot(), (GridDhtTxLocalAdapter)tx, txReq, lockFut, runCntr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onQueryRequest0(final ClusterNode node, final long reqId, final int segmentId, final String schemaName, final Collection<GridCacheSqlQuery> qrys, final List<Integer> cacheIds, final AffinityTopologyVersion topVer, final Map<UUID, int[]> partsMap, final int[] parts, final int pageSize, final DistributedJoinMode distributedJoinMode, final boolean enforceJoinOrder, final boolean replicated, final int timeout, final Object[] params, boolean lazy, final @Nullable MvccSnapshot mvccSnapshot, final @Nullable GridDhtTxLocalAdapter tx, final @Nullable GridH2SelectForUpdateTxDetails txDetails, final @Nullable CompoundLockFuture lockFut, final @Nullable AtomicInteger runCntr) {
        boolean inTx;
        MapQueryLazyWorker worker = MapQueryLazyWorker.currentWorker();
        assert (tx == null || txDetails != null);
        boolean bl = inTx = tx != null;
        if (lazy && worker == null) {
            MapQueryLazyWorkerKey key = new MapQueryLazyWorkerKey(node.id(), reqId, segmentId);
            worker = new MapQueryLazyWorker(this.ctx.igniteInstanceName(), key, this.log, this);
            worker.submit(new Runnable(){

                @Override
                public void run() {
                    GridMapQueryExecutor.this.onQueryRequest0(node, reqId, segmentId, schemaName, qrys, cacheIds, topVer, partsMap, parts, pageSize, distributedJoinMode, enforceJoinOrder, replicated, timeout, params, true, mvccSnapshot, tx, txDetails, lockFut, runCntr);
                }
            });
            if (this.lazyWorkerBusyLock.enterBusy()) {
                try {
                    MapQueryLazyWorker oldWorker = this.lazyWorkers.put(key, worker);
                    if (oldWorker != null) {
                        oldWorker.stop(false);
                    }
                    IgniteThread thread = new IgniteThread((GridWorker)worker);
                    thread.start();
                }
                finally {
                    this.lazyWorkerBusyLock.leaveBusy();
                }
            } else {
                this.log.info("Ignored query request (node is stopping) [nodeId=" + node.id() + ", reqId=" + reqId + ']');
            }
            return;
        }
        if (lazy && txDetails != null) {
            throw new IgniteSQLException("Lazy execution of SELECT FOR UPDATE queries is not supported.");
        }
        GridCacheContext mainCctx = this.mainCacheContext(cacheIds);
        MapNodeResults nodeRess = this.resultsForNode(node.id());
        MapQueryResults qr = null;
        PartitionReservation reserved = null;
        try {
            if (topVer != null && txDetails == null && (reserved = this.h2.partitionReservationManager().reservePartitions(cacheIds, topVer, parts, node.id(), reqId)).failed()) {
                if (lazy) {
                    this.stopAndUnregisterCurrentLazyWorker();
                }
                this.sendRetry(node, reqId, segmentId, reserved.error());
                return;
            }
            qr = new MapQueryResults(this.h2, reqId, qrys.size(), mainCctx, MapQueryLazyWorker.currentWorker(), inTx);
            if (nodeRess.put(reqId, segmentId, qr) != null) {
                throw new IllegalStateException();
            }
            GridH2QueryContext qctx = new GridH2QueryContext(this.ctx.localNodeId(), node.id(), reqId, segmentId, replicated ? GridH2QueryType.REPLICATED : GridH2QueryType.MAP).filter(this.h2.backupFilter(topVer, parts)).partitionsMap(partsMap).distributedJoinMode(distributedJoinMode).pageSize(pageSize).topologyVersion(topVer).reservations(reserved).mvccSnapshot(mvccSnapshot).lazyWorker(worker);
            Connection conn = this.h2.connections().connectionForThread().connection(schemaName);
            H2Utils.setupConnection(conn, distributedJoinMode != DistributedJoinMode.OFF, enforceJoinOrder);
            GridH2QueryContext.set(qctx);
            reserved = null;
            try {
                if (nodeRess.cancelled(reqId)) {
                    GridH2QueryContext.clear(this.ctx.localNodeId(), node.id(), reqId, qctx.type());
                    nodeRess.cancelRequest(reqId);
                    throw new QueryCancelledException();
                }
                int qryIdx = 0;
                boolean evt = mainCctx != null && mainCctx.events().isRecordable(96);
                for (GridCacheSqlQuery qry : qrys) {
                    ResultSet rs = null;
                    boolean removeMapping = false;
                    if (qry.node() == null || segmentId == 0 && qry.node().equals(this.ctx.localNodeId())) {
                        PreparedStatement stmt;
                        String sql = qry.query();
                        List params0 = F.asList((Object[])qry.parameters(params));
                        try {
                            stmt = this.h2.prepareStatement(conn, sql, true);
                        }
                        catch (SQLException e) {
                            throw new IgniteCheckedException("Failed to parse SQL query: " + sql, (Throwable)e);
                        }
                        Prepared p = GridSqlQueryParser.prepared(stmt);
                        if (GridSqlQueryParser.isForUpdateQuery(p)) {
                            sql = GridSqlQueryParser.rewriteQueryForUpdateIfNeeded(p, inTx);
                            stmt = this.h2.prepareStatement(conn, sql, true);
                        }
                        this.h2.bindParameters(stmt, params0);
                        int opTimeout = IgniteH2Indexing.operationTimeout(timeout, (IgniteTxAdapter)tx);
                        rs = this.h2.executeSqlQueryWithTimer(stmt, conn, sql, params0, opTimeout, qr.queryCancel(qryIdx));
                        if (inTx) {
                            ResultSetEnlistFuture enlistFut = ResultSetEnlistFuture.future(this.ctx.localNodeId(), txDetails.version(), mvccSnapshot, txDetails.threadId(), IgniteUuid.randomUuid(), txDetails.miniId(), parts, tx, opTimeout, mainCctx, rs);
                            if (lockFut != null) {
                                lockFut.register((IgniteInternalFuture)enlistFut);
                            }
                            enlistFut.init();
                            enlistFut.get();
                            rs.beforeFirst();
                        }
                        if (evt) {
                            this.ctx.event().record((Event)new CacheQueryExecutedEvent(node, "SQL query executed.", 96, CacheQueryType.SQL.name(), mainCctx.name(), null, qry.query(), null, null, params, node.id(), null));
                        }
                        assert (rs instanceof JdbcResultSet) : rs.getClass();
                    }
                    qr.addResult(qryIdx, qry, node.id(), rs, params);
                    if (qr.cancelled()) {
                        qr.result(qryIdx).close();
                        throw new QueryCancelledException();
                    }
                    if (inTx && tx.dht() && (runCntr == null || runCntr.decrementAndGet() == 0) && (removeMapping = tx.empty() && !tx.queryEnlisted())) {
                        this.ctx.cache().context().tm().forgetTx((IgniteInternalTx)tx);
                    }
                    if (lockFut == null) {
                        this.sendNextPage(nodeRess, node, qr, qryIdx, segmentId, pageSize, removeMapping);
                    } else {
                        final GridQueryNextPageResponse msg = this.prepareNextPage(nodeRess, node, qr, qryIdx, segmentId, pageSize, removeMapping);
                        if (msg != null) {
                            lockFut.listen((IgniteInClosure)new IgniteInClosure<IgniteInternalFuture<Void>>(){

                                public void apply(IgniteInternalFuture<Void> future) {
                                    try {
                                        if (node.isLocal()) {
                                            GridMapQueryExecutor.this.h2.reduceQueryExecutor().onMessage(GridMapQueryExecutor.this.ctx.localNodeId(), msg);
                                        } else {
                                            GridMapQueryExecutor.this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)10);
                                        }
                                    }
                                    catch (Exception e) {
                                        U.error((IgniteLogger)GridMapQueryExecutor.this.log, (Object)e);
                                    }
                                }
                            });
                        }
                    }
                    ++qryIdx;
                }
                if (!lazy) {
                    this.releaseReservations();
                }
            }
            catch (Throwable e) {
                this.releaseReservations();
                throw e;
            }
        }
        catch (Throwable e) {
            GridH2RetryException retryErr;
            if (qr != null) {
                nodeRess.remove(reqId, segmentId, qr);
                qr.cancel(false);
            }
            if (lazy) {
                this.stopAndUnregisterCurrentLazyWorker();
            }
            if ((retryErr = (GridH2RetryException)((Object)X.cause((Throwable)e, GridH2RetryException.class))) != null) {
                String retryCause = String.format("Failed to execute non-collocated query (will retry) [localNodeId=%s, rmtNodeId=%s, reqId=%s, errMsg=%s]", this.ctx.localNodeId(), node.id(), reqId, retryErr.getMessage());
                this.sendRetry(node, reqId, segmentId, retryCause);
            } else {
                U.error((IgniteLogger)this.log, (Object)"Failed to execute local query.", (Throwable)e);
                this.sendError(node, reqId, e);
                if (e instanceof Error) {
                    throw (Error)e;
                }
            }
        }
        finally {
            if (reserved != null) {
                reserved.release();
            }
        }
    }

    private GridCacheContext mainCacheContext(List<Integer> cacheIds) {
        return !F.isEmpty(cacheIds) ? this.ctx.cache().context().cacheContext(cacheIds.get(0).intValue()) : null;
    }

    private void releaseReservations() {
        GridH2QueryContext qctx = GridH2QueryContext.get();
        if (qctx != null) {
            GridH2QueryContext.clearThreadLocal();
            if (qctx.distributedJoinMode() == DistributedJoinMode.OFF) {
                qctx.clearContext(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDmlRequest(ClusterNode node, GridH2DmlRequest req) throws IgniteCheckedException {
        int[] parts = req.queryPartitions();
        List<Integer> cacheIds = req.caches();
        long reqId = req.requestId();
        AffinityTopologyVersion topVer = req.topologyVersion();
        PartitionReservation reserved = null;
        MapNodeResults nodeResults = this.resultsForNode(node.id());
        try {
            boolean evt;
            reserved = this.h2.partitionReservationManager().reservePartitions(cacheIds, topVer, parts, node.id(), reqId);
            if (reserved.failed()) {
                U.error((IgniteLogger)this.log, (Object)("Failed to reserve partitions for DML request. [localNodeId=" + this.ctx.localNodeId() + ", nodeId=" + node.id() + ", reqId=" + req.requestId() + ", cacheIds=" + cacheIds + ", topVer=" + topVer + ", parts=" + Arrays.toString(parts) + ']'));
                this.sendUpdateResponse(node, reqId, null, "Failed to reserve partitions for DML request. " + reserved.error());
                return;
            }
            IndexingQueryFilter filter = this.h2.backupFilter(topVer, parts);
            GridQueryCancel cancel = nodeResults.putUpdate(reqId);
            SqlFieldsQuery fldsQry = new SqlFieldsQuery(req.query());
            if (req.parameters() != null) {
                fldsQry.setArgs(req.parameters());
            }
            fldsQry.setEnforceJoinOrder(req.isFlagSet(2));
            fldsQry.setTimeout(req.timeout(), TimeUnit.MILLISECONDS);
            fldsQry.setPageSize(req.pageSize());
            fldsQry.setLocal(true);
            boolean local = true;
            boolean replicated = req.isFlagSet(16);
            if (!replicated && !F.isEmpty(cacheIds) && CU.firstPartitioned((GridCacheSharedContext)this.ctx.cache().context(), cacheIds).config().getQueryParallelism() > 1) {
                fldsQry.setDistributedJoins(true);
                local = false;
            }
            UpdateResult updRes = this.h2.mapDistributedUpdate(req.schemaName(), fldsQry, filter, cancel, local);
            GridCacheContext mainCctx = !F.isEmpty(cacheIds) ? this.ctx.cache().context().cacheContext(cacheIds.get(0).intValue()) : null;
            boolean bl = evt = local && mainCctx != null && mainCctx.events().isRecordable(96);
            if (evt) {
                this.ctx.event().record((Event)new CacheQueryExecutedEvent(node, "SQL query executed.", 96, CacheQueryType.SQL.name(), mainCctx.name(), null, req.query(), null, null, req.parameters(), node.id(), null));
            }
            this.sendUpdateResponse(node, reqId, updRes, null);
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)("Error processing dml request. [localNodeId=" + this.ctx.localNodeId() + ", nodeId=" + node.id() + ", req=" + req + ']'), (Throwable)e);
            this.sendUpdateResponse(node, reqId, null, e.getMessage());
        }
        finally {
            if (reserved != null) {
                reserved.release();
            }
            nodeResults.removeUpdate(reqId);
        }
    }

    private void sendError(ClusterNode node, long qryReqId, Throwable err) {
        try {
            GridQueryFailResponse msg = new GridQueryFailResponse(qryReqId, err);
            if (node.isLocal()) {
                U.error((IgniteLogger)this.log, (Object)"Failed to run map query on local node.", (Throwable)err);
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)10);
            }
        }
        catch (Exception e) {
            e.addSuppressed(err);
            U.error((IgniteLogger)this.log, (Object)"Failed to send error message.", (Throwable)e);
        }
    }

    private void sendUpdateResponse(ClusterNode node, long reqId, UpdateResult updResult, String error) {
        try {
            GridH2DmlResponse rsp = new GridH2DmlResponse(reqId, updResult == null ? 0L : updResult.counter(), updResult == null ? null : updResult.errorKeys(), error);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending: [localNodeId=" + this.ctx.localNodeId() + ", node=" + node.id() + ", msg=" + rsp + "]");
            }
            if (node.isLocal()) {
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), rsp);
            } else {
                rsp.marshall(this.ctx.config().getMarshaller());
                this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)rsp, (byte)10);
            }
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send message.", (Throwable)e);
        }
    }

    private void onNextPageRequest(final ClusterNode node, final GridQueryNextPageRequest req) {
        final MapNodeResults nodeRess = (MapNodeResults)this.qryRess.get(node.id());
        if (nodeRess == null) {
            this.sendError(node, req.queryRequestId(), (Throwable)new CacheException("No node result found for request: " + req));
            return;
        }
        if (nodeRess.cancelled(req.queryRequestId())) {
            this.sendError(node, req.queryRequestId(), (Throwable)new QueryCancelledException());
            return;
        }
        final MapQueryResults qr = nodeRess.get(req.queryRequestId(), req.segmentId());
        if (qr == null) {
            this.sendError(node, req.queryRequestId(), (Throwable)new CacheException("No query result found for request: " + req));
        } else if (qr.cancelled()) {
            this.sendError(node, req.queryRequestId(), (Throwable)new QueryCancelledException());
        } else {
            MapQueryLazyWorker lazyWorker = qr.lazyWorker();
            if (lazyWorker != null) {
                lazyWorker.submit(new Runnable(){

                    @Override
                    public void run() {
                        GridMapQueryExecutor.this.sendNextPage(nodeRess, node, qr, req.query(), req.segmentId(), req.pageSize(), false);
                    }
                });
            } else {
                this.sendNextPage(nodeRess, node, qr, req.query(), req.segmentId(), req.pageSize(), false);
            }
        }
    }

    private GridQueryNextPageResponse prepareNextPage(MapNodeResults nodeRess, ClusterNode node, MapQueryResults qr, int qry, int segmentId, int pageSize, boolean removeMapping) throws IgniteCheckedException {
        MapQueryResult res = qr.result(qry);
        assert (res != null);
        if (res.closed()) {
            return null;
        }
        int page = res.page();
        ArrayList<Value[]> rows = new ArrayList<Value[]>(Math.min(64, pageSize));
        boolean last = res.fetchNextPage(rows, pageSize);
        if (last) {
            res.close();
            if (qr.isAllClosed()) {
                nodeRess.remove(qr.queryRequestId(), segmentId, qr);
                if (MapQueryLazyWorker.currentWorker() != null) {
                    this.releaseReservations();
                }
            }
        }
        boolean loc = node.isLocal();
        int colsCnt = !qr.isForUpdate() ? res.columnCount() : res.columnCount() - 1;
        GridQueryNextPageResponse msg = new GridQueryNextPageResponse(qr.queryRequestId(), segmentId, qry, page, page == 0 ? res.rowCount() : -1, colsCnt, loc ? null : GridH2ValueMessageFactory.toMessages(rows, new ArrayList<Message>(res.columnCount()), colsCnt), loc ? rows : null, last);
        msg.removeMapping(removeMapping);
        return msg;
    }

    private void sendNextPage(MapNodeResults nodeRess, ClusterNode node, MapQueryResults qr, int qry, int segmentId, int pageSize, boolean removeMapping) {
        try {
            GridQueryNextPageResponse msg = this.prepareNextPage(nodeRess, node, qr, qry, segmentId, pageSize, removeMapping);
            if (msg != null) {
                if (node.isLocal()) {
                    this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
                } else {
                    this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)10);
                }
            }
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send message.", (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
    }

    private void sendRetry(ClusterNode node, long reqId, int segmentId, String retryCause) {
        try {
            boolean loc = node.isLocal();
            GridQueryNextPageResponse msg = new GridQueryNextPageResponse(reqId, segmentId, 0, 0, 0, 1, loc ? null : Collections.emptyList(), loc ? Collections.emptyList() : null, false);
            msg.retry(this.h2.readyTopologyVersion());
            msg.retryCause(retryCause);
            if (loc) {
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)10);
            }
        }
        catch (Exception e) {
            U.warn((IgniteLogger)this.log, (Object)("Failed to send retry message: " + e.getMessage()));
        }
    }

    public void stopAndUnregisterCurrentLazyWorker() {
        MapQueryLazyWorker worker = MapQueryLazyWorker.currentWorker();
        if (worker != null) {
            worker.stop(false);
            this.unregisterLazyWorker(worker);
        }
    }

    public void unregisterLazyWorker(MapQueryLazyWorker worker) {
        this.lazyWorkers.remove(worker.key(), (Object)worker);
    }

    public int registeredLazyWorkers() {
        return this.lazyWorkers.size();
    }
}

