/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewColumnCondition;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class SqlSystemViewCaches
extends SqlAbstractLocalSystemView {
    public SqlSystemViewCaches(GridKernalContext ctx) {
        super("CACHES", "Ignite caches", ctx, "NAME", SqlSystemViewCaches.newColumn("NAME"), SqlSystemViewCaches.newColumn("CACHE_ID", 4), SqlSystemViewCaches.newColumn("CACHE_TYPE"), SqlSystemViewCaches.newColumn("GROUP_ID", 4), SqlSystemViewCaches.newColumn("GROUP_NAME"), SqlSystemViewCaches.newColumn("CACHE_MODE"), SqlSystemViewCaches.newColumn("ATOMICITY_MODE"), SqlSystemViewCaches.newColumn("IS_ONHEAP_CACHE_ENABLED", 1), SqlSystemViewCaches.newColumn("IS_COPY_ON_READ", 1), SqlSystemViewCaches.newColumn("IS_LOAD_PREVIOUS_VALUE", 1), SqlSystemViewCaches.newColumn("IS_READ_FROM_BACKUP", 1), SqlSystemViewCaches.newColumn("PARTITION_LOSS_POLICY"), SqlSystemViewCaches.newColumn("NODE_FILTER"), SqlSystemViewCaches.newColumn("TOPOLOGY_VALIDATOR"), SqlSystemViewCaches.newColumn("IS_EAGER_TTL", 1), SqlSystemViewCaches.newColumn("WRITE_SYNCHRONIZATION_MODE"), SqlSystemViewCaches.newColumn("IS_INVALIDATE", 1), SqlSystemViewCaches.newColumn("IS_EVENTS_DISABLED", 1), SqlSystemViewCaches.newColumn("IS_STATISTICS_ENABLED", 1), SqlSystemViewCaches.newColumn("IS_MANAGEMENT_ENABLED", 1), SqlSystemViewCaches.newColumn("BACKUPS", 4), SqlSystemViewCaches.newColumn("AFFINITY"), SqlSystemViewCaches.newColumn("AFFINITY_MAPPER"), SqlSystemViewCaches.newColumn("REBALANCE_MODE"), SqlSystemViewCaches.newColumn("REBALANCE_BATCH_SIZE", 4), SqlSystemViewCaches.newColumn("REBALANCE_TIMEOUT", 5), SqlSystemViewCaches.newColumn("REBALANCE_DELAY", 5), SqlSystemViewCaches.newColumn("REBALANCE_THROTTLE", 5), SqlSystemViewCaches.newColumn("REBALANCE_BATCHES_PREFETCH_COUNT", 5), SqlSystemViewCaches.newColumn("REBALANCE_ORDER", 4), SqlSystemViewCaches.newColumn("EVICTION_FILTER"), SqlSystemViewCaches.newColumn("EVICTION_POLICY_FACTORY"), SqlSystemViewCaches.newColumn("IS_NEAR_CACHE_ENABLED", 1), SqlSystemViewCaches.newColumn("NEAR_CACHE_EVICTION_POLICY_FACTORY"), SqlSystemViewCaches.newColumn("NEAR_CACHE_START_SIZE", 4), SqlSystemViewCaches.newColumn("DEFAULT_LOCK_TIMEOUT", 5), SqlSystemViewCaches.newColumn("CACHE_INTERCEPTOR"), SqlSystemViewCaches.newColumn("CACHE_STORE_FACTORY"), SqlSystemViewCaches.newColumn("IS_STORE_KEEP_BINARY", 1), SqlSystemViewCaches.newColumn("IS_READ_THROUGH", 1), SqlSystemViewCaches.newColumn("IS_WRITE_THROUGH", 1), SqlSystemViewCaches.newColumn("IS_WRITE_BEHIND_ENABLED", 1), SqlSystemViewCaches.newColumn("WRITE_BEHIND_COALESCING", 1), SqlSystemViewCaches.newColumn("WRITE_BEHIND_FLUSH_SIZE", 4), SqlSystemViewCaches.newColumn("WRITE_BEHIND_FLUSH_FREQUENCY", 5), SqlSystemViewCaches.newColumn("WRITE_BEHIND_FLUSH_THREAD_COUNT", 4), SqlSystemViewCaches.newColumn("WRITE_BEHIND_FLUSH_BATCH_SIZE", 4), SqlSystemViewCaches.newColumn("MAX_CONCURRENT_ASYNC_OPERATIONS", 4), SqlSystemViewCaches.newColumn("CACHE_LOADER_FACTORY"), SqlSystemViewCaches.newColumn("CACHE_WRITER_FACTORY"), SqlSystemViewCaches.newColumn("EXPIRY_POLICY_FACTORY"), SqlSystemViewCaches.newColumn("IS_SQL_ESCAPE_ALL", 1), SqlSystemViewCaches.newColumn("SQL_SCHEMA"), SqlSystemViewCaches.newColumn("SQL_INDEX_MAX_INLINE_SIZE", 4), SqlSystemViewCaches.newColumn("IS_SQL_ONHEAP_CACHE_ENABLED", 1), SqlSystemViewCaches.newColumn("SQL_ONHEAP_CACHE_MAX_SIZE", 4), SqlSystemViewCaches.newColumn("QUERY_DETAILS_METRICS_SIZE", 4), SqlSystemViewCaches.newColumn("QUERY_PARALLELISM", 4), SqlSystemViewCaches.newColumn("MAX_QUERY_ITERATORS_COUNT", 4), SqlSystemViewCaches.newColumn("DATA_REGION_NAME"));
    }

    @Override
    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last) {
        DynamicCacheDescriptor cache2;
        SqlSystemViewColumnCondition nameCond = this.conditionForColumn("NAME", first, last);
        Collection<Object> caches = nameCond.isEquality() ? ((cache2 = this.ctx.cache().cacheDescriptor(nameCond.valueForEquality().getString())) == null ? Collections.emptySet() : Collections.singleton(cache2)) : this.ctx.cache().cacheDescriptors().values();
        AtomicLong rowKey = new AtomicLong();
        return F.iterator(caches, (IgniteClosure & Serializable)cache -> this.createRow(ses, rowKey.incrementAndGet(), cache.cacheName(), cache.cacheId(), cache.cacheType(), cache.groupId(), cache.groupDescriptor().groupName(), cache.cacheConfiguration().getCacheMode(), cache.cacheConfiguration().getAtomicityMode(), cache.cacheConfiguration().isOnheapCacheEnabled(), cache.cacheConfiguration().isCopyOnRead(), cache.cacheConfiguration().isLoadPreviousValue(), cache.cacheConfiguration().isReadFromBackup(), cache.cacheConfiguration().getPartitionLossPolicy(), cache.cacheConfiguration().getNodeFilter(), cache.cacheConfiguration().getTopologyValidator(), cache.cacheConfiguration().isEagerTtl(), cache.cacheConfiguration().getWriteSynchronizationMode(), cache.cacheConfiguration().isInvalidate(), cache.cacheConfiguration().isEventsDisabled(), cache.cacheConfiguration().isStatisticsEnabled(), cache.cacheConfiguration().isManagementEnabled(), cache.cacheConfiguration().getBackups(), cache.cacheConfiguration().getAffinity(), cache.cacheConfiguration().getAffinityMapper(), cache.cacheConfiguration().getRebalanceMode(), cache.cacheConfiguration().getRebalanceBatchSize(), cache.cacheConfiguration().getRebalanceTimeout(), cache.cacheConfiguration().getRebalanceDelay(), cache.cacheConfiguration().getRebalanceThrottle(), cache.cacheConfiguration().getRebalanceBatchesPrefetchCount(), cache.cacheConfiguration().getRebalanceOrder(), cache.cacheConfiguration().getEvictionFilter(), cache.cacheConfiguration().getEvictionPolicyFactory(), cache.cacheConfiguration().getNearConfiguration() != null, cache.cacheConfiguration().getNearConfiguration() != null ? cache.cacheConfiguration().getNearConfiguration().getNearEvictionPolicyFactory() : null, cache.cacheConfiguration().getNearConfiguration() != null ? Integer.valueOf(cache.cacheConfiguration().getNearConfiguration().getNearStartSize()) : null, cache.cacheConfiguration().getDefaultLockTimeout(), cache.cacheConfiguration().getInterceptor(), cache.cacheConfiguration().getCacheStoreFactory(), cache.cacheConfiguration().isStoreKeepBinary(), cache.cacheConfiguration().isReadThrough(), cache.cacheConfiguration().isWriteThrough(), cache.cacheConfiguration().isWriteBehindEnabled(), cache.cacheConfiguration().getWriteBehindCoalescing(), cache.cacheConfiguration().getWriteBehindFlushSize(), cache.cacheConfiguration().getWriteBehindFlushFrequency(), cache.cacheConfiguration().getWriteBehindFlushThreadCount(), cache.cacheConfiguration().getWriteBehindBatchSize(), cache.cacheConfiguration().getMaxConcurrentAsyncOperations(), cache.cacheConfiguration().getCacheLoaderFactory(), cache.cacheConfiguration().getCacheWriterFactory(), cache.cacheConfiguration().getExpiryPolicyFactory(), cache.cacheConfiguration().isSqlEscapeAll(), cache.cacheConfiguration().getSqlSchema(), cache.cacheConfiguration().getSqlIndexMaxInlineSize(), cache.cacheConfiguration().isSqlOnheapCacheEnabled(), cache.cacheConfiguration().getSqlOnheapCacheMaxSize(), cache.cacheConfiguration().getQueryDetailMetricsSize(), cache.cacheConfiguration().getQueryParallelism(), cache.cacheConfiguration().getMaxQueryIteratorsCount(), cache.cacheConfiguration().getDataRegionName()), (boolean)true, (IgnitePredicate[])new IgnitePredicate[0]);
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount() {
        return this.ctx.cache().cacheDescriptors().size();
    }
}

