/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.query.QueryTable;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.h2.IndexRebuildPartialClosure;
import org.apache.ignite.internal.processors.query.h2.database.H2RowFactory;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2KeyValueRowOnheap;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2PrimaryScanIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ProxyIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ProxySpatialIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2SystemIndexFactory;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMapQueryExecutor;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.dml.Insert;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.SpatialIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.table.TableType;
import org.h2.value.DataType;
import org.jetbrains.annotations.Nullable;

public class GridH2Table
extends TableBase {
    private static final ThreadLocal<Boolean> INSERT_HACK = new ThreadLocal();
    private static final AtomicIntegerFieldUpdater<GridH2Table> rebuildFromHashInProgressFiledUpdater = AtomicIntegerFieldUpdater.newUpdater(GridH2Table.class, "rebuildFromHashInProgress");
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private final GridCacheContext cctx;
    private final GridH2RowDescriptor desc;
    private volatile ArrayList<Index> idxs;
    private final int pkIndexPos;
    private final int sysIdxsCnt;
    private final Map<String, GridH2IndexBase> tmpIdxs = new HashMap<String, GridH2IndexBase>();
    private final ReentrantReadWriteLock lock;
    private boolean destroyed;
    private final ConcurrentMap<Session, Boolean> sessions = new ConcurrentHashMap<Session, Boolean>();
    private IndexColumn affKeyCol;
    private final LongAdder size = new LongAdder();
    private final H2RowFactory rowFactory;
    private volatile int rebuildFromHashInProgress = 0;
    private final QueryTable identifier;
    private final String identifierStr;
    private volatile boolean rmIndex;

    public GridH2Table(CreateTableData createTblData, GridH2RowDescriptor desc, H2RowFactory rowFactory, GridH2SystemIndexFactory idxsFactory, GridCacheContext cctx) {
        super(createTblData);
        boolean hasHashIndex;
        assert (idxsFactory != null);
        this.desc = desc;
        this.cctx = cctx;
        if (desc.context() != null && !desc.context().customAffinityMapper()) {
            boolean affinityColExists = true;
            String affKey = desc.type().affinityKey();
            int affKeyColId = -1;
            if (affKey != null) {
                if (this.doesColumnExist(affKey)) {
                    affKeyColId = this.getColumn(affKey).getColumnId();
                    if (desc.isKeyColumn(affKeyColId)) {
                        affKeyColId = 0;
                    }
                } else {
                    affinityColExists = false;
                }
            } else {
                affKeyColId = 0;
            }
            if (affinityColExists) {
                this.affKeyCol = this.indexColumn(affKeyColId, 0);
                assert (this.affKeyCol != null);
            }
        }
        this.rowFactory = rowFactory;
        this.identifier = new QueryTable(this.getSchema().getName(), this.getName());
        this.identifierStr = this.identifier.schema() + "." + this.identifier.table();
        this.idxs = idxsFactory.createSystemIndexes(this);
        assert (this.idxs != null);
        ArrayList<Index> clones = new ArrayList<Index>(this.idxs.size());
        for (Index index : this.idxs) {
            Index clone = this.createDuplicateIndexIfNeeded(index);
            if (clone == null) continue;
            clones.add(clone);
        }
        this.idxs.addAll(clones);
        boolean bl = hasHashIndex = this.idxs.size() >= 2 && this.index(0).getIndexType().isHash();
        if (hasHashIndex) {
            this.idxs.add(0, (Index)new GridH2PrimaryScanIndex(this, this.index(1), this.index(0)));
        } else {
            this.idxs.add(0, (Index)new GridH2PrimaryScanIndex(this, this.index(0), null));
        }
        this.pkIndexPos = hasHashIndex ? 2 : 1;
        this.sysIdxsCnt = this.idxs.size();
        this.lock = new ReentrantReadWriteLock();
    }

    public boolean isPartitioned() {
        return this.desc != null && this.desc.context().config().getCacheMode() == CacheMode.PARTITIONED;
    }

    @Nullable
    public IndexColumn getAffinityKeyColumn() {
        return this.affKeyCol;
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public GridH2RowDescriptor rowDescriptor() {
        return this.desc;
    }

    public String cacheName() {
        return this.cctx.name();
    }

    public int cacheId() {
        return this.cctx.cacheId();
    }

    public GridCacheContext cache() {
        return this.cctx;
    }

    public boolean lock(Session ses, boolean exclusive, boolean force) {
        Boolean res = (Boolean)this.sessions.get(ses);
        if (res != null) {
            return res;
        }
        this.lock(exclusive);
        if (this.destroyed) {
            this.unlock(exclusive);
            throw new IllegalStateException("Table " + this.identifierString() + " already destroyed.");
        }
        this.sessions.put(ses, exclusive);
        ses.addLock((Table)this);
        return false;
    }

    public QueryTable identifier() {
        return this.identifier;
    }

    public String identifierString() {
        return this.identifierStr;
    }

    private void lock(boolean exclusive) {
        Lock l = exclusive ? this.lock.writeLock() : this.lock.readLock();
        try {
            if (!exclusive || !GridMapQueryExecutor.FORCE_LAZY) {
                l.lockInterruptibly();
            } else {
                while (!l.tryLock(200L, TimeUnit.MILLISECONDS)) {
                    Thread.yield();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedException("Thread got interrupted while trying to acquire table lock.", e);
        }
    }

    private void unlock(boolean exclusive) {
        Lock l = exclusive ? this.lock.writeLock() : this.lock.readLock();
        l.unlock();
    }

    private void ensureNotDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("Table " + this.identifierString() + " already destroyed.");
        }
    }

    public void close(Session ses) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildrenAndResources(Session ses) {
        this.lock(true);
        try {
            super.removeChildrenAndResources(ses);
            while (this.idxs.size() > this.sysIdxsCnt) {
                Index idx = this.idxs.get(this.sysIdxsCnt);
                if (idx.getName() == null || idx.getSchema().findIndex(ses, idx.getName()) != idx) continue;
                this.database.removeSchemaObject(ses, (SchemaObject)idx);
                if (!(idx instanceof GridH2IndexBase)) continue;
                ((GridH2IndexBase)idx).destroy(this.rmIndex);
            }
            if (SysProperties.CHECK) {
                for (SchemaObject obj : this.database.getAllSchemaObjects(1)) {
                    Index idx = (Index)obj;
                    if (idx.getTable() != this) continue;
                    DbException.throwInternalError((String)("index not dropped: " + idx.getName()));
                }
            }
            this.database.removeMeta(ses, this.getId());
            this.invalidate();
        }
        finally {
            this.unlock(true);
        }
    }

    public void destroy() {
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            assert (this.sessions.isEmpty()) : this.sessions;
            this.destroyed = true;
            int len = this.idxs.size();
            for (int i = 1; i < len; ++i) {
                if (!(this.idxs.get(i) instanceof GridH2IndexBase)) continue;
                this.index(i).destroy(this.rmIndex);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    public void setRemoveIndexOnDestroy(boolean rmIndex) {
        this.rmIndex = rmIndex;
    }

    public void unlock(Session ses) {
        Boolean exclusive = (Boolean)this.sessions.remove(ses);
        if (exclusive == null) {
            return;
        }
        this.unlock(exclusive);
    }

    private GridH2IndexBase index(int idx) {
        return (GridH2IndexBase)this.idxs.get(idx);
    }

    private GridH2IndexBase pk() {
        return (GridH2IndexBase)this.idxs.get(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CacheDataRow row, @Nullable CacheDataRow prevRow, boolean prevRowAvailable) throws IgniteCheckedException {
        assert (this.desc != null);
        GridH2KeyValueRowOnheap row0 = (GridH2KeyValueRowOnheap)this.desc.createRow(row);
        GridH2KeyValueRowOnheap prevRow0 = prevRow != null ? (GridH2KeyValueRowOnheap)this.desc.createRow(prevRow) : null;
        row0.prepareValuesCache();
        if (prevRow0 != null) {
            prevRow0.prepareValuesCache();
        }
        try {
            this.lock(false);
            try {
                boolean replaced;
                this.ensureNotDestroyed();
                if (prevRowAvailable && this.rebuildFromHashInProgress == 0) {
                    replaced = this.pk().putx(row0);
                } else {
                    prevRow0 = (GridH2KeyValueRowOnheap)this.pk().put(row0);
                    boolean bl = replaced = prevRow0 != null;
                }
                if (!replaced) {
                    this.size.increment();
                }
                int len = this.idxs.size();
                for (int i = this.pkIndexPos + 1; i < len; ++i) {
                    Index idx = this.idxs.get(i);
                    if (!(idx instanceof GridH2IndexBase)) continue;
                    this.addToIndex((GridH2IndexBase)idx, row0, prevRow0);
                }
                if (!this.tmpIdxs.isEmpty()) {
                    for (GridH2IndexBase idx : this.tmpIdxs.values()) {
                        this.addToIndex(idx, row0, prevRow0);
                    }
                }
            }
            finally {
                this.unlock(false);
            }
        }
        finally {
            row0.clearValuesCache();
            if (prevRow0 != null) {
                prevRow0.clearValuesCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(CacheDataRow row) throws IgniteCheckedException {
        GridH2Row row0 = this.desc.createRow(row);
        this.lock(false);
        try {
            this.ensureNotDestroyed();
            boolean rmv = this.pk().removex((SearchRow)row0);
            if (rmv) {
                int len = this.idxs.size();
                for (int i = this.pkIndexPos + 1; i < len; ++i) {
                    Index idx = this.idxs.get(i);
                    if (!(idx instanceof GridH2IndexBase)) continue;
                    ((GridH2IndexBase)idx).removex((SearchRow)row0);
                }
                if (!this.tmpIdxs.isEmpty()) {
                    for (GridH2IndexBase idx : this.tmpIdxs.values()) {
                        idx.removex((SearchRow)row0);
                    }
                }
                this.size.decrement();
            }
            boolean bl = rmv;
            return bl;
        }
        finally {
            this.unlock(false);
        }
    }

    private void addToIndex(GridH2IndexBase idx, GridH2Row row, GridH2Row prevRow) {
        boolean replaced = idx.putx(row);
        if (!replaced && prevRow != null) {
            idx.removex((SearchRow)prevRow);
        }
    }

    public void collectIndexesForPartialRebuild(IndexRebuildPartialClosure clo) {
        for (int i = this.sysIdxsCnt; i < this.idxs.size(); ++i) {
            H2TreeIndex idx0;
            Index idx = this.idxs.get(i);
            if (!(idx instanceof H2TreeIndex) || !(idx0 = (H2TreeIndex)idx).rebuildRequired()) continue;
            clo.addIndex(this, idx0);
        }
    }

    public void markRebuildFromHashInProgress(boolean value) {
        assert (!value || this.idxs.size() >= 2 && this.index(1).getIndexType().isHash()) : "Table has no hash index.";
        if (rebuildFromHashInProgressFiledUpdater.compareAndSet(this, value ? 0 : 1, value ? 1 : 0)) {
            this.lock.writeLock().lock();
            try {
                this.incrementModificationCounter();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public boolean rebuildFromHashInProgress() {
        return this.rebuildFromHashInProgress == 1;
    }

    public Index addIndex(Session ses, String idxName, int idxId, IndexColumn[] cols, IndexType idxType, boolean create, String idxComment) {
        return this.commitUserIndex(ses, idxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proposeUserIndex(Index idx) throws IgniteCheckedException {
        assert (idx instanceof GridH2IndexBase);
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            for (Index oldIdx : this.idxs) {
                if (!F.eq((Object)oldIdx.getName(), (Object)idx.getName())) continue;
                throw new IgniteCheckedException("Index already exists: " + idx.getName());
            }
            Index oldTmpIdx = (Index)this.tmpIdxs.put(idx.getName(), (GridH2IndexBase)idx);
            assert (oldTmpIdx == null);
        }
        finally {
            this.unlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index commitUserIndex(Session ses, String idxName) {
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            Index idx = (Index)this.tmpIdxs.remove(idxName);
            assert (idx != null);
            Index cloneIdx = this.createDuplicateIndexIfNeeded(idx);
            ArrayList<Index> newIdxs = new ArrayList<Index>(this.idxs.size() + (cloneIdx == null ? 1 : 2));
            newIdxs.addAll(this.idxs);
            newIdxs.add(idx);
            if (cloneIdx != null) {
                newIdxs.add(cloneIdx);
            }
            this.idxs = newIdxs;
            this.database.addSchemaObject(ses, (SchemaObject)idx);
            if (cloneIdx != null) {
                this.database.addSchemaObject(ses, (SchemaObject)cloneIdx);
            }
            this.incrementModificationCounter();
            Index index = idx;
            return index;
        }
        finally {
            this.unlock(true);
        }
    }

    public void rollbackUserIndex(String idxName) {
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            GridH2IndexBase rmvIdx = this.tmpIdxs.remove(idxName);
            assert (rmvIdx != null);
        }
        finally {
            this.unlock(true);
        }
    }

    public boolean containsUserIndex(String idxName) {
        for (int i = 2; i < this.idxs.size(); ++i) {
            Index idx = this.idxs.get(i);
            if (!idx.getName().equalsIgnoreCase(idxName)) continue;
            return true;
        }
        return false;
    }

    public void removeIndex(Index h2Idx) {
        throw DbException.getUnsupportedException((String)"must use removeIndex(session, idx)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndex(Session session, Index h2Idx) {
        this.lock(true);
        try {
            ArrayList<Index> idxs = new ArrayList<Index>(this.idxs);
            Index targetIdx = h2Idx instanceof GridH2ProxyIndex ? ((GridH2ProxyIndex)h2Idx).underlyingIndex() : h2Idx;
            int i = this.pkIndexPos;
            while (i < idxs.size()) {
                Index idx = idxs.get(i);
                if (idx == targetIdx || idx instanceof GridH2ProxyIndex && ((GridH2ProxyIndex)idx).underlyingIndex() == targetIdx) {
                    idxs.remove(i);
                    if (!(idx instanceof GridH2ProxyIndex) || idx.getSchema().findIndex(session, idx.getName()) == null) continue;
                    this.database.removeSchemaObject(session, (SchemaObject)idx);
                    continue;
                }
                ++i;
            }
            this.idxs = idxs;
        }
        finally {
            this.unlock(true);
        }
    }

    public void removeRow(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"removeRow");
    }

    public void truncate(Session ses) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public void addRow(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"addRow");
    }

    public void checkSupportAlter() {
        throw DbException.getUnsupportedException((String)"alter");
    }

    public TableType getTableType() {
        return TableType.EXTERNAL_TABLE_ENGINE;
    }

    public Index getScanIndex(Session ses) {
        return this.getIndexes().get(0);
    }

    public Index getUniqueIndex() {
        if (this.rebuildFromHashInProgress == 1) {
            return this.index(1);
        }
        return this.index(2);
    }

    public ArrayList<Index> getIndexes() {
        if (this.rebuildFromHashInProgress == 0) {
            return this.idxs;
        }
        ArrayList<Index> idxs = new ArrayList<Index>(2);
        idxs.add(this.idxs.get(0));
        idxs.add(this.idxs.get(1));
        return idxs;
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public boolean isLockedExclusivelyBy(Session ses) {
        return false;
    }

    public long getMaxDataModificationId() {
        return 0L;
    }

    public boolean isDeterministic() {
        return true;
    }

    public boolean canGetRowCount() {
        return true;
    }

    public boolean canDrop() {
        return true;
    }

    public long getRowCount(@Nullable Session ses) {
        return this.getUniqueIndex().getRowCount(ses);
    }

    public long getRowCountApproximation() {
        return this.size.longValue();
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public IndexColumn indexColumn(int col, int sorting) {
        IndexColumn res = new IndexColumn();
        res.column = this.getColumn(col);
        res.columnName = res.column.getName();
        res.sortType = sorting;
        return res;
    }

    public H2RowFactory rowFactory() {
        return this.rowFactory;
    }

    private Index createDuplicateIndexIfNeeded(Index target) {
        if (!(target instanceof H2TreeIndex) && !(target instanceof SpatialIndex)) {
            return null;
        }
        IndexColumn[] cols = target.getIndexColumns();
        ArrayList<IndexColumn> proxyCols = new ArrayList<IndexColumn>(cols.length);
        boolean modified = false;
        for (IndexColumn col : cols) {
            IndexColumn proxyCol = new IndexColumn();
            proxyCol.columnName = col.columnName;
            proxyCol.column = col.column;
            proxyCol.sortType = col.sortType;
            int altColId = this.desc.getAlternativeColumnId(proxyCol.column.getColumnId());
            if (altColId != proxyCol.column.getColumnId()) {
                proxyCol.column = this.getColumn(altColId);
                proxyCol.columnName = proxyCol.column.getName();
                modified = true;
            }
            proxyCols.add(proxyCol);
        }
        if (modified) {
            String proxyName = target.getName() + "_proxy";
            if (target.getIndexType().isSpatial()) {
                return new GridH2ProxySpatialIndex(this, proxyName, proxyCols, target);
            }
            return new GridH2ProxyIndex(this, proxyName, proxyCols, target);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumns(List<QueryField> cols, boolean ifNotExists) {
        assert (!ifNotExists || cols.size() == 1);
        this.lock(true);
        try {
            int pos = this.columns.length;
            Column[] newCols = new Column[this.columns.length + cols.size()];
            System.arraycopy(this.columns, 0, newCols, 0, this.columns.length);
            for (QueryField col : cols) {
                if (this.doesColumnExist(col.name())) {
                    if (ifNotExists && cols.size() == 1) {
                        return;
                    }
                    throw new IgniteSQLException("Column already exists [tblName=" + this.getName() + ", colName=" + col.name() + ']');
                }
                try {
                    Column c = new Column(col.name(), DataType.getTypeFromClass(Class.forName(col.typeName())));
                    c.setNullable(col.isNullable());
                    newCols[pos++] = c;
                }
                catch (ClassNotFoundException e) {
                    throw new IgniteSQLException("H2 data type not found for class: " + col.typeName(), (Throwable)e);
                }
            }
            this.setColumns(newCols);
            this.desc.refreshMetadataFromTypeDescriptor();
            this.incrementModificationCounter();
        }
        finally {
            this.unlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropColumns(List<String> cols, boolean ifExists) {
        assert (!ifExists || cols.size() == 1);
        this.lock(true);
        try {
            int size = this.columns.length;
            for (String name : cols) {
                if (!this.doesColumnExist(name)) {
                    if (ifExists && cols.size() == 1) {
                        return;
                    }
                    throw new IgniteSQLException("Column does not exist [tblName=" + this.getName() + ", colName=" + name + ']');
                }
                --size;
            }
            assert (size > 3);
            Column[] newCols = new Column[size];
            int dst = 0;
            for (int i = 0; i < this.columns.length; ++i) {
                Column column = this.columns[i];
                for (String name : cols) {
                    if (!F.eq((Object)name, (Object)column.getName())) continue;
                    column = null;
                    break;
                }
                if (column == null) continue;
                newCols[dst++] = column;
            }
            this.setColumns(newCols);
            this.desc.refreshMetadataFromTypeDescriptor();
            for (Index idx : this.getIndexes()) {
                if (!(idx instanceof GridH2IndexBase)) continue;
                ((GridH2IndexBase)idx).refreshColumnIds();
            }
            this.incrementModificationCounter();
        }
        finally {
            this.unlock(true);
        }
    }

    public Column[] getColumns() {
        StackTraceElement[] elems;
        StackTraceElement elem;
        Boolean insertHack = INSERT_HACK.get();
        if (insertHack != null && insertHack.booleanValue() && F.eq((Object)(elem = (elems = Thread.currentThread().getStackTrace())[2]).getClassName(), (Object)Insert.class.getName()) && F.eq((Object)elem.getMethodName(), (Object)"prepare")) {
            Column[] columns0 = new Column[this.columns.length - 3];
            System.arraycopy(this.columns, 3, columns0, 0, columns0.length);
            return columns0;
        }
        return this.columns;
    }

    private void incrementModificationCounter() {
        assert (this.lock.isWriteLockedByCurrentThread());
        this.setModified();
    }

    public static void insertHack(boolean val) {
        INSERT_HACK.set(val);
    }

    public static boolean insertHackRequired(String sql) {
        if (F.isEmpty((String)sql)) {
            return false;
        }
        int idxInsert = (sql = sql.toLowerCase()).indexOf("insert");
        if (idxInsert < 0) {
            return false;
        }
        int idxInto = sql.indexOf("into", idxInsert);
        return idxInto >= 0;
    }
}

