/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.dml;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.dml.DmlArgument;
import org.apache.ignite.internal.processors.query.h2.dml.DmlArguments;
import org.apache.ignite.internal.processors.query.h2.dml.DmlAstUtils;
import org.apache.ignite.internal.processors.query.h2.dml.DmlDistributedPlanInfo;
import org.apache.ignite.internal.processors.query.h2.dml.DmlUtils;
import org.apache.ignite.internal.processors.query.h2.dml.FastUpdate;
import org.apache.ignite.internal.processors.query.h2.dml.KeyValueSupplier;
import org.apache.ignite.internal.processors.query.h2.dml.UpdateMode;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDelete;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlInsert;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlMerge;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlParameter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuerySplitter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUnion;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUpdate;
import org.apache.ignite.internal.sql.command.SqlBulkLoadCommand;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.command.Prepared;
import org.h2.table.Column;
import org.jetbrains.annotations.Nullable;

public final class UpdatePlanBuilder {
    private UpdatePlanBuilder() {
    }

    public static UpdatePlan planForStatement(Prepared prepared, boolean loc, IgniteH2Indexing idx, @Nullable Connection conn, @Nullable SqlFieldsQuery fieldsQry, @Nullable Integer errKeysPos) throws IgniteCheckedException {
        assert (!prepared.isQuery());
        GridSqlQueryParser parser = new GridSqlQueryParser(false);
        GridSqlStatement stmt = parser.parse(prepared);
        boolean mvccEnabled = false;
        GridCacheContext cctx = null;
        for (Object o : parser.objectsMap().values()) {
            if (o instanceof GridSqlInsert) {
                o = ((GridSqlInsert)o).into();
            } else if (o instanceof GridSqlMerge) {
                o = ((GridSqlMerge)o).into();
            } else if (o instanceof GridSqlDelete) {
                o = ((GridSqlDelete)o).from();
            }
            if (o instanceof GridSqlAlias) {
                o = GridSqlAlias.unwrap((GridSqlAst)o);
            }
            if (!(o instanceof GridSqlTable)) continue;
            if (((GridSqlTable)o).dataTable() == null) {
                throw new IgniteSQLException("Operation not supported for table '" + ((GridSqlTable)o).tableName() + "'", 1002);
            }
            if (cctx == null) {
                cctx = ((GridSqlTable)o).dataTable().cache();
                mvccEnabled = cctx.mvccEnabled();
                continue;
            }
            if (((GridSqlTable)o).dataTable().cache().mvccEnabled() == mvccEnabled) continue;
            MvccUtils.throwAtomicityModesMismatchException((GridCacheContext)cctx, (GridCacheContext)((GridSqlTable)o).dataTable().cache());
        }
        if (stmt instanceof GridSqlMerge || stmt instanceof GridSqlInsert) {
            return UpdatePlanBuilder.planForInsert(stmt, loc, idx, mvccEnabled, conn, fieldsQry);
        }
        if (stmt instanceof GridSqlUpdate || stmt instanceof GridSqlDelete) {
            return UpdatePlanBuilder.planForUpdate(stmt, loc, idx, mvccEnabled, conn, fieldsQry, errKeysPos);
        }
        throw new IgniteSQLException("Unsupported operation: " + prepared.getSQL(), 1002);
    }

    private static UpdatePlan planForInsert(GridSqlStatement stmt, boolean loc, IgniteH2Indexing idx, boolean mvccEnabled, @Nullable Connection conn, @Nullable SqlFieldsQuery fieldsQuery) throws IgniteCheckedException {
        int rowsNum;
        boolean isTwoStepSubqry;
        GridSqlColumn[] cols;
        GridH2RowDescriptor desc;
        GridSqlTable tbl;
        GridSqlElement target;
        GridSqlQuery sel = null;
        List<GridSqlElement[]> elRows = null;
        if (stmt instanceof GridSqlInsert) {
            GridSqlInsert ins = (GridSqlInsert)stmt;
            target = ins.into();
            tbl = DmlAstUtils.gridTableForElement(target);
            GridH2Table h2Tbl = tbl.dataTable();
            assert (h2Tbl != null);
            desc = h2Tbl.rowDescriptor();
            cols = ins.columns();
            if (UpdatePlanBuilder.noQuery(ins.rows())) {
                elRows = ins.rows();
            } else {
                sel = DmlAstUtils.selectForInsertOrMerge(cols, ins.rows(), ins.query());
            }
            isTwoStepSubqry = ins.query() != null;
            rowsNum = isTwoStepSubqry ? 0 : ins.rows().size();
        } else if (stmt instanceof GridSqlMerge) {
            GridSqlMerge merge = (GridSqlMerge)stmt;
            target = merge.into();
            tbl = DmlAstUtils.gridTableForElement(target);
            desc = tbl.dataTable().rowDescriptor();
            cols = merge.columns();
            if (UpdatePlanBuilder.noQuery(merge.rows())) {
                elRows = merge.rows();
            } else {
                sel = DmlAstUtils.selectForInsertOrMerge(cols, merge.rows(), merge.query());
            }
            isTwoStepSubqry = merge.query() != null;
            rowsNum = isTwoStepSubqry ? 0 : merge.rows().size();
        } else {
            throw new IgniteSQLException("Unexpected DML operation [cls=" + stmt.getClass().getName() + ']', 2001);
        }
        isTwoStepSubqry &= sel != null && (sel instanceof GridSqlUnion || sel instanceof GridSqlSelect && ((GridSqlSelect)sel).from() != null);
        int keyColIdx = -1;
        int valColIdx = -1;
        boolean hasKeyProps = false;
        boolean hasValProps = false;
        if (desc == null) {
            throw new IgniteSQLException("Row descriptor undefined for table '" + tbl.dataTable().getName() + "'", 3002);
        }
        GridCacheContext<?, ?> cctx = desc.context();
        String[] colNames = new String[cols.length];
        int[] colTypes = new int[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            String colName;
            GridSqlColumn col = cols[i];
            colNames[i] = colName = col.columnName();
            colTypes[i] = col.resultType().type();
            int colId = col.column().getColumnId();
            if (desc.isKeyColumn(colId)) {
                keyColIdx = i;
                continue;
            }
            if (desc.isValueColumn(colId)) {
                valColIdx = i;
                continue;
            }
            GridQueryProperty prop = desc.type().property(colName);
            assert (prop != null) : "Property '" + colName + "' not found.";
            if (prop.key()) {
                hasKeyProps = true;
                continue;
            }
            hasValProps = true;
        }
        KeyValueSupplier keySupplier = UpdatePlanBuilder.createSupplier(cctx, desc.type(), keyColIdx, hasKeyProps, true, false);
        KeyValueSupplier valSupplier = UpdatePlanBuilder.createSupplier(cctx, desc.type(), valColIdx, hasValProps, false, false);
        String selectSql = sel != null ? sel.getSQL() : null;
        DmlDistributedPlanInfo distributed = rowsNum == 0 && !F.isEmpty((String)selectSql) ? UpdatePlanBuilder.checkPlanCanBeDistributed(idx, mvccEnabled, conn, fieldsQuery, loc, selectSql, tbl.dataTable().cacheName()) : null;
        UpdateMode mode = stmt instanceof GridSqlMerge ? UpdateMode.MERGE : UpdateMode.INSERT;
        ArrayList<List<DmlArgument>> rows = null;
        if (elRows != null) {
            assert (sel == null);
            rows = new ArrayList<List<DmlArgument>>(elRows.size());
            for (GridSqlElement[] elRow : elRows) {
                ArrayList<DmlArgument> row = new ArrayList<DmlArgument>(cols.length);
                for (GridSqlElement el : elRow) {
                    DmlArgument arg = DmlArguments.create(el);
                    row.add(arg);
                }
                rows.add(row);
            }
        }
        return new UpdatePlan(mode, tbl.dataTable(), colNames, colTypes, keySupplier, valSupplier, keyColIdx, valColIdx, selectSql, !isTwoStepSubqry, rows, rowsNum, null, distributed);
    }

    private static boolean noQuery(List<GridSqlElement[]> rows) {
        if (F.isEmpty(rows)) {
            return false;
        }
        boolean noQry = true;
        for (int i = 0; i < rows.size(); ++i) {
            GridSqlElement[] row = rows.get(i);
            for (int i1 = 0; i1 < row.length; ++i1) {
                GridSqlElement el = row[i1];
                if (noQry &= el instanceof GridSqlConst || el instanceof GridSqlParameter) continue;
                return noQry;
            }
        }
        return true;
    }

    private static UpdatePlan planForUpdate(GridSqlStatement stmt, boolean loc, IgniteH2Indexing idx, boolean mvccEnabled, @Nullable Connection conn, @Nullable SqlFieldsQuery fieldsQuery, @Nullable Integer errKeysPos) throws IgniteCheckedException {
        UpdateMode mode;
        FastUpdate fastUpdate;
        GridSqlElement target;
        if (stmt instanceof GridSqlUpdate) {
            UpdatePlanBuilder.verifyUpdateColumns(stmt);
            GridSqlUpdate update = (GridSqlUpdate)stmt;
            target = update.target();
            fastUpdate = DmlAstUtils.getFastUpdateArgs(update);
            mode = UpdateMode.UPDATE;
        } else if (stmt instanceof GridSqlDelete) {
            GridSqlDelete del = (GridSqlDelete)stmt;
            target = del.from();
            fastUpdate = DmlAstUtils.getFastDeleteArgs(del);
            mode = UpdateMode.DELETE;
        } else {
            throw new IgniteSQLException("Unexpected DML operation [cls=" + stmt.getClass().getName() + ']', 2001);
        }
        GridSqlTable tbl = DmlAstUtils.gridTableForElement(target);
        GridH2Table h2Tbl = tbl.dataTable();
        assert (h2Tbl != null);
        GridH2RowDescriptor desc = h2Tbl.rowDescriptor();
        if (desc == null) {
            throw new IgniteSQLException("Row descriptor undefined for table '" + h2Tbl.getName() + "'", 3002);
        }
        if (fastUpdate != null) {
            return new UpdatePlan(mode, h2Tbl, null, fastUpdate, null);
        }
        if (stmt instanceof GridSqlUpdate) {
            boolean hasProps;
            ArrayList<GridSqlColumn> updatedCols = ((GridSqlUpdate)stmt).cols();
            int valColIdx = -1;
            String[] colNames = new String[updatedCols.size()];
            int[] colTypes = new int[updatedCols.size()];
            for (int i = 0; i < updatedCols.size(); ++i) {
                colNames[i] = ((GridSqlColumn)updatedCols.get(i)).columnName();
                colTypes[i] = ((GridSqlColumn)updatedCols.get(i)).resultType().type();
                Column col = ((GridSqlColumn)updatedCols.get(i)).column();
                if (!desc.isValueColumn(col.getColumnId())) continue;
                valColIdx = i;
            }
            boolean hasNewVal = valColIdx != -1;
            boolean bl = hasProps = !hasNewVal || updatedCols.size() > 1;
            if (hasNewVal) {
                valColIdx += 2;
            }
            int newValColIdx = hasNewVal ? valColIdx : 1;
            KeyValueSupplier valSupplier = UpdatePlanBuilder.createSupplier(desc.context(), desc.type(), newValColIdx, hasProps, false, true);
            GridSqlSelect sel = DmlAstUtils.selectForUpdate((GridSqlUpdate)stmt, errKeysPos);
            String selectSql = sel.getSQL();
            DmlDistributedPlanInfo distributed = F.isEmpty((String)selectSql) ? null : UpdatePlanBuilder.checkPlanCanBeDistributed(idx, mvccEnabled, conn, fieldsQuery, loc, selectSql, tbl.dataTable().cacheName());
            return new UpdatePlan(UpdateMode.UPDATE, h2Tbl, colNames, colTypes, null, valSupplier, -1, valColIdx, selectSql, false, null, 0, null, distributed);
        }
        GridSqlSelect sel = DmlAstUtils.selectForDelete((GridSqlDelete)stmt, errKeysPos);
        String selectSql = sel.getSQL();
        DmlDistributedPlanInfo distributed = F.isEmpty((String)selectSql) ? null : UpdatePlanBuilder.checkPlanCanBeDistributed(idx, mvccEnabled, conn, fieldsQuery, loc, selectSql, tbl.dataTable().cacheName());
        return new UpdatePlan(UpdateMode.DELETE, h2Tbl, selectSql, null, distributed);
    }

    public static UpdatePlan planForBulkLoad(SqlBulkLoadCommand cmd, GridH2Table tbl) throws IgniteCheckedException {
        GridH2RowDescriptor desc = tbl.rowDescriptor();
        if (desc == null) {
            throw new IgniteSQLException("Row descriptor undefined for table '" + tbl.getName() + "'", 3002);
        }
        GridCacheContext<?, ?> cctx = desc.context();
        List cols = cmd.columns();
        if (cols == null) {
            throw new IgniteSQLException("Columns are not defined", 3002);
        }
        String[] colNames = new String[cols.size()];
        int[] colTypes = new int[cols.size()];
        int keyColIdx = -1;
        int valColIdx = -1;
        boolean hasKeyProps = false;
        boolean hasValProps = false;
        for (int i = 0; i < cols.size(); ++i) {
            String colName;
            colNames[i] = colName = (String)cols.get(i);
            Column h2Col = tbl.getColumn(colName);
            colTypes[i] = h2Col.getType();
            int colId = h2Col.getColumnId();
            if (desc.isKeyColumn(colId)) {
                keyColIdx = i;
                continue;
            }
            if (desc.isValueColumn(colId)) {
                valColIdx = i;
                continue;
            }
            GridQueryProperty prop = desc.type().property(colName);
            assert (prop != null) : "Property '" + colName + "' not found.";
            if (prop.key()) {
                hasKeyProps = true;
                continue;
            }
            hasValProps = true;
        }
        KeyValueSupplier keySupplier = UpdatePlanBuilder.createSupplier(cctx, desc.type(), keyColIdx, hasKeyProps, true, false);
        KeyValueSupplier valSupplier = UpdatePlanBuilder.createSupplier(cctx, desc.type(), valColIdx, hasValProps, false, false);
        return new UpdatePlan(UpdateMode.BULK_LOAD, tbl, colNames, colTypes, keySupplier, valSupplier, keyColIdx, valColIdx, null, true, null, 0, null, null);
    }

    private static KeyValueSupplier createSupplier(final GridCacheContext<?, ?> cctx, GridQueryTypeDescriptor desc, final int colIdx, boolean hasProps, final boolean key, boolean forUpdate) throws IgniteCheckedException {
        Constructor ctor;
        final String typeName = key ? desc.keyTypeName() : desc.valueTypeName();
        final Class cls = key ? (Class)U.firstNotNull((Object[])new Class[]{U.classForName((String)desc.keyTypeName(), null), desc.keyClass()}) : desc.valueClass();
        boolean isSqlType = QueryUtils.isSqlType((Class)cls);
        if (isSqlType || !hasProps) {
            if (colIdx != -1) {
                return new PlainValueSupplier(colIdx);
            }
            if (isSqlType) {
                throw new IgniteCheckedException((key ? "Key" : "Value") + " is missing from query");
            }
        }
        if (cctx.binaryMarshaller()) {
            if (colIdx != -1) {
                return new KeyValueSupplier(){

                    public Object apply(List<?> arg) throws IgniteCheckedException {
                        Object obj = arg.get(colIdx);
                        if (obj == null) {
                            return null;
                        }
                        BinaryObject bin = (BinaryObject)cctx.grid().binary().toBinary(obj);
                        BinaryObjectBuilder builder = cctx.grid().binary().builder(bin);
                        cctx.prepareAffinityField(builder);
                        return builder;
                    }
                };
            }
            return new KeyValueSupplier(){

                public Object apply(List<?> arg) throws IgniteCheckedException {
                    BinaryObjectBuilder builder = cctx.grid().binary().builder(typeName);
                    cctx.prepareAffinityField(builder);
                    return builder;
                }
            };
        }
        if (colIdx != -1) {
            if (forUpdate && colIdx == 1) {
                assert (!key);
                return new KeyValueSupplier(){

                    public Object apply(List<?> arg) throws IgniteCheckedException {
                        byte[] oldPropBytes = cctx.marshaller().marshal(arg.get(1));
                        return cctx.marshaller().unmarshal(oldPropBytes, U.resolveClassLoader((IgniteConfiguration)cctx.gridConfig()));
                    }
                };
            }
            return new PlainValueSupplier(colIdx);
        }
        try {
            ctor = cls.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException ignored) {
            ctor = null;
        }
        if (ctor != null) {
            final Constructor ctor0 = ctor;
            return new KeyValueSupplier(){

                public Object apply(List<?> arg) throws IgniteCheckedException {
                    try {
                        return ctor0.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        if (S.INCLUDE_SENSITIVE) {
                            throw new IgniteCheckedException("Failed to instantiate " + (key ? "key" : "value") + " [type=" + typeName + ']', (Throwable)e);
                        }
                        throw new IgniteCheckedException("Failed to instantiate " + (key ? "key" : "value") + '.', (Throwable)e);
                    }
                }
            };
        }
        return new KeyValueSupplier(){

            public Object apply(List<?> arg) throws IgniteCheckedException {
                try {
                    return GridUnsafe.allocateInstance((Class)cls);
                }
                catch (InstantiationException e) {
                    if (S.INCLUDE_SENSITIVE) {
                        throw new IgniteCheckedException("Failed to instantiate " + (key ? "key" : "value") + " [type=" + typeName + ']', (Throwable)e);
                    }
                    throw new IgniteCheckedException("Failed to instantiate " + (key ? "key" : "value") + '.', (Throwable)e);
                }
            }
        };
    }

    private static void verifyUpdateColumns(GridSqlStatement statement) {
        if (statement == null || !(statement instanceof GridSqlUpdate)) {
            return;
        }
        GridSqlUpdate update = (GridSqlUpdate)statement;
        GridSqlElement updTarget = update.target();
        HashSet<GridSqlTable> tbls = new HashSet<GridSqlTable>();
        DmlAstUtils.collectAllGridTablesInTarget(updTarget, tbls);
        if (tbls.size() != 1) {
            throw new IgniteSQLException("Failed to determine target table for UPDATE", 3001);
        }
        GridSqlTable tbl = (GridSqlTable)tbls.iterator().next();
        GridH2Table gridTbl = tbl.dataTable();
        if (gridTbl != null && UpdatePlanBuilder.updateAffectsKeyColumns(gridTbl, update.set().keySet())) {
            throw new IgniteSQLException("SQL UPDATE can't modify key or its fields directly", 2003);
        }
    }

    private static boolean updateAffectsKeyColumns(GridH2Table gridTbl, Set<String> affectedColNames) {
        GridH2RowDescriptor desc = gridTbl.rowDescriptor();
        for (String colName : affectedColNames) {
            int colId = gridTbl.getColumn(colName).getColumnId();
            if (desc.isKeyColumn(colId)) {
                return true;
            }
            if (colId < 3 || !desc.isColumnKeyProperty(colId - 3)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DmlDistributedPlanInfo checkPlanCanBeDistributed(IgniteH2Indexing idx, boolean mvccEnabled, Connection conn, SqlFieldsQuery fieldsQry, boolean loc, String selectQry, String cacheName) throws IgniteCheckedException {
        if (loc) return null;
        if (!mvccEnabled) {
            if (!UpdatePlanBuilder.isSkipReducerOnUpdateQuery(fieldsQry)) return null;
        }
        if (DmlUtils.isBatched(fieldsQry)) {
            return null;
        }
        assert (conn != null);
        try (PreparedStatement stmt = conn.prepareStatement(selectQry);){
            idx.bindParameters(stmt, F.asList((Object[])fieldsQry.getArgs()));
            GridCacheTwoStepQuery qry = GridSqlQuerySplitter.split(conn, GridSqlQueryParser.prepared(stmt), fieldsQry.getArgs(), fieldsQry.isCollocated(), fieldsQry.isDistributedJoins(), fieldsQry.isEnforceJoinOrder(), idx);
            boolean distributed = qry.skipMergeTable() && qry.mapQueries().size() == 1 && !qry.mapQueries().get(0).hasSubQueries();
            DmlDistributedPlanInfo dmlDistributedPlanInfo = distributed ? new DmlDistributedPlanInfo(qry.isReplicatedOnly(), idx.collectCacheIds(CU.cacheId((String)cacheName), qry)) : null;
            return dmlDistributedPlanInfo;
        }
        catch (SQLException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    public static boolean isSkipReducerOnUpdateQuery(SqlFieldsQuery qry) {
        return qry != null && !qry.isLocal() && qry instanceof SqlFieldsQueryEx && ((SqlFieldsQueryEx)qry).isSkipReducerOnUpdate();
    }

    private static final class PlainValueSupplier
    implements KeyValueSupplier {
        private final int colIdx;

        private PlainValueSupplier(int colIdx) {
            this.colIdx = colIdx;
        }

        public Object apply(List<?> arg) throws IgniteCheckedException {
            return arg.get(this.colIdx);
        }
    }
}

