/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2RowLinkIO;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2SearchRow;
import org.apache.ignite.internal.transactions.IgniteTxUnexpectedStateCheckedException;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;

public class H2TreeFilterClosure
implements BPlusTree.TreeRowClosure<GridH2SearchRow, GridH2Row> {
    private final MvccSnapshot mvccSnapshot;
    private final IndexingQueryCacheFilter filter;
    private final GridCacheContext cctx;
    private final IgniteLogger log;

    public H2TreeFilterClosure(IndexingQueryCacheFilter filter, MvccSnapshot mvccSnapshot, GridCacheContext cctx, IgniteLogger log) {
        assert ((filter != null || mvccSnapshot != null) && cctx != null);
        this.filter = filter;
        this.mvccSnapshot = mvccSnapshot;
        this.cctx = cctx;
        this.log = log;
    }

    public boolean apply(BPlusTree<GridH2SearchRow, GridH2Row> tree, BPlusIO<GridH2SearchRow> io, long pageAddr, int idx) throws IgniteCheckedException {
        return !(this.filter != null && !this.applyFilter((H2RowLinkIO)io, pageAddr, idx) || this.mvccSnapshot != null && !this.applyMvcc((H2RowLinkIO)io, pageAddr, idx));
    }

    private boolean applyFilter(H2RowLinkIO io, long pageAddr, int idx) {
        assert (this.filter != null);
        return this.filter.applyPartition(PageIdUtils.partId((long)PageIdUtils.pageId((long)io.getLink(pageAddr, idx))));
    }

    private boolean applyMvcc(H2RowLinkIO io, long pageAddr, int idx) throws IgniteCheckedException {
        assert (io.storeMvccInfo()) : io;
        long rowCrdVer = io.getMvccCoordinatorVersion(pageAddr, idx);
        long rowCntr = io.getMvccCounter(pageAddr, idx);
        int rowOpCntr = io.getMvccOperationCounter(pageAddr, idx);
        assert (MvccUtils.mvccVersionIsValid((long)rowCrdVer, (long)rowCntr, (int)rowOpCntr));
        try {
            return MvccUtils.isVisible((GridCacheContext)this.cctx, (MvccSnapshot)this.mvccSnapshot, (long)rowCrdVer, (long)rowCntr, (int)rowOpCntr, (long)io.getLink(pageAddr, idx));
        }
        catch (IgniteTxUnexpectedStateCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unexpected tx state on index lookup. " + X.getFullStackTrace((Throwable)e));
            }
            return false;
        }
    }

    public String toString() {
        return S.toString(H2TreeFilterClosure.class, (Object)this);
    }
}

