/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;

public class IndexRebuildPartialClosure
implements SchemaIndexCacheVisitorClosure {
    private final Map<GridH2Table, Collection<GridH2IndexBase>> tblIdxs = new IdentityHashMap<GridH2Table, Collection<GridH2IndexBase>>();

    public void apply(CacheDataRow row) throws IgniteCheckedException {
        assert (this.hasIndexes());
        for (Map.Entry<GridH2Table, Collection<GridH2IndexBase>> tblIdxEntry : this.tblIdxs.entrySet()) {
            GridH2Table tbl = tblIdxEntry.getKey();
            GridH2Row row0 = tbl.rowDescriptor().createRow(row);
            for (GridH2IndexBase idx : tblIdxEntry.getValue()) {
                idx.putx(row0);
            }
        }
    }

    public void addIndex(GridH2Table tbl, GridH2IndexBase idx) {
        Collection<GridH2IndexBase> idxs = this.tblIdxs.get((Object)tbl);
        if (idxs == null) {
            idxs = Collections.newSetFromMap(new IdentityHashMap());
            idxs.add(idx);
            this.tblIdxs.put(tbl, idxs);
        }
        idxs.add(idx);
    }

    public boolean hasIndexes() {
        return !this.tblIdxs.isEmpty();
    }
}

