/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.PreparedStatement;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.internal.processors.query.h2.H2CachedStatementKey;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class H2StatementCache {
    private volatile long lastUsage;
    private final LinkedHashMap<H2CachedStatementKey, PreparedStatement> lruStmtCache;

    H2StatementCache(final int size) {
        this.lruStmtCache = new LinkedHashMap<H2CachedStatementKey, PreparedStatement>(size, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<H2CachedStatementKey, PreparedStatement> eldest) {
                if (this.size() <= size) {
                    return false;
                }
                U.closeQuiet((AutoCloseable)eldest.getValue());
                return true;
            }
        };
    }

    void put(H2CachedStatementKey key, @NotNull PreparedStatement stmt) {
        this.lruStmtCache.put(key, stmt);
    }

    @Nullable
    PreparedStatement get(H2CachedStatementKey key) {
        return this.lruStmtCache.get(key);
    }

    long lastUsage() {
        return this.lastUsage;
    }

    void updateLastUsage() {
        this.lastUsage = U.currentTimeMillis();
    }

    void remove(String schemaName, String sql) {
        this.lruStmtCache.remove(new H2CachedStatementKey(schemaName, sql));
    }

    int size() {
        return this.lruStmtCache.size();
    }
}

