/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.cache.query.QueryTable;
import org.apache.ignite.internal.processors.query.h2.affinity.PartitionInfo;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridCacheTwoStepQuery {
    public static final int DFLT_PAGE_SIZE = 1000;
    @GridToStringInclude
    private List<GridCacheSqlQuery> mapQrys = new ArrayList<GridCacheSqlQuery>();
    @GridToStringInclude
    private GridCacheSqlQuery rdc;
    private int pageSize = 1000;
    private boolean explain;
    private String originalSql;
    private Set<QueryTable> tbls;
    private boolean distributedJoins;
    private boolean skipMergeTbl;
    private List<Integer> cacheIds;
    private boolean local;
    private PartitionInfo[] derivedPartitions;
    private boolean mvccEnabled;
    private boolean forUpdate;

    public GridCacheTwoStepQuery(String originalSql, Set<QueryTable> tbls) {
        this.originalSql = originalSql;
        this.tbls = tbls;
    }

    public void distributedJoins(boolean distributedJoins) {
        this.distributedJoins = distributedJoins;
    }

    public boolean distributedJoins() {
        return this.distributedJoins;
    }

    public boolean skipMergeTable() {
        return this.skipMergeTbl;
    }

    public void skipMergeTable(boolean skipMergeTbl) {
        this.skipMergeTbl = skipMergeTbl;
    }

    public boolean explain() {
        return this.explain;
    }

    public void explain(boolean explain) {
        this.explain = explain;
    }

    public void pageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public void addMapQuery(GridCacheSqlQuery qry) {
        this.mapQrys.add(qry);
    }

    public boolean isReplicatedOnly() {
        assert (!this.mapQrys.isEmpty());
        for (GridCacheSqlQuery mapQry : this.mapQrys) {
            if (!mapQry.isPartitioned()) continue;
            return false;
        }
        return true;
    }

    public GridCacheSqlQuery reduceQuery() {
        return this.rdc;
    }

    public void reduceQuery(GridCacheSqlQuery rdc) {
        this.rdc = rdc;
    }

    public List<GridCacheSqlQuery> mapQueries() {
        return this.mapQrys;
    }

    public List<Integer> cacheIds() {
        return this.cacheIds;
    }

    public void cacheIds(List<Integer> cacheIds) {
        this.cacheIds = cacheIds;
    }

    public String originalSql() {
        return this.originalSql;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void local(boolean local) {
        this.local = local;
    }

    public PartitionInfo[] derivedPartitions() {
        return this.derivedPartitions;
    }

    public void derivedPartitions(PartitionInfo[] derivedPartitions) {
        this.derivedPartitions = derivedPartitions;
    }

    public GridCacheTwoStepQuery copy() {
        assert (!this.explain);
        GridCacheTwoStepQuery cp = new GridCacheTwoStepQuery(this.originalSql, this.tbls);
        cp.cacheIds = this.cacheIds;
        cp.rdc = this.rdc.copy();
        cp.skipMergeTbl = this.skipMergeTbl;
        cp.pageSize = this.pageSize;
        cp.distributedJoins = this.distributedJoins;
        cp.derivedPartitions = this.derivedPartitions;
        cp.local = this.local;
        cp.mvccEnabled = this.mvccEnabled;
        cp.forUpdate = this.forUpdate;
        for (int i = 0; i < this.mapQrys.size(); ++i) {
            cp.mapQrys.add(this.mapQrys.get(i).copy());
        }
        return cp;
    }

    public int tablesCount() {
        return this.tbls.size();
    }

    public Set<QueryTable> tables() {
        return this.tbls;
    }

    public boolean mvccEnabled() {
        return this.mvccEnabled;
    }

    public void mvccEnabled(boolean mvccEnabled) {
        this.mvccEnabled = mvccEnabled;
    }

    public boolean forUpdate() {
        return this.forUpdate;
    }

    public void forUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public String toString() {
        return S.toString(GridCacheTwoStepQuery.class, (Object)this);
    }
}

