#!/usr/bin/env bash
#
# Copyright (C) GridGain Systems. All Rights Reserved.
#  _________        _____ __________________        _____
#  __  ____/___________(_)______  /__  ____/______ ____(_)_______
#  _  / __  __  ___/__  / _  __  / _  / __  _  __ `/__  / __  __ \
#  / /_/ /  _  /    _  /  / /_/ /  / /_/ /  / /_/ / _  /  _  / / /
#  \____/   /_/     /_/   \_,__/   \____/   \__,_/  /_/   /_/ /_/
#

# This script is a shortcut for copying required gridgain binaries to kafka connector lib folder

# Define script directory.
SCRIPT_DIR=$(cd $(dirname "$0"); pwd)
GG_HOME_DIR=$(cd ${SCRIPT_DIR}/../../; pwd)
GG_LIBS_DIR="${GG_HOME_DIR}/libs/"

LIBS_ARRAY=(\
"*.jar" \
"ignite-indexing/*.jar" \
"ignite-spring/*.jar" \
)

for lib in ${LIBS_ARRAY[*]}; do
    cp ${GG_LIBS_DIR}/${lib} ${SCRIPT_DIR}/lib
done

# If cluster nodes use Ultimate Edition, connector should also include gridgain-ultimate binaries in classpath
if [[ -e ${GG_LIBS_DIR}/gridgain-ultimate ]]; then
    cp ${GG_LIBS_DIR}/gridgain-ultimate/*.jar ${SCRIPT_DIR}/lib
fi
