/*
 *  Copyright (C) GridGain Systems. All Rights Reserved.
 *  _________        _____ __________________        _____
 *  __  ____/___________(_)______  /__  ____/______ ____(_)_______
 *  _  / __  __  ___/__  / _  __  / _  / __  _  __ `/__  / __  __ \
 *  / /_/ /  _  /    _  /  / /_/ /  / /_/ /  / /_/ / _  /  _  / / /
 *  \____/   /_/     /_/   \_,__/   \____/   \__,_/  /_/   /_/ /_/
 */

package org.gridgain.examples.dr.ssl;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.events.EventType;
import org.gridgain.examples.dr.misc.DrUpdatesListener;
import org.gridgain.examples.dr.misc.Value;

/**
 * Same as DrExample, but with ssl context factory in ignite configuration. By default data replication use
 * ssl context factory from ignite configuration.
 * To see whole test description - check {@link org.gridgain.examples.dr.DrExample}.
 */
public class DrExampleSsl {
    /** Cache name. */
    static final String CACHE_NAME = "crossDrCache";

    /**
     * @param args Program arguments, ignored.
     * @throws Exception If failed.
     */
    public static void main(String[] args) throws Exception {
        // Staring a node from first data center that is both receiver and sender HUB.
        try (Ignite dr1Hub = Ignition.start("config/dr/dr1-sender-receiver-hub-ssl.xml")) {
            // Listening for cache update printing out those that come from the remote data center prefixed 'dr2_'.
            dr1Hub.events().localListen(new DrUpdatesListener("dr2"), EventType.EVT_CACHE_OBJECT_PUT);

            IgniteCache<Integer, Value> cache = dr1Hub.cache(CACHE_NAME);

            long valGen = 0;

            /*
             * Until sender HUB connects to the remote data center you'll see harmless error message in the log
             * '[DrSenderRemoteDataCenterNode] Could not connect to replica...'
             */
            while (true) {
                for (int i = 0; i < 500; i++) {
                    /*
                     * Overriding a value in the cache setting the prefix of local data center.
                     * The remote data center will trigger this using {@link DrUpdatesListener}.
                     *
                     * When a value that has the same key is updated by both data centers, then
                     * {@link ChronologicalConflictResolver} is used to decide which value to keep in the cache of each
                     * data center.
                     */
                    cache.put(i, new Value("dr1_" + valGen++));

                    Thread.sleep(1500);
                }
            }
        }
    }
}
