/*
 *  Copyright (C) GridGain Systems. All Rights Reserved.
 *  _________        _____ __________________        _____
 *  __  ____/___________(_)______  /__  ____/______ ____(_)_______
 *  _  / __  __  ___/__  / _  __  / _  / __  _  __ `/__  / __  __ \
 *  / /_/ /  _  /    _  /  / /_/ /  / /_/ /  / /_/ / _  /  _  / / /
 *  \____/   /_/     /_/   \_,__/   \____/   \__,_/  /_/   /_/ /_/
 */

package org.gridgain.examples.dr.misc;

import org.apache.ignite.events.CacheEvent;
import org.apache.ignite.lang.IgnitePredicate;

import java.util.Arrays;

/**
 * Cache listener that prints out updates coming from the remote data center.
 */
public class DrUpdatesListener implements IgnitePredicate<CacheEvent> {
    /** DR specific prefix that is added to each entry's value. */
    private final String[] remoteDrPrefix;

    /**
     * Constructor.
     *
     * @param remoteDrPrefix DR specific prefix that is added to each entry's value.
     */
    public DrUpdatesListener(String... remoteDrPrefix) {
        this.remoteDrPrefix = remoteDrPrefix;
    }

    /** {@inheritDoc} */
    @Override public boolean apply(CacheEvent event) {
        String val = ((Value)event.newValue()).getName();

        // Printing out only those cache updates that come from the remote data center.
        String prefix = Arrays.stream(remoteDrPrefix).filter(pref -> val.startsWith(pref)).findAny().orElse(null);

        if (prefix != null)
            System.out.println("Received and stored update from the remote data center " + prefix + " " +
                "[key=" + event.key() + ", val=" + val + ']');

        return true;
    }
}
