/*
 *  Copyright (C) GridGain Systems. All Rights Reserved.
 *  _________        _____ __________________        _____
 *  __  ____/___________(_)______  /__  ____/______ ____(_)_______
 *  _  / __  __  ___/__  / _  __  / _  / __  _  __ `/__  / __  __ \
 *  / /_/ /  _  /    _  /  / /_/ /  / /_/ /  / /_/ / _  /  _  / / /
 *  \____/   /_/     /_/   \_,__/   \____/   \__,_/  /_/   /_/ /_/
 */

package org.gridgain.examples.dr.misc;

import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.events.EventType;

/**
 * Starts an additional node that will be a part of the first data center (refer to dr1 config files).
 */
public class Dr1NodeStartup {
    public static void main(String[] args) throws Exception {
        // Starting an additional node that belongs to the first data center.
        Ignite dr1Hub = Ignition.start("config/dr/dr1-node.xml");

        // Listening for cache updates printing out those that come from the remote data center.
        dr1Hub.events().localListen(new DrUpdatesListener("dr2_"), EventType.EVT_CACHE_OBJECT_PUT);
    }
}
