/*
 *  Copyright (C) GridGain Systems. All Rights Reserved.
 *  _________        _____ __________________        _____
 *  __  ____/___________(_)______  /__  ____/______ ____(_)_______
 *  _  / __  __  ___/__  / _  __  / _  / __  _  __ `/__  / __  __ \
 *  / /_/ /  _  /    _  /  / /_/ /  / /_/ /  / /_/ / _  /  _  / / /
 *  \____/   /_/     /_/   \_,__/   \____/   \__,_/  /_/   /_/ /_/
 */

package org.gridgain.examples.dr.misc;

import org.gridgain.grid.cache.conflict.CacheConflictContext;
import org.gridgain.grid.cache.conflict.CacheConflictResolver;

/**
 * Conflict resolution based on entry modification timestamps. Used for the cases when an entry is updated in local data
 * center and replicated from the remote one.
 *
 * https://www.gridgain.com/docs/latest/administrators-guide/conflicts-resolution
 */
public class ChronologicalConflictResolver implements CacheConflictResolver {
    /** {@inheritDoc} */
    @Override public void resolve(CacheConflictContext ctx) {
        System.out.println("Resolving conflict: " + ctx);

        Value oldVal = (Value)ctx.oldEntry().value();

        Value newVal = (Value)ctx.newEntry().value();

        if (oldVal == null)
            ctx.useNew();
        else if (oldVal.getTime() > newVal.getTime())
            ctx.useOld();
        else
            ctx.useNew();
    }
}
