/*
 *  Copyright (C) GridGain Systems. All Rights Reserved.
 *  _________        _____ __________________        _____
 *  __  ____/___________(_)______  /__  ____/______ ____(_)_______
 *  _  / __  __  ___/__  / _  __  / _  / __  _  __ `/__  / __  __ \
 *  / /_/ /  _  /    _  /  / /_/ /  / /_/ /  / /_/ / _  /  _  / / /
 *  \____/   /_/     /_/   \_,__/   \____/   \__,_/  /_/   /_/ /_/
 */

package org.gridgain.examples.auth;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.configuration.CacheConfiguration;

/**
 * This example demonstrates use of Access control list with GridGain cache.
 * <p>
 * To execute this example you should start an instance of {@code GridAclExampleServerNodeStartup}
 * class which will start up a GridGain remote server node with proper configuration.
 * <p>
 * Alternatively a remote server node can be started by execution the following command in a command line:
 * {IGNITE_HOME}/bin/ignite.{bat|sh} {IGNITE_HOME}/examples/config/server-auth.xml
 * <p>
 * After the remote node has been started, set IGNITE_HOME environment variable referring to GridGain module location
 * and run this example which will create and put entry to cache and then read it.
 */
public class GridAclAllowAllExample {
    /**
     * Executes example.
     *
     * @param args Command line arguments, none required.
     */
    public static void main(String[] args) {
        System.out.println("Node has permissions to put and get.");

        // Starting client node with all permissions.
        try (Ignite ignite = Ignition.start("config/client-auth-allow-all.xml")) {
            CacheConfiguration<Integer, Integer> cfg = new CacheConfiguration<>();

            cfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
            cfg.setBackups(1);
            cfg.setName("cache");

            // Creating cache.
            IgniteCache<Integer, Integer> cache = ignite.getOrCreateCache(cfg);

            System.out.println("Put entry [key=1, value=1].");

            // Successful put.
            cache.put(1, 1);

            System.out.println("Got entry [key=1, value=" + Integer.toString(cache.get(1)) + "].");

            // Successful read.
            assert cache.get(1) == 1;

            System.out.println("Got entry added by server node [key=3, value=" + Integer.toString(cache.get(3)) + "].");

            // Successful read of data pregenerated by server node(s).
            assert cache.get(3) == 3;
        }
    }
}
