#!/bin/bash
#
# Copyright (C) GridGain Systems. All Rights Reserved.
#  _________        _____ __________________        _____
#  __  ____/___________(_)______  /__  ____/______ ____(_)_______
#  _  / __  __  ___/__  / _  __  / _  / __  _  __ `/__  / __  __ \
#  / /_/ /  _  /    _  /  / /_/ /  / /_/ /  / /_/ / _  /  _  / / /
#  \____/   /_/     /_/   \_,__/   \____/   \__,_/  /_/   /_/ /_/
#

#
# Starts Snapshot Utility on the classpath.
#

# Remember command line parameters
ARGS=("$@")

#
# Import common functions.
#
if [ "${IGNITE_HOME}" = "" ];
    then IGNITE_HOME_TMP="$(dirname "$(cd "$(dirname "$0")"; "pwd")")";
    else IGNITE_HOME_TMP=${IGNITE_HOME};
fi

#
# Set SCRIPTS_HOME - base path to scripts.
#
SCRIPTS_HOME="${IGNITE_HOME_TMP}/bin"

source "${SCRIPTS_HOME}"/include/functions.sh
source "${SCRIPTS_HOME}"/include/jvmdefaults.sh

#
# Discover path to Java executable and check it's version.
#
checkJava

#
# Discover IGNITE_HOME environment variable.
#
setIgniteHome

#
# Set IGNITE_LIBS.
#
. "${SCRIPTS_HOME}"/include/setenv.sh

CP="${IGNITE_HOME}/bin/include/snapshot-utility/*${SEP}${IGNITE_LIBS}"

#
# JVM options. See http://www.oracle.com/technetwork/java/javase/tech/vmoptions-jsp-140102.html for more details.
#
# ADD YOUR/CHANGE ADDITIONAL OPTIONS HERE
#
if [ -z "$SNAP_UTIL_JVM_OPTS" ] ; then
    SNAP_UTIL_JVM_OPTS="-Xms256m -Xmx1g${SNAP_UTIL_JVM_OPTS}"
fi

# Mac OS specific support to display correct name in the dock.
osname=`uname`

if [ "${DOCK_OPTS}" == "" ]; then
    DOCK_OPTS="-Xdock:name=Snapshot Utility"
fi

#
# Final SNAP_UTIL_JVM_OPTS for Java 9+ compatibility
#
SNAP_UTIL_JVM_OPTS=$(getJavaSpecificOpts $version "$SNAP_UTIL_JVM_OPTS")

if [ -n "${JVM_OPTS}" ] ; then
  echo "JVM_OPTS environment variable is set, but will not be used. To pass JVM options use SNAP_UTIL_JVM_OPTS"
  echo "JVM_OPTS=${JVM_OPTS}"
fi

#
# Starts Snapshot Utility.
#
case $osname in
    Darwin*)
        "$JAVA" ${SNAP_UTIL_JVM_OPTS} "${DOCK_OPTS}" -cp "${CP}" org.gridgain.database.utility.SnapshotUtility "${ARGS[@]-}"
        ;;
    OS/390*)
        "$JAVA" ${SNAP_UTIL_JVM_OPTS} $(getIbmSslOpts $version) \
        -cp "${CP}" org.gridgain.database.utility.SnapshotUtility "${ARGS[@]-}"
        ;;
    *)
        "$JAVA" ${SNAP_UTIL_JVM_OPTS} -cp "${CP}" org.gridgain.database.utility.SnapshotUtility  "${ARGS[@]-}"
        ;;
esac
