#!/bin/bash
#
# Copyright (C) GridGain Systems. All Rights Reserved.
#  _________        _____ __________________        _____
#  __  ____/___________(_)______  /__  ____/______ ____(_)_______
#  _  / __  __  ___/__  / _  __  / _  / __  _  __ `/__  / __  __ \
#  / /_/ /  _  /    _  /  / /_/ /  / /_/ /  / /_/ / _  /  _  / / /
#  \____/   /_/     /_/   \_,__/   \____/   \__,_/  /_/   /_/ /_/
#

#
# Starts Checksum Utility on the classpath.
#

# Remember command line parameters
ARGS=$@

#
# Import common functions.
#
if [ "${IGNITE_HOME}" = "" ];
    then IGNITE_HOME_TMP="$(dirname "$(cd "$(dirname "$0")"; "pwd")")";
    else IGNITE_HOME_TMP=${IGNITE_HOME};
fi

#
# Set SCRIPTS_HOME - base path to scripts.
#
SCRIPTS_HOME="${IGNITE_HOME_TMP}/bin"

source "${SCRIPTS_HOME}"/include/functions.sh
source "${SCRIPTS_HOME}"/include/jvmdefaults.sh

#
# Discover path to Java executable and check it's version.
#
checkJava

#
# Discover IGNITE_HOME environment variable.
#
setIgniteHome

#
# Parse command line parameters.
#
. "${SCRIPTS_HOME}"/include/parseargs.sh

#
# Set IGNITE_LIBS.
#
. "${SCRIPTS_HOME}"/include/setenv.sh
CP="${CP}${SEP}${IGNITE_HOME}/bin/include/checksum-utility/*${SEP}${IGNITE_LIBS}"

#
# JVM options. See http://www.oracle.com/technetwork/java/javase/tech/vmoptions-jsp-140102.html for more details.
#
# ADD YOUR/CHANGE ADDITIONAL OPTIONS HERE
#
if [ -z "$JVM_OPTS" ] ; then
    JVM_OPTS="-Xms256m -Xmx1g${JVM_OPTS}"
fi

# Mac OS specific support to display correct name in the dock.
osname=`uname`

if [ "${DOCK_OPTS}" == "" ]; then
    DOCK_OPTS="-Xdock:name=Checksum Utility"
fi

#
# Final JVM_OPTS for Java 9+ compatibility
#
JVM_OPTS=$(getJavaSpecificOpts $version "$JVM_OPTS")

#
# Starts Checksum Utility.
#
case $osname in
    Darwin*)
        "$JAVA" ${JVM_OPTS} "${DOCK_OPTS}" -cp "${CP}" org.gridgain.cachechecksum.utility.CacheCheckSumUtility ${ARGS}
        ;;
   *)
        "$JAVA" ${JVM_OPTS} -cp "${CP}" org.gridgain.cachechecksum.utility.CacheCheckSumUtility ${ARGS}
        ;;
esac
