/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.twostep.AbstractReducer;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceResultPage;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public abstract class UnsortedBaseReducer
extends AbstractReducer {
    protected final AtomicInteger activeSourcesCnt = new AtomicInteger(-1);
    protected final PollableQueue<ReduceResultPage> queue = new PollableQueue();
    protected Iterator<Value[]> iter = Collections.emptyIterator();

    public UnsortedBaseReducer(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public void setSources(Map<ClusterNode, BitSet> nodesToSegmentsCnt) {
        super.setSources(nodesToSegmentsCnt);
        int totalSegmentsCnt = nodesToSegmentsCnt.values().stream().mapToInt(BitSet::cardinality).sum();
        assert (totalSegmentsCnt > 0) : totalSegmentsCnt;
        this.activeSourcesCnt.set(totalSegmentsCnt);
    }

    @Override
    public boolean fetchedAll() {
        int x = this.activeSourcesCnt.get();
        assert (x >= 0) : x;
        return x == 0 && this.queue.isEmpty();
    }

    @Override
    protected void addPage0(ReduceResultPage page) {
        assert (page.rowsInPage() > 0 || page.isLast() || page.isFail());
        if (page.rowsInPage() != 0 || page.isFail()) {
            this.queue.add(page);
        }
        if (page.isLast()) {
            int x = this.activeSourcesCnt.decrementAndGet();
            assert (x >= 0) : x;
            if (x == 0) {
                this.queue.add(this.createDummyLastPage(page));
            }
        }
    }

    @Override
    protected Cursor findAllFetched(List<Row> fetched, @Nullable SearchRow first, @Nullable SearchRow last) {
        return new GridH2Cursor(fetched.iterator());
    }

    private static class PollableQueue<X>
    extends LinkedBlockingQueue<X>
    implements AbstractReducer.Pollable<X> {
        private PollableQueue() {
        }
    }
}

