/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.Collections;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.util.typedef.F;
import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.table.Column;

public class GridSqlColumn
extends GridSqlElement {
    private GridSqlAst from;
    private String schema;
    private String tblAlias;
    private String colName;
    private Column col;

    public GridSqlColumn(Column col, GridSqlAst from, String colName) {
        this(col, from, null, null, colName);
    }

    public GridSqlColumn(Column col, GridSqlAst from, String schema, String tblAlias, String colName) {
        super(Collections.emptyList());
        assert (!F.isEmpty((String)colName)) : colName;
        this.col = col;
        this.from = from;
        this.colName = colName;
        this.schema = schema;
        this.tblAlias = tblAlias;
    }

    public String columnName() {
        return this.colName;
    }

    public String schema() {
        return this.schema;
    }

    public void tableAlias(String tblAlias) {
        this.tblAlias = tblAlias;
    }

    public String tableAlias() {
        return this.tblAlias;
    }

    @Override
    public String getSQL() {
        StringBuilder sb = new StringBuilder();
        if (this.schema != null) {
            Parser.quoteIdentifier((StringBuilder)sb, (String)this.schema, (boolean)true);
            sb.append(".");
        }
        if (this.tblAlias != null) {
            Parser.quoteIdentifier((StringBuilder)sb, (String)this.tblAlias, (boolean)true);
            sb.append(".");
        }
        Parser.quoteIdentifier((StringBuilder)sb, (String)this.colName, (boolean)true);
        return sb.toString();
    }

    public GridSqlAst expressionInFrom() {
        return this.from;
    }

    public void expressionInFrom(GridSqlAlias from) {
        this.from = from;
    }

    public Object defaultValue() {
        Expression dfltExpr = this.col.getDefaultExpression();
        return dfltExpr != null ? this.col.convert(dfltExpr.getValue(null)).getObject() : null;
    }

    public int precision() {
        return (int)this.col.getType().getPrecision();
    }

    public int scale() {
        return this.col.getType().getScale();
    }

    public Column column() {
        return this.col;
    }
}

