/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.dml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.EnlistOperation;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.UpdateSourceIterator;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.dml.DmlArgument;
import org.apache.ignite.internal.processors.query.h2.dml.DmlDistributedPlanInfo;
import org.apache.ignite.internal.processors.query.h2.dml.DmlUtils;
import org.apache.ignite.internal.processors.query.h2.dml.FastUpdate;
import org.apache.ignite.internal.processors.query.h2.dml.KeyValueSupplier;
import org.apache.ignite.internal.processors.query.h2.dml.UpdateMode;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapterEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.lang.IgniteBiTuple;
import org.gridgain.internal.h2.table.Column;
import org.jetbrains.annotations.Nullable;

public final class UpdatePlan {
    private final UpdateMode mode;
    private final GridH2Table tbl;
    private final String[] colNames;
    private final int[] colTypes;
    private final KeyValueSupplier keySupplier;
    private final KeyValueSupplier valSupplier;
    private final int keyColIdx;
    private final int valColIdx;
    private final String selectQry;
    private final boolean isLocSubqry;
    private final List<List<DmlArgument>> rows;
    private final int rowsNum;
    private boolean fillAbsentPKsWithDefaults;
    private final FastUpdate fastUpdate;
    private final DmlDistributedPlanInfo distributed;
    private final boolean canSelectBeLazy;

    public UpdatePlan(UpdateMode mode, GridH2Table tbl, String[] colNames, int[] colTypes, KeyValueSupplier keySupplier, KeyValueSupplier valSupplier, int keyColIdx, int valColIdx, String selectQry, boolean isLocSubqry, List<List<DmlArgument>> rows, int rowsNum, @Nullable FastUpdate fastUpdate, @Nullable DmlDistributedPlanInfo distributed, boolean canSelectBeLazy, boolean fillAbsentPKsWithDefaults) {
        this.colNames = colNames;
        this.colTypes = colTypes;
        this.rows = rows;
        this.rowsNum = rowsNum;
        this.fillAbsentPKsWithDefaults = fillAbsentPKsWithDefaults;
        assert (mode != null);
        assert (tbl != null);
        this.mode = mode;
        this.tbl = tbl;
        this.keySupplier = keySupplier;
        this.valSupplier = valSupplier;
        this.keyColIdx = keyColIdx;
        this.valColIdx = valColIdx;
        this.selectQry = selectQry;
        this.isLocSubqry = isLocSubqry;
        this.fastUpdate = fastUpdate;
        this.distributed = distributed;
        this.canSelectBeLazy = canSelectBeLazy;
    }

    public UpdatePlan(UpdateMode mode, GridH2Table tbl, String selectQry, @Nullable FastUpdate fastUpdate, @Nullable DmlDistributedPlanInfo distributed) {
        this(mode, tbl, null, null, null, null, -1, -1, selectQry, false, null, 0, fastUpdate, distributed, true, false);
    }

    public IgniteBiTuple<?, ?> processRow(List<?> row) throws IgniteCheckedException {
        if (this.mode != UpdateMode.BULK_LOAD && row.size() != this.colNames.length) {
            throw new IgniteSQLException("Not enough values in a row: " + row.size() + " instead of " + this.colNames.length, 4005);
        }
        GridH2RowDescriptor rowDesc = this.tbl.rowDescriptor();
        GridQueryTypeDescriptor desc = rowDesc.type();
        GridCacheContext<?, ?> cctx = rowDesc.context();
        Object key = this.keySupplier.apply(row);
        if (QueryUtils.isSqlType((Class)desc.keyClass())) {
            assert (this.keyColIdx != -1);
            key = DmlUtils.convert(key, rowDesc, desc.keyClass(), this.colTypes[this.keyColIdx], this.colNames[this.keyColIdx]);
        }
        Object val = this.valSupplier.apply(row);
        if (QueryUtils.isSqlType((Class)desc.valueClass())) {
            assert (this.valColIdx != -1);
            val = DmlUtils.convert(val, rowDesc, desc.valueClass(), this.colTypes[this.valColIdx], this.colNames[this.valColIdx]);
        }
        if (key == null) {
            if (F.isEmpty((String)desc.keyFieldName())) {
                throw new IgniteSQLException("Key for INSERT, COPY, or MERGE must not be null", 4003);
            }
            throw new IgniteSQLException("Null value is not allowed for column '" + desc.keyFieldName() + "'", 4003);
        }
        if (val == null) {
            if (F.isEmpty((String)desc.valueFieldName())) {
                throw new IgniteSQLException("Value for INSERT, COPY, MERGE, or UPDATE must not be null", 4004);
            }
            throw new IgniteSQLException("Null value is not allowed for column '" + desc.valueFieldName() + "'", 4004);
        }
        int actualColCnt = Math.min(this.colNames.length, row.size());
        HashMap<String, Object> newColVals = new HashMap<String, Object>();
        for (int i = 0; i < actualColCnt; ++i) {
            if (i == this.keyColIdx || i == this.valColIdx) continue;
            String colName = this.colNames[i];
            GridQueryProperty prop = desc.property(colName);
            assert (prop != null);
            Class expCls = prop.type();
            newColVals.put(colName, DmlUtils.convert(row.get(i), rowDesc, expCls, this.colTypes[i], this.colNames[i]));
        }
        desc.setDefaults(key, val);
        Column[] tblCols = this.tbl.getColumns();
        for (int i = 2; i < tblCols.length; ++i) {
            String colName;
            if (this.tbl.rowDescriptor().isKeyValueOrVersionColumn(i) || !newColVals.containsKey(colName = tblCols[i].getName())) continue;
            Object colVal = newColVals.get(colName);
            desc.setValue(colName, key, val, colVal);
        }
        if (cctx.binaryMarshaller()) {
            if (key instanceof BinaryObjectBuilder) {
                key = ((BinaryObjectBuilder)key).build();
            }
            if (val instanceof BinaryObjectBuilder) {
                val = ((BinaryObjectBuilder)val).build();
            }
        }
        desc.validateKeyAndValue(key, val);
        return new IgniteBiTuple(key, val);
    }

    public T3<Object, Object, Object> processRowForUpdate(List<?> row) throws IgniteCheckedException {
        int i;
        GridH2RowDescriptor rowDesc = this.tbl.rowDescriptor();
        GridQueryTypeDescriptor desc = rowDesc.type();
        GridCacheContext<?, ?> cctx = rowDesc.context();
        boolean hasNewVal = this.valColIdx != -1;
        boolean hasProps = !hasNewVal || this.colNames.length > 1;
        Object key = row.get(0);
        Object oldVal = row.get(1);
        if (cctx.binaryMarshaller() && !(oldVal instanceof BinaryObject)) {
            oldVal = cctx.grid().binary().toBinary(oldVal);
        }
        HashMap<String, Object> newColVals = new HashMap<String, Object>();
        for (i = 0; i < this.colNames.length; ++i) {
            if (hasNewVal && i == this.valColIdx - 2) continue;
            GridQueryProperty prop = this.tbl.rowDescriptor().type().property(this.colNames[i]);
            assert (prop != null) : "Unknown property: " + this.colNames[i];
            newColVals.put(this.colNames[i], DmlUtils.convert(row.get(i + 2), rowDesc, prop.type(), this.colTypes[i], this.colNames[i]));
        }
        Object newVal = this.valSupplier.apply(row);
        if (newVal == null) {
            throw new IgniteSQLException("New value for UPDATE must not be null", 4004);
        }
        for (i = 0; i < this.tbl.getColumns().length - 2; ++i) {
            boolean hasNewColVal;
            GridQueryProperty prop;
            Column c = this.tbl.getColumn(i + 2);
            if (rowDesc.isKeyValueOrVersionColumn(c.getColumnId()) || (prop = desc.property(c.getName())).key() || !(hasNewColVal = newColVals.containsKey(c.getName()))) continue;
            Object colVal = newColVals.get(c.getName());
            rowDesc.setColumnValue(null, newVal, colVal, i);
        }
        if (cctx.binaryMarshaller() && hasProps) {
            assert (newVal instanceof BinaryObjectBuilder);
            newVal = ((BinaryObjectBuilder)newVal).build();
        }
        desc.validateKeyAndValue(key, newVal);
        return new T3(key, oldVal, newVal);
    }

    public boolean fastResult() {
        return this.fastUpdate != null;
    }

    public UpdateResult processFast(Object[] args) throws IgniteCheckedException {
        if (this.fastUpdate != null) {
            return this.fastUpdate.execute(this.cacheContext().cache(), args);
        }
        return null;
    }

    public boolean hasRows() {
        return !F.isEmpty(this.rows);
    }

    public List<List<?>> createRows(Object[] args) throws IgniteCheckedException {
        assert (this.rowsNum > 0 && !F.isEmpty((Object[])this.colNames));
        ArrayList res = new ArrayList(this.rowsNum);
        GridH2RowDescriptor desc = this.tbl.rowDescriptor();
        this.extractArgsValues(args, res, desc);
        return res;
    }

    public List<List<List<?>>> createRows(List<Object[]> argss) throws IgniteCheckedException {
        assert (this.rowsNum > 0 && !F.isEmpty((Object[])this.colNames));
        assert (argss != null);
        ArrayList resPerQry = new ArrayList(argss.size());
        GridH2RowDescriptor desc = this.tbl.rowDescriptor();
        for (Object[] args : argss) {
            ArrayList res = new ArrayList();
            resPerQry.add(res);
            this.extractArgsValues(args, res, desc);
        }
        return resPerQry;
    }

    private void extractArgsValues(Object[] args, List<List<?>> res, GridH2RowDescriptor desc) throws IgniteCheckedException {
        assert (res != null);
        for (List<DmlArgument> row : this.rows) {
            ArrayList<Object> resRow = new ArrayList<Object>();
            for (int j = 0; j < this.colNames.length; ++j) {
                Object colVal = this.fillAbsentPKsWithDefaults ? (row.size() > j ? row.get(j).get(args) : null) : row.get(j).get(args);
                if (j == this.keyColIdx || j == this.valColIdx) {
                    Class colCls = j == this.keyColIdx ? desc.type().keyClass() : desc.type().valueClass();
                    colVal = DmlUtils.convert(colVal, desc, colCls, this.colTypes[j], this.colNames[j]);
                }
                resRow.add(colVal);
            }
            res.add(resRow);
        }
    }

    public UpdateSourceIterator<?> iteratorForTransaction(ConnectionManager connMgr, QueryCursor<List<?>> cur) {
        switch (this.mode) {
            case MERGE: {
                return new InsertIterator(cur, this, EnlistOperation.UPSERT);
            }
            case INSERT: {
                return new InsertIterator(cur, this, EnlistOperation.INSERT);
            }
            case UPDATE: {
                return new UpdateIterator(cur, this, EnlistOperation.UPDATE);
            }
            case DELETE: {
                return new DeleteIterator(cur, this, EnlistOperation.DELETE);
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)this.mode));
    }

    public static EnlistOperation enlistOperation(UpdateMode updMode) {
        switch (updMode) {
            case INSERT: {
                return EnlistOperation.INSERT;
            }
            case MERGE: {
                return EnlistOperation.UPSERT;
            }
            case UPDATE: {
                return EnlistOperation.UPDATE;
            }
            case DELETE: {
                return EnlistOperation.DELETE;
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)updMode));
    }

    public UpdateMode mode() {
        return this.mode;
    }

    public GridCacheContext cacheContext() {
        return this.tbl.cacheContext();
    }

    @Nullable
    public DmlDistributedPlanInfo distributedPlan() {
        return this.distributed;
    }

    public int rowCount() {
        return this.rowsNum;
    }

    public String selectQuery() {
        return this.selectQry;
    }

    public boolean isLocalSubquery() {
        return this.isLocSubqry;
    }

    public IgniteBiTuple getFastRow(Object[] args) throws IgniteCheckedException {
        if (this.fastUpdate != null) {
            return this.fastUpdate.getRow(args);
        }
        return null;
    }

    public Object processRowForTx(List<?> row) throws IgniteCheckedException {
        switch (this.mode()) {
            case MERGE: 
            case INSERT: {
                return this.processRow(row);
            }
            case UPDATE: {
                T3<Object, Object, Object> row0 = this.processRowForUpdate(row);
                return new IgniteBiTuple(row0.get1(), row0.get3());
            }
            case DELETE: {
                return row.get(0);
            }
        }
        throw new UnsupportedOperationException(String.valueOf((Object)this.mode()));
    }

    public boolean canSelectBeLazy() {
        return this.canSelectBeLazy;
    }

    private static final class InsertIterator
    extends AbstractIterator {
        private static final long serialVersionUID = -4949035950470324961L;

        private InsertIterator(QueryCursor<List<?>> cur, UpdatePlan plan, EnlistOperation op) {
            super(cur, plan, op);
        }

        @Override
        protected Object process(List<?> row) throws IgniteCheckedException {
            return this.plan.processRow(row);
        }
    }

    private static final class DeleteIterator
    extends AbstractIterator {
        private static final long serialVersionUID = -4949035950470324961L;

        private DeleteIterator(QueryCursor<List<?>> cur, UpdatePlan plan, EnlistOperation op) {
            super(cur, plan, op);
        }

        @Override
        protected Object process(List<?> row) throws IgniteCheckedException {
            return row.get(0);
        }
    }

    private static final class UpdateIterator
    extends AbstractIterator {
        private static final long serialVersionUID = -4949035950470324961L;

        private UpdateIterator(QueryCursor<List<?>> cur, UpdatePlan plan, EnlistOperation op) {
            super(cur, plan, op);
        }

        @Override
        protected Object process(List<?> row) throws IgniteCheckedException {
            T3<Object, Object, Object> row0 = this.plan.processRowForUpdate(row);
            return new IgniteBiTuple(row0.get1(), row0.get3());
        }
    }

    private static abstract class AbstractIterator
    extends GridCloseableIteratorAdapterEx<Object>
    implements UpdateSourceIterator<Object> {
        private final QueryCursor<List<?>> cur;
        protected final UpdatePlan plan;
        private final Iterator<List<?>> it;
        private final EnlistOperation op;

        private AbstractIterator(QueryCursor<List<?>> cur, UpdatePlan plan, EnlistOperation op) {
            this.cur = cur;
            this.plan = plan;
            this.op = op;
            this.it = cur.iterator();
        }

        public EnlistOperation operation() {
            return this.op;
        }

        protected void onClose() {
            this.cur.close();
        }

        protected Object onNext() throws IgniteCheckedException {
            return this.process(this.it.next());
        }

        protected boolean onHasNext() throws IgniteCheckedException {
            return this.it.hasNext();
        }

        protected abstract Object process(List<?> var1) throws IgniteCheckedException;
    }
}

