/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.H2Connection;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class H2PooledConnection
implements AutoCloseable {
    private volatile H2Connection delegate;
    private final ConnectionManager connMgr;
    private final AtomicBoolean closed = new AtomicBoolean();

    H2PooledConnection(H2Connection conn, ConnectionManager connMgr) {
        this.delegate = conn;
        this.connMgr = connMgr;
    }

    public String schema() {
        return this.delegate.schema();
    }

    public void schema(@Nullable String schema) {
        this.delegate.schema(schema);
    }

    public Connection connection() {
        return this.delegate.connection();
    }

    public int statementCacheSize() {
        return this.delegate.statementCacheSize();
    }

    public PreparedStatement prepareStatement(String sql, byte qryFlags) throws IgniteCheckedException {
        return this.delegate.prepareStatement(sql, qryFlags);
    }

    public PreparedStatement prepareStatementNoCache(String sql) throws IgniteCheckedException {
        return this.delegate.prepareStatementNoCache(sql);
    }

    public String toString() {
        return S.toString(H2PooledConnection.class, (Object)this);
    }

    @Override
    public void close() {
        assert (this.delegate != null);
        if (this.closed.compareAndSet(false, true)) {
            H2Utils.resetSession(this);
            this.connMgr.recycle(this.delegate);
            this.delegate = null;
        }
    }
}

