/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.io;

import java.util.Objects;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.io.BasicBulkLoadCommandProcessor;
import org.apache.ignite.internal.processors.io.BulkLoadCommandProcessor;

public class BulkLoadCommandProcessorFactory {
    private final IgniteLogger log;
    private BulkLoadCommandProcessor bulkLoadCommandProcessorExt;
    private final BulkLoadCommandProcessor basicBulkLoadCommandProcessor;

    public BulkLoadCommandProcessorFactory(GridKernalContext ctx) {
        this.log = ctx.log(BulkLoadCommandProcessorFactory.class);
        this.bulkLoadCommandProcessorExt = this.loadFactoryExtension(ctx);
        this.basicBulkLoadCommandProcessor = new BasicBulkLoadCommandProcessor();
    }

    private BulkLoadCommandProcessor loadFactoryExtension(GridKernalContext ctx) {
        BulkLoadCommandProcessor[] ext;
        if (Objects.nonNull(ctx.plugins()) && Objects.nonNull(ext = (BulkLoadCommandProcessor[])ctx.plugins().extensions(BulkLoadCommandProcessor.class))) {
            if (ext.length == 1) {
                return ext[0];
            }
            if (ext.length > 1) {
                this.log.info("More than one BulkLoadFactory extension is defined.");
            }
        }
        return null;
    }

    public BulkLoadCommandProcessor getBulkLoadCommandProcessor(boolean serverBulkloadEnabled) {
        if (this.bulkLoadCommandProcessorExt != null && serverBulkloadEnabled) {
            return this.bulkLoadCommandProcessorExt;
        }
        return this.basicBulkLoadCommandProcessor;
    }
}

