/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.dr.console;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridVisorManagementTask;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.dr.VisorDrCacheFSTTaskResult;
import org.apache.ignite.internal.visor.dr.VisorDrFSTCmdArgs;
import org.apache.ignite.lang.IgniteFuture;
import org.gridgain.grid.GridDr;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.cache.dr.CacheDrStateTransfer;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.jetbrains.annotations.Nullable;

@GridInternal
@GridVisorManagementTask
public class VisorDrProcessFSTTask
extends VisorOneNodeTask<VisorDrFSTCmdArgs, VisorDrCacheFSTTaskResult> {
    private static final long serialVersionUID = 0L;

    protected VisorJob<VisorDrFSTCmdArgs, VisorDrCacheFSTTaskResult> job(VisorDrFSTCmdArgs arg) {
        return new VisorDrCacheJob(arg, this.debug);
    }

    private static class VisorDrCacheJob
    extends VisorJob<VisorDrFSTCmdArgs, VisorDrCacheFSTTaskResult> {
        private static final long serialVersionUID = 0L;

        public VisorDrCacheJob(VisorDrFSTCmdArgs arg, boolean debug) {
            super((Object)arg, debug);
        }

        protected VisorDrCacheFSTTaskResult run(@Nullable VisorDrFSTCmdArgs arg) throws IgniteException {
            VisorDrCacheFSTTaskResult res;
            Objects.requireNonNull(arg, "arg");
            GridGain plugin = (GridGain)this.ignite.plugin("GridGain");
            GridGainConfiguration pluginCfg = plugin.configuration();
            GridDr dr = plugin.dr();
            IgniteFinishedFutureImpl ret = new IgniteFinishedFutureImpl();
            LinkedHashMap transferFuts = null;
            switch (arg.action()) {
                case 0: {
                    transferFuts = new LinkedHashMap();
                    byte[] dcIds0 = new byte[arg.dcIds().size()];
                    int pos = 0;
                    Iterator iterator = arg.dcIds().iterator();
                    while (iterator.hasNext()) {
                        byte by = (Byte)iterator.next();
                        dcIds0[pos++] = by;
                    }
                    Collection<String> caches = this.extractCacheNames(arg, pluginCfg.isDrUseCacheNames());
                    Iterator iterator2 = caches.iterator();
                    while (iterator2.hasNext()) {
                        String cacheName = (String)iterator2.next();
                        if (arg.snapshotId() != -1L) {
                            transferFuts.put(cacheName, dr.incrementalStateTransfer(cacheName, arg.snapshotId(), dcIds0[0]));
                            continue;
                        }
                        transferFuts.put(cacheName, dr.stateTransfer(cacheName, arg.isSyncMode(), dcIds0));
                    }
                    break;
                }
                case 1: {
                    ret = dr.cancelStateTransfer(arg.operationId());
                    break;
                }
                case 2: {
                    Collection<CacheDrStateTransfer> collection = dr.listStateTransfers();
                    ret = new IgniteFinishedFutureImpl(collection);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Action argument [" + arg.action() + "] is not supported.");
                }
            }
            try {
                ret.get();
                switch (arg.action()) {
                    case 0: {
                        StringBuilder strBuf = transferFuts.isEmpty() ? new StringBuilder("No suitable caches found for transfer.") : new StringBuilder();
                        for (Map.Entry entry : transferFuts.entrySet()) {
                            try {
                                ((IgniteFuture)entry.getValue()).get();
                                strBuf.append("Full state transfer command completed successfully for cache: ").append((String)entry.getKey()).append(U.nl());
                            }
                            catch (Exception e) {
                                strBuf.append(String.format("Failed to execute full state transfer for cache \"%s\": %s", entry.getKey(), e.getMessage())).append(U.nl());
                            }
                        }
                        res = new VisorDrCacheFSTTaskResult(pluginCfg.getDataCenterId(), strBuf.toString());
                        break;
                    }
                    case 1: {
                        ret.get();
                        res = new VisorDrCacheFSTTaskResult(pluginCfg.getDataCenterId(), "Full state transfer canceled, task id=" + arg.operationId());
                        break;
                    }
                    case 2: {
                        Collection states = (Collection)ret.get();
                        StringBuilder strBuf = new StringBuilder();
                        states.forEach(s -> strBuf.append(s).append(U.nl()));
                        res = new VisorDrCacheFSTTaskResult(pluginCfg.getDataCenterId(), "Full state transfer states: " + U.nl() + strBuf);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Action argument [" + arg.action() + "] is not supported.");
                    }
                }
            }
            catch (Exception e) {
                String errStr = String.format("Failed to execute incremental state transfer for caches=\"%s\", snapshotId=\"%d\", dcId=\"%s\": %s", arg.caches(), arg.snapshotId(), arg.dcIds(), e.getMessage());
                res = new VisorDrCacheFSTTaskResult(pluginCfg.getDataCenterId(), errStr);
            }
            return res;
        }

        private GridGainCacheConfiguration ggCacheCfg(IgniteInternalCache<?, ?> cachex) {
            return (GridGainCacheConfiguration)GridCacheUtils.cachePluginConfiguration((CacheConfiguration)cachex.configuration(), GridGainCacheConfiguration.class);
        }

        Collection<String> extractCacheNames(VisorDrFSTCmdArgs arg, boolean useCacheNames) {
            HashSet<String> cachesOut = new HashSet<String>();
            Set caches = arg.caches();
            block6: for (String cacheName : this.ignite.cacheNames()) {
                GridGainCacheConfiguration ggCcfg;
                IgniteInternalCache cachex;
                if (!caches.isEmpty() && !caches.contains(cacheName) || (cachex = this.ignite.cachex(cacheName)) == null || CU.isSystemCache((String)cachex.name()) || (ggCcfg = this.ggCacheCfg(cachex)) == null) continue;
                String sndGrp = useCacheNames || ggCcfg.getDrSenderConfiguration() == null ? null : DrUtils.effectiveSenderGroup(ggCcfg.getDrSenderConfiguration());
                switch (arg.senderGroup()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (!useCacheNames && "<default>".equals(sndGrp)) break;
                        continue block6;
                    }
                    case 2: {
                        if (useCacheNames) break;
                        continue block6;
                    }
                    case 3: {
                        if (!useCacheNames && arg.senderGroupName().equals(sndGrp)) break;
                        continue block6;
                    }
                }
                cachesOut.add(cacheName);
            }
            return cachesOut;
        }
    }
}

