/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.license;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.gridgain.grid.internal.processors.license.GridBlockedLicenses;
import org.gridgain.grid.internal.processors.license.GridLicenseFeature;
import org.gridgain.grid.internal.processors.license.GridLicenseLimit;
import org.gridgain.grid.internal.processors.license.GridLicenseProfile;
import org.gridgain.grid.internal.processors.license.GridLicenseV1;
import org.gridgain.grid.internal.processors.license.GridLicenseV2;

public class GridLicenseUtil {
    private static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ofPattern("MM/dd/yyyy").withZone(ZoneId.systemDefault());
    private static final String SIGN_ALG = "SHA1withDSA";
    private static final String SIGN_ALG_BLOCKED_LICENSES_LIST = "SHA256withDSA";
    private static final int MASK = 15;

    private GridLicenseUtil() {
    }

    public static byte[] getDataV1ForSign(GridLicenseV1 lic) {
        assert (lic != null);
        try {
            return new SB().a(lic.getVersion()).a((Object)lic.getId()).a(lic.getIssueDate() != null ? GridLicenseUtil.format(lic.getIssueDate()) : "").a(lic.getIssueOrganization()).a(lic.getUserOrganization()).a(lic.getUserWww()).a(lic.getUserEmail()).a((Object)lic.getType()).a(lic.getExpireDate() != null ? GridLicenseUtil.format(lic.getExpireDate()) : "").a(lic.getMeteringKey1()).a(lic.getMeteringKey2()).a(lic.getMaxCpus()).a(lic.getMaxNodes()).toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public static byte[] getDataV2ForSign(GridLicenseV2 lic, boolean newLims) {
        assert (lic != null);
        switch (lic.getVersion()) {
            case "2.0": {
                return GridLicenseUtil.getDataV20ForSign(lic);
            }
            case "2.1": {
                return GridLicenseUtil.getDataV21ForSign(lic, newLims);
            }
        }
        throw new IgniteException("Unsupported version. [ver=" + lic.getVersion() + "]");
    }

    public static byte[] getDataForSign(GridBlockedLicenses blockedLicenses) {
        assert (blockedLicenses != null);
        return blockedLicenses.getIds().stream().sorted().collect(Collectors.joining(",", "\"gridgain.version\"=\"" + blockedLicenses.getProductVersion() + "\",ids=[", "]")).getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] getDataV20ForSign(GridLicenseV2 lic) {
        try {
            GridStringBuilder sb = new GridStringBuilder().a(lic.getVersion()).a((Object)lic.getId()).a(lic.getIssueDate() != null ? GridLicenseUtil.format(lic.getIssueDate()) : "").a(lic.getIssueOrganization()).a(lic.getUserOrganization()).a(lic.getUserWww()).a(lic.getUserEmail()).a(lic.getUserName()).a(lic.getLicenseNote()).a(lic.getVersionRegexp()).a((Object)lic.getType()).a(lic.getExpireDate() != null ? GridLicenseUtil.format(lic.getExpireDate()) : "").a(lic.getMeteringKey1()).a(lic.getMeteringKey2()).a(lic.getMaxCpus()).a(lic.getMaxComputers()).a(lic.getMaxNodes()).a(lic.getMaxUpTime());
            if (lic.getProfiles() != null) {
                for (GridLicenseProfile profile : lic.getProfiles()) {
                    sb.a((Object)profile);
                }
            }
            if (lic.getEnabledFeatures() != null) {
                for (GridLicenseFeature feature : lic.getEnabledFeatures()) {
                    sb.a((Object)feature);
                }
            }
            return sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public static byte[] getDataV21ForSign(GridLicenseV2 lic, boolean newLims) {
        try {
            GridStringBuilder sb = new GridStringBuilder().a(lic.getVersion()).a((Object)lic.getId()).a(lic.getIssueDate() != null ? GridLicenseUtil.format(lic.getIssueDate()) : "").a(lic.getIssueOrganization()).a(lic.getUserOrganization()).a(lic.getUserWww()).a(lic.getUserEmail()).a(lic.getUserName()).a(lic.getLicenseNote()).a(lic.getVersionRegexp()).a((Object)lic.getType()).a(lic.getExpireDate() != null ? GridLicenseUtil.format(lic.getExpireDate()) : "").a(lic.getMeteringKey1()).a(lic.getMeteringKey2()).a(lic.getMaxCpus()).a(lic.getMaxComputers()).a(lic.getMaxNodes()).a(lic.getMaxUpTime()).a(lic.getGracePeriod()).a(lic.getAttributeName()).a(lic.getAttributeValue()).a(lic.getMaintenanceTime()).a((Object)lic.getClientMode()).a((Object)lic.getUpdateNotifierDisabled());
            if (lic.getProfiles() != null) {
                for (GridLicenseProfile profile : lic.getProfiles()) {
                    sb.a((Object)profile);
                }
            }
            if (lic.getEnabledFeatures() != null) {
                for (GridLicenseFeature feature : lic.getEnabledFeatures()) {
                    sb.a((Object)feature);
                }
            }
            if (newLims && lic.getLimits() != null) {
                for (GridLicenseLimit limit : lic.getLimits()) {
                    sb.a((Object)limit);
                }
            }
            return sb.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public static boolean verifySignatureV1(PublicKey key, GridLicenseV1 lic) throws GeneralSecurityException {
        assert (key != null);
        assert (lic != null);
        byte[] data = GridLicenseUtil.getDataV1ForSign(lic);
        byte[] sign = GridLicenseUtil.hexString2ByteArray(lic.getSignature());
        return GridLicenseUtil.verifySignature(SIGN_ALG, key, data, sign);
    }

    public static boolean verifySignatureV2(PublicKey key, GridLicenseV2 lic) throws GeneralSecurityException {
        boolean newLims;
        assert (key != null);
        assert (lic != null);
        boolean bl = newLims = lic.getEnabledFeatures() != null ? lic.getEnabledFeatures().contains(new GridLicenseFeature("signature2")) : false;
        if (newLims && lic.getSignature2() == null) {
            return false;
        }
        byte[] data = GridLicenseUtil.getDataV2ForSign(lic, newLims);
        byte[] sign = newLims ? GridLicenseUtil.hexString2ByteArray(lic.getSignature2()) : GridLicenseUtil.hexString2ByteArray(lic.getSignature());
        return GridLicenseUtil.verifySignature(SIGN_ALG, key, data, sign);
    }

    public static boolean verifyBlockedLicensesListSignature(PublicKey key, GridBlockedLicenses blockedLicenses) throws GeneralSecurityException {
        assert (key != null);
        assert (blockedLicenses != null);
        byte[] data = GridLicenseUtil.getDataForSign(blockedLicenses);
        byte[] sign = GridLicenseUtil.hexString2ByteArray(blockedLicenses.getSignature());
        return GridLicenseUtil.verifySignature(SIGN_ALG_BLOCKED_LICENSES_LIST, key, data, sign);
    }

    public static boolean verifySignature(String alg, PublicKey key, byte[] data, byte[] sign) throws GeneralSecurityException {
        assert (!F.isEmpty((String)alg));
        assert (key != null);
        assert (data != null);
        assert (sign != null);
        Signature sign0 = Signature.getInstance(alg);
        sign0.initVerify(key);
        sign0.update(data);
        return sign0.verify(sign);
    }

    public static String createSignatureV1(PrivateKey key, GridLicenseV1 lic) throws GeneralSecurityException {
        assert (key != null);
        assert (lic != null);
        byte[] data = GridLicenseUtil.getDataV1ForSign(lic);
        byte[] sign = GridLicenseUtil.createSignature(SIGN_ALG, key, data);
        return GridLicenseUtil.byteArray2HexString(sign);
    }

    public static String createSignatureV2(PrivateKey key, GridLicenseV2 lic) throws GeneralSecurityException {
        assert (key != null);
        assert (lic != null);
        byte[] data = GridLicenseUtil.getDataV2ForSign(lic, false);
        byte[] sign = GridLicenseUtil.createSignature(SIGN_ALG, key, data);
        return GridLicenseUtil.byteArray2HexString(sign);
    }

    public static String createSignatureV3(PrivateKey key, GridLicenseV2 lic) throws GeneralSecurityException {
        assert (key != null);
        assert (lic != null);
        byte[] data = GridLicenseUtil.getDataV2ForSign(lic, true);
        byte[] sign = GridLicenseUtil.createSignature(SIGN_ALG, key, data);
        return GridLicenseUtil.byteArray2HexString(sign);
    }

    public static byte[] createSignature(String alg, PrivateKey key, byte[] data) throws GeneralSecurityException {
        assert (!F.isEmpty((String)alg));
        assert (key != null);
        assert (data != null);
        Signature sign = Signature.getInstance(alg);
        sign.initSign(key);
        sign.update(data);
        return sign.sign();
    }

    public static String format(Date date) {
        return DATE_FMT.format(date.toInstant());
    }

    public static Date parse(String src) throws ParseException {
        Instant instant = LocalDate.parse(src, DATE_FMT).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static String byteArray2HexString(byte[] arr) {
        SB sb = new SB(arr.length << 1);
        for (byte b : arr) {
            sb.a(Integer.toHexString(0xF & b >>> 4)).a(Integer.toHexString(0xF & b));
        }
        return sb.toString().toUpperCase();
    }

    public static byte[] hexString2ByteArray(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            hex = '0' + hex;
        }
        char[] chars = hex.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int byteCnt = 0;
        for (int i = 0; i < chars.length; i += 2) {
            int newByte = 0;
            newByte |= GridLicenseUtil.hexCharToByte(chars[i]);
            newByte <<= 4;
            bytes[byteCnt] = (byte)(newByte |= GridLicenseUtil.hexCharToByte(chars[i + 1]));
            ++byteCnt;
        }
        return bytes;
    }

    private static byte hexCharToByte(char ch) throws IllegalArgumentException {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return (byte)(ch - 48);
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalArgumentException("Hex decoding wrong input character [character=" + ch + ']');
    }
}

