/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr.nio;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;

public class DrNioServerBuffer {
    private byte[] data;
    private int cnt = -4;
    private int msgSize;

    public void reset() {
        this.msgSize = 0;
        this.cnt = -4;
        if (this.data != null && (long)this.data.length > 0x1000000L) {
            this.data = null;
        }
    }

    public ByteBuffer read(ByteBuffer buf) throws IgniteCheckedException {
        int missing;
        int remaining;
        if (this.cnt < 0) {
            while (this.cnt < 0 && buf.hasRemaining()) {
                this.msgSize <<= 8;
                this.msgSize |= buf.get() & 0xFF;
                ++this.cnt;
            }
            if (this.cnt < 0) {
                return null;
            }
            if (this.msgSize <= 0) {
                throw new IgniteCheckedException("Invalid message size: " + this.msgSize);
            }
            if (this.data == null || this.data.length < this.msgSize) {
                this.data = new byte[this.msgSize];
            }
        }
        if ((remaining = buf.remaining()) > 0 && (missing = this.msgSize - this.cnt) > 0) {
            int len = Math.min(missing, remaining);
            buf.get(this.data, this.cnt, len);
            this.cnt += len;
        }
        if (this.cnt == this.msgSize) {
            ByteBuffer res = ByteBuffer.wrap(this.data, 0, this.msgSize);
            this.reset();
            return res;
        }
        return null;
    }
}

