/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.dr;

import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.dr.DrSenderInMetrics;
import org.jetbrains.annotations.Nullable;

class DrSenderInMetricsAggregate
implements DrSenderInMetrics {
    private long batchesReceived;
    private long entriesReceived;
    private long bytesReceived;
    private long batchesRejected;

    public DrSenderInMetricsAggregate() {
    }

    public DrSenderInMetricsAggregate(@Nullable DrSenderInMetrics m) {
        if (m != null) {
            this.batchesReceived = m.batchesReceived();
            this.entriesReceived = m.entriesReceived();
            this.bytesReceived = m.bytesReceived();
            this.batchesRejected = m.batchesRejected();
        }
    }

    @Override
    public int batchesReceived() {
        return (int)this.batchesReceived;
    }

    @Override
    public long entriesReceived() {
        return this.entriesReceived;
    }

    @Override
    public long bytesReceived() {
        return this.bytesReceived;
    }

    @Override
    public int batchesRejected() {
        return (int)this.batchesRejected;
    }

    void aggregate(DrSenderInMetrics m) {
        if (m != null) {
            this.batchesReceived += (long)m.batchesReceived();
            this.entriesReceived += m.entriesReceived();
            this.bytesReceived += m.bytesReceived();
            this.batchesRejected += (long)m.batchesRejected();
        }
    }

    public String toString() {
        return S.toString(DrSenderInMetricsAggregate.class, (Object)this);
    }
}

